/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.mosquitoes.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import mod.vemerion.mosquitoes.capacity.Mosquito;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public class MosquitoModel
extends Model {
    public ModelRenderer bodyLower;
    public ModelRenderer bodyUpper;
    public ModelRenderer head;
    public ModelRenderer tail1;
    public ModelRenderer leg21;
    public ModelRenderer leg31;
    public ModelRenderer leg11;
    public ModelRenderer leg41;
    public ModelRenderer leg51;
    public ModelRenderer leg61;
    public ModelRenderer leftWing;
    public ModelRenderer rightWing;
    public ModelRenderer straw;
    public ModelRenderer strawExtended;
    public ModelRenderer leftTooth;
    public ModelRenderer rightTooth;
    public ModelRenderer tail2;
    public ModelRenderer tail3;
    public ModelRenderer tail4;
    public ModelRenderer tail5;
    public ModelRenderer tail6;
    public ModelRenderer leg22;
    public ModelRenderer leg23;
    public ModelRenderer leg32;
    public ModelRenderer leg33;
    public ModelRenderer leg12;
    public ModelRenderer leg13;
    public ModelRenderer leg42;
    public ModelRenderer leg43;
    public ModelRenderer leg52;
    public ModelRenderer leg53;
    public ModelRenderer leg62;
    public ModelRenderer leg63;
    private float[] legStartRotation;

    public MosquitoModel() {
        super(RenderType::func_228644_e_);
        this.field_78090_t = 64;
        this.field_78089_u = 64;
        this.leg53 = new ModelRenderer((Model)this, 53, 8);
        this.leg53.func_78793_a(0.0f, 8.0f, 0.0f);
        this.leg53.func_228302_a_(-0.5f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leg53, 0.0f, 0.0f, -0.74281216f);
        this.leftTooth = new ModelRenderer((Model)this, 34, 0);
        this.leftTooth.func_78793_a(1.2f, 1.0f, -1.0f);
        this.leftTooth.func_228302_a_(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftTooth, -0.50823987f, 0.0f, 0.0f);
        this.leg12 = new ModelRenderer((Model)this, 38, 17);
        this.leg12.func_78793_a(0.0f, 8.0f, 0.0f);
        this.leg12.func_228302_a_(-0.5f, 0.0f, -0.5f, 1.0f, 8.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leg12, 0.0f, 0.0f, 2.242399f);
        this.head = new ModelRenderer((Model)this, 24, 0);
        this.head.func_78793_a(0.0f, 1.0f, -4.0f);
        this.head.func_228302_a_(-1.5f, -1.0f, -1.0f, 3.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.head, 0.19547687f, 0.0f, 0.0f);
        this.leg22 = new ModelRenderer((Model)this, 38, 17);
        this.leg22.func_78793_a(0.0f, 8.0f, 0.0f);
        this.leg22.func_228302_a_(-0.5f, 0.0f, -0.5f, 1.0f, 8.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leg22, 0.0f, 0.0f, 2.242399f);
        this.leg42 = new ModelRenderer((Model)this, 38, 17);
        this.leg42.func_78793_a(0.0f, 8.0f, 0.0f);
        this.leg42.func_228302_a_(-0.5f, 0.0f, -0.5f, 1.0f, 8.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leg42, 0.0f, 0.0f, 2.242399f);
        this.leg23 = new ModelRenderer((Model)this, 53, 8);
        this.leg23.func_78793_a(0.0f, 8.0f, 0.0f);
        this.leg23.func_228302_a_(-0.5f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leg23, 0.0f, 0.0f, -0.74281216f);
        this.leg61 = new ModelRenderer((Model)this, 59, 3);
        this.leg61.func_78793_a(-2.0f, 1.0f, 1.0f);
        this.leg61.func_228302_a_(-0.5f, 0.0f, -0.5f, 1.0f, 8.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leg61, 2.3460715f, 0.7819075f, -1.1337658f);
        this.rightTooth = new ModelRenderer((Model)this, 34, 0);
        this.rightTooth.func_78793_a(-1.2f, 1.0f, -1.0f);
        this.rightTooth.func_228302_a_(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightTooth, -0.50823987f, 0.0f, 0.0f);
        this.leg21 = new ModelRenderer((Model)this, 59, 3);
        this.leg21.func_78793_a(2.0f, 1.0f, 0.0f);
        this.leg21.func_228302_a_(-0.5f, 0.0f, -0.5f, 1.0f, 8.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leg21, 0.35185838f, -0.19547687f, -2.3458972f);
        this.tail3 = new ModelRenderer((Model)this, 0, 10);
        this.tail3.func_78793_a(0.0f, 0.0f, 6.0f);
        this.tail3.func_228302_a_(-3.5f, -3.5f, -1.5f, 7.0f, 7.0f, 3.0f, 0.0f, 0.0f, 0.0f);
        this.leg52 = new ModelRenderer((Model)this, 38, 17);
        this.leg52.func_78793_a(0.0f, 8.0f, 0.0f);
        this.leg52.func_228302_a_(-0.5f, 0.0f, -0.5f, 1.0f, 8.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leg52, 0.0f, 0.0f, 2.242399f);
        this.leg33 = new ModelRenderer((Model)this, 53, 8);
        this.leg33.func_78793_a(0.0f, 8.0f, 0.0f);
        this.leg33.func_228302_a_(-0.5f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leg33, 0.0f, 0.0f, -0.74281216f);
        this.tail1 = new ModelRenderer((Model)this, 38, 0);
        this.tail1.func_78793_a(0.0f, -3.0f, 4.0f);
        this.tail1.func_228302_a_(-2.5f, -2.5f, -1.5f, 5.0f, 5.0f, 3.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.tail1, -0.19547687f, 0.0f, 0.0f);
        this.tail5 = new ModelRenderer((Model)this, 51, 15);
        this.tail5.func_78793_a(0.0f, 0.0f, 11.5f);
        this.tail5.func_228302_a_(-2.0f, -2.0f, -1.0f, 4.0f, 4.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.leg41 = new ModelRenderer((Model)this, 59, 3);
        this.leg41.func_78793_a(-2.0f, 1.0f, -1.0f);
        this.leg41.func_228302_a_(-0.5f, 0.0f, -0.5f, 1.0f, 8.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leg41, 3.063402f, -0.3504621f, -0.54733527f);
        this.leg43 = new ModelRenderer((Model)this, 53, 8);
        this.leg43.func_78793_a(0.0f, 8.0f, 0.0f);
        this.leg43.func_228302_a_(-0.5f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leg43, 0.0f, 0.0f, -0.7330383f);
        this.tail2 = new ModelRenderer((Model)this, 35, 8);
        this.tail2.func_78793_a(0.0f, 0.0f, 3.0f);
        this.tail2.func_228302_a_(-3.0f, -3.0f, -1.5f, 6.0f, 6.0f, 3.0f, 0.0f, 0.0f, 0.0f);
        this.tail4 = new ModelRenderer((Model)this, 20, 14);
        this.tail4.func_78793_a(0.0f, 0.0f, 9.0f);
        this.tail4.func_228302_a_(-3.0f, -3.0f, -1.5f, 6.0f, 6.0f, 3.0f, 0.0f, 0.0f, 0.0f);
        this.leftWing = new ModelRenderer((Model)this, -16, 20);
        this.leftWing.func_78793_a(2.0f, -1.0f, 4.0f);
        this.leftWing.func_228302_a_(-2.5f, 0.0f, 0.0f, 5.0f, 0.0f, 16.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftWing, -0.39095375f, 0.2f, 0.0f);
        this.leg13 = new ModelRenderer((Model)this, 53, 8);
        this.leg13.func_78793_a(0.0f, 8.0f, 0.0f);
        this.leg13.func_228302_a_(-0.5f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leg13, 0.0f, 0.0f, -0.7330383f);
        this.leg51 = new ModelRenderer((Model)this, 59, 3);
        this.leg51.func_78793_a(-2.0f, 1.0f, 0.0f);
        this.leg51.func_228302_a_(-0.5f, 0.0f, -0.5f, 1.0f, 8.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leg51, 2.9070203f, 0.12077679f, -0.8210029f);
        this.tail6 = new ModelRenderer((Model)this, 56, 0);
        this.tail6.func_78793_a(0.0f, 0.0f, 13.0f);
        this.tail6.func_228302_a_(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.rightWing = new ModelRenderer((Model)this, -6, 20);
        this.rightWing.func_78793_a(-2.0f, -1.0f, 4.0f);
        this.rightWing.func_228302_a_(-2.5f, 0.0f, 0.0f, 5.0f, 0.0f, 16.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightWing, -0.39095375f, -0.2f, 0.0f);
        this.bodyUpper = new ModelRenderer((Model)this, 7, 0);
        this.bodyUpper.func_78793_a(0.0f, -3.0f, -2.0f);
        this.bodyUpper.func_228302_a_(-2.5f, -1.5f, -2.5f, 5.0f, 3.0f, 7.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.bodyUpper, 0.54733527f, 0.0f, 0.0f);
        this.leg31 = new ModelRenderer((Model)this, 59, 3);
        this.leg31.func_78793_a(2.0f, 1.0f, 1.0f);
        this.leg31.func_228302_a_(-0.5f, 0.0f, -0.5f, 1.0f, 8.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leg31, 0.89919364f, 0.625526f, -1.9940387f);
        this.leg62 = new ModelRenderer((Model)this, 38, 17);
        this.leg62.func_78793_a(0.0f, 8.0f, 0.0f);
        this.leg62.func_228302_a_(-0.5f, 0.0f, -0.5f, 1.0f, 8.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leg62, 0.0f, 0.0f, 2.242399f);
        this.straw = new ModelRenderer((Model)this, 34, 0);
        this.straw.func_78793_a(0.0f, 1.0f, -1.0f);
        this.straw.func_228302_a_(-0.5f, 0.0f, -0.5f, 1.0f, 10.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.bodyLower = new ModelRenderer((Model)this, 0, 0);
        this.bodyLower.func_78793_a(0.0f, 0.0f, -2.0f);
        this.bodyLower.func_228302_a_(-2.0f, -2.0f, -1.5f, 4.0f, 4.0f, 3.0f, 0.0f, 0.0f, 0.0f);
        this.leg32 = new ModelRenderer((Model)this, 38, 17);
        this.leg32.func_78793_a(0.0f, 8.0f, 0.0f);
        this.leg32.func_228302_a_(-0.5f, 0.0f, -0.5f, 1.0f, 8.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leg32, 0.0f, 0.0f, 2.242399f);
        this.leg63 = new ModelRenderer((Model)this, 53, 8);
        this.leg63.func_78793_a(0.0f, 8.0f, 0.0f);
        this.leg63.func_228302_a_(-0.5f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leg63, 0.0f, 0.0f, -0.74281216f);
        this.leg11 = new ModelRenderer((Model)this, 59, 3);
        this.leg11.func_78793_a(2.0f, 1.0f, -1.0f);
        this.leg11.func_228302_a_(-0.5f, 0.0f, -0.5f, 1.0f, 8.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leg11, -0.312763f, -0.6646214f, -2.3068016f);
        this.strawExtended = new ModelRenderer((Model)this, 34, 0);
        this.strawExtended.func_78793_a(0.0f, 0.0f, 0.0f);
        this.strawExtended.func_228302_a_(-0.5f, 0.0f, -0.5f, 1.0f, 10.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.leg52.func_78792_a(this.leg53);
        this.head.func_78792_a(this.leftTooth);
        this.leg11.func_78792_a(this.leg12);
        this.bodyLower.func_78792_a(this.head);
        this.leg21.func_78792_a(this.leg22);
        this.leg41.func_78792_a(this.leg42);
        this.leg22.func_78792_a(this.leg23);
        this.bodyLower.func_78792_a(this.leg61);
        this.head.func_78792_a(this.rightTooth);
        this.bodyLower.func_78792_a(this.leg21);
        this.leg51.func_78792_a(this.leg52);
        this.leg32.func_78792_a(this.leg33);
        this.bodyLower.func_78792_a(this.leg41);
        this.leg42.func_78792_a(this.leg43);
        this.bodyUpper.func_78792_a(this.leftWing);
        this.leg12.func_78792_a(this.leg13);
        this.bodyLower.func_78792_a(this.leg51);
        this.bodyUpper.func_78792_a(this.rightWing);
        this.bodyLower.func_78792_a(this.bodyUpper);
        this.bodyLower.func_78792_a(this.leg31);
        this.leg61.func_78792_a(this.leg62);
        this.head.func_78792_a(this.straw);
        this.leg31.func_78792_a(this.leg32);
        this.leg62.func_78792_a(this.leg63);
        this.bodyLower.func_78792_a(this.leg11);
        this.straw.func_78792_a(this.strawExtended);
        this.legStartRotation = new float[]{this.leg11.field_78808_h, this.leg21.field_78808_h, this.leg31.field_78808_h, this.leg41.field_78808_h, this.leg51.field_78808_h, this.leg61.field_78808_h};
    }

    public void renderMosquito(MatrixStack matrix, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, Mosquito mosquito, float partialTicks) {
        float ageInTicks = (float)mosquito.ticksExisted() + partialTicks;
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)mosquito.getX(partialTicks), (double)mosquito.getY(partialTicks), (double)mosquito.getZ(partialTicks));
        matrix.func_227863_a_(new Quaternion(mosquito.getRotationX(), mosquito.getRotationY(), 0.0f, true));
        float scale = mosquito.getScale(partialTicks);
        matrix.func_227862_a_(scale, scale, scale);
        float period = 10.0f;
        float size = 0.22f;
        float offset = 3.0f;
        float suckingDuration = ageInTicks - (float)mosquito.startsSuckingAfter();
        this.bodyLower.func_228308_a_(matrix, bufferIn, packedLightIn, packedOverlayIn);
        matrix.func_227860_a_();
        this.bodyLower.func_228307_a_(matrix);
        ImmutableList tails = ImmutableList.of((Object)this.tail1, (Object)this.tail2, (Object)this.tail3, (Object)this.tail4, (Object)this.tail5, (Object)this.tail6);
        for (int i = 0; i < tails.size(); ++i) {
            matrix.func_227860_a_();
            if (suckingDuration >= offset * (float)i) {
                matrix.func_227862_a_(1.0f + MathHelper.func_76135_e((float)MathHelper.func_76126_a((float)((suckingDuration - offset * (float)i) / period))) * size, 1.0f + MathHelper.func_76135_e((float)MathHelper.func_76126_a((float)((suckingDuration - offset) / period))) * size, 1.0f);
            }
            ((ModelRenderer)tails.get(i)).func_228308_a_(matrix, bufferIn, packedLightIn, packedOverlayIn);
            matrix.func_227865_b_();
            if (i != 0) continue;
            this.tail1.func_228307_a_(matrix);
        }
        matrix.func_227865_b_();
        matrix.func_227865_b_();
    }

    public void animate(Mosquito mosquito, float partialTicks) {
        float ageInTicks = (float)mosquito.ticksExisted() + partialTicks;
        boolean bl = this.strawExtended.field_78806_j = !mosquito.isFlying();
        if (!mosquito.isFlying()) {
            this.strawExtended.field_78797_d = MathHelper.func_76131_a((float)((ageInTicks - (float)mosquito.arrivingDuration()) / 2.0f), (float)0.0f, (float)10.0f);
        }
        this.tail1.field_78795_f = (float)((double)MathHelper.func_76134_b((float)(ageInTicks / 60.0f * (float)Math.PI * 2.0f)) * Math.toRadians(4.0) + Math.toRadians(-20.0));
        if (!mosquito.isFlying()) {
            this.leftTooth.field_78808_h = (float)((double)MathHelper.func_76134_b((float)(ageInTicks / 15.0f * (float)Math.PI * 2.0f)) * Math.toRadians(10.0));
            this.rightTooth.field_78808_h = (float)(-((double)MathHelper.func_76134_b((float)(ageInTicks / 15.0f * (float)Math.PI * 2.0f)) * Math.toRadians(10.0)));
        }
        if (mosquito.isFlying()) {
            this.leftWing.field_78795_f = (float)((double)MathHelper.func_76134_b((float)(ageInTicks / 2.0f * (float)Math.PI * 2.0f)) * Math.toRadians(35.0) - Math.toRadians(20.0));
            this.rightWing.field_78795_f = (float)((double)MathHelper.func_76134_b((float)((ageInTicks + 0.2f) / 2.0f * (float)Math.PI * 2.0f)) * Math.toRadians(35.0) - Math.toRadians(20.0));
        } else {
            this.leftWing.field_78795_f = (float)(-Math.toRadians(20.0));
            this.rightWing.field_78795_f = (float)(-Math.toRadians(20.0));
        }
        ImmutableList outerLegs = ImmutableList.of((Object)this.leg13, (Object)this.leg23, (Object)this.leg33, (Object)this.leg43, (Object)this.leg53, (Object)this.leg63);
        ImmutableList innerLegs = ImmutableList.of((Object)this.leg11, (Object)this.leg21, (Object)this.leg31, (Object)this.leg41, (Object)this.leg51, (Object)this.leg61);
        if (mosquito.isFlying()) {
            outerLegs.forEach(leg -> {
                leg.field_78808_h = (float)Math.toRadians(30.0);
            });
            for (int i = 0; i < this.legStartRotation.length; ++i) {
                ((ModelRenderer)innerLegs.get((int)i)).field_78808_h = this.legStartRotation[i] + (float)Math.toRadians(mosquito.getLegRotation(partialTicks));
            }
        } else {
            outerLegs.forEach(leg -> {
                leg.field_78808_h = (float)Math.toRadians(-40.0);
            });
            for (int i = 0; i < this.legStartRotation.length; ++i) {
                ((ModelRenderer)innerLegs.get((int)i)).field_78808_h = this.legStartRotation[i];
            }
        }
    }

    public void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
    }
}

