/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.dependency;

import info.u_team.music_player.dependency.classloader.DependencyClassLoader;
import info.u_team.music_player.dependency.url.URLStreamHandlerMusicPlayer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class DependencyManager {
    private static final Logger logger = LogManager.getLogger();
    private static final Marker load = MarkerManager.getMarker((String)"Load");
    private static final DependencyClassLoader musicplayerclassloader = new DependencyClassLoader();

    public static void construct() {
        logger.info(load, "Load dependencies");
        String devPath = System.getProperty("musicplayer.dev");
        if (devPath != null) {
            DependencyManager.getJarFilesInDev(Paths.get(devPath, "musicplayer-lavaplayer/build/libs"), DependencyManager::addToMusicPlayerDependencies);
            DependencyManager.getJarFilesInDev(Paths.get(devPath, "musicplayer-lavaplayer/build/dependencies"), DependencyManager::addToMusicPlayerDependencies);
        } else {
            DependencyManager.tryUrlHandlerFactory();
            DependencyManager.getJarFilesInJar("dependencies/internal", path -> DependencyManager.addToInternalDependencies(DependencyManager.createInternalURL(path)));
            DependencyManager.getJarFilesInJar("dependencies/musicplayer", path -> DependencyManager.addToMusicPlayerDependencies(DependencyManager.createInternalURL(path)));
            DependencyManager.fixSLF4JLogger();
            DependencyManager.fixTinyFDLoadLWJGL();
        }
        logger.info(load, "Finished loading dependencies");
    }

    public static DependencyClassLoader getClassLoader() {
        return musicplayerclassloader;
    }

    private static void getJarFilesInDev(Path path, Consumer<Path> consumer) {
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
            stream.filter(file -> file.toString().endsWith(".jar")).forEach(consumer);
        }
        catch (IOException ex) {
            logger.error(load, "When searching for jar files in dev an exception occured.", (Throwable)ex);
        }
    }

    private static void getJarFilesInJar(String folder, Consumer<Path> consumer) {
        try (FileSystem fileSystem = FileSystems.newFileSystem(DependencyManager.class.getResource("/dependencies").toURI(), Collections.emptyMap());
             Stream<Path> stream = Files.walk(fileSystem.getPath("/" + folder, new String[0]), new FileVisitOption[0]);){
            stream.filter(file -> file.toString().endsWith(".jar")).forEach(consumer);
        }
        catch (Exception ex) {
            logger.error(load, "When searching for jar files in jar an exception occured.", (Throwable)ex);
        }
    }

    private static URL createInternalURL(Path path) {
        String url = "musicplayer:" + path.toString().substring(1);
        logger.debug(load, "Load url " + url);
        try {
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            logger.error(load, "Could not create url from internal path", (Throwable)ex);
            return null;
        }
    }

    private static void addToMusicPlayerDependencies(URL url) {
        musicplayerclassloader.addURL(url);
    }

    private static void addToMusicPlayerDependencies(Path path) {
        musicplayerclassloader.addPath(path);
    }

    private static void addToInternalDependencies(URL url) {
        try {
            LaunchClassLoader launchclassloader = (LaunchClassLoader)DependencyManager.class.getClassLoader();
            launchclassloader.addURL(url);
        }
        catch (Exception ex) {
            logger.error(load, "Method addURL on launch class loader could not be invoked", (Throwable)ex);
        }
    }

    private static void tryUrlHandlerFactory() {
        try {
            URL.setURLStreamHandlerFactory(protocol -> "musicplayer".equals(protocol) ? new URLStreamHandlerMusicPlayer() : null);
        }
        catch (Error error) {
            try {
                Field field = URL.class.getDeclaredField("factory");
                field.setAccessible(true);
                URLStreamHandlerFactory oldFactory = (URLStreamHandlerFactory)field.get(null);
                URLStreamHandlerFactory newFactory = protocol -> "musicplayer".equals(protocol) ? new URLStreamHandlerMusicPlayer() : (oldFactory != null ? oldFactory.createURLStreamHandler(protocol) : null);
                field.set(null, newFactory);
            }
            catch (Exception ex) {
                logger.error(load, "Could not replace url stream handler because reflections failed.", (Throwable)ex);
            }
        }
    }

    private static void fixSLF4JLogger() {
        try {
            String slf4jLoggerFactory = "org.slf4j.LoggerFactory";
            LaunchClassLoader launchClassLoader = (LaunchClassLoader)DependencyManager.class.getClassLoader();
            Set invalidClasses = (Set)ReflectionHelper.getPrivateValue(LaunchClassLoader.class, (Object)launchClassLoader, (String[])new String[]{"invalidClasses"});
            Set negativeResourceCache = (Set)ReflectionHelper.getPrivateValue(LaunchClassLoader.class, (Object)launchClassLoader, (String[])new String[]{"negativeResourceCache"});
            invalidClasses.remove("org.slf4j.LoggerFactory");
            negativeResourceCache.remove("org.slf4j.LoggerFactory");
        }
        catch (Exception ex) {
            logger.error(load, "Can't fix slf4j logger.", (Throwable)ex);
        }
    }

    private static void fixTinyFDLoadLWJGL() {
        try {
            String tinyFDClass = "org.lwjgl.util.tinyfd.TinyFileDialogs";
            String lwjglExclusion = "org.lwjgl.";
            LaunchClassLoader launchClassLoader = (LaunchClassLoader)DependencyManager.class.getClassLoader();
            Set classLoaderExceptions = (Set)ReflectionHelper.getPrivateValue(LaunchClassLoader.class, (Object)launchClassLoader, (String[])new String[]{"classLoaderExceptions"});
            classLoaderExceptions.remove("org.lwjgl.");
            launchClassLoader.loadClass("org.lwjgl.util.tinyfd.TinyFileDialogs");
            classLoaderExceptions.add("org.lwjgl.");
        }
        catch (Exception ex) {
            logger.error(load, "Can't fix tinyfd load lwjgl", (Throwable)ex);
        }
    }
}

