/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.playlist;

import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntry;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntryError;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntryFunctions;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntryLoading;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntryMusicTrack;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntryPlaylistStart;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntryPlaylistTrack;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.playlist.LoadedTracks;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.music_player.musicplayer.playlist.Playlists;
import info.u_team.u_team_core.gui.elements.GuiScrollableList;
import java.util.ArrayList;

public class GuiMusicPlaylistList
extends GuiScrollableList<GuiMusicPlaylistListEntry> {
    private final Playlist playlist;
    private boolean tracksLoaded;
    private boolean canSelectNext;

    public GuiMusicPlaylistList(Playlist playlist) {
        super(0, 0, 0, 0, 0, 0, 40, 20, 5);
        this.playlist = playlist;
        this.canSelectNext = true;
        this.addEntry(new GuiMusicPlaylistListEntryLoading());
    }

    private void addLoadedTrackToGui(LoadedTracks loadedTracks) {
        Playlists playlists = MusicPlayerManager.getPlaylistManager().getPlaylists();
        ArrayList<GuiMusicPlaylistListEntryFunctions> list = new ArrayList<GuiMusicPlaylistListEntryFunctions>();
        if (loadedTracks.hasError()) {
            list.add(new GuiMusicPlaylistListEntryError(this, playlists, this.playlist, loadedTracks, loadedTracks.getErrorMessage()));
        } else if (loadedTracks.isTrack()) {
            list.add(new GuiMusicPlaylistListEntryMusicTrack(this, playlists, this.playlist, loadedTracks));
        } else {
            GuiMusicPlaylistListEntryPlaylistStart start = new GuiMusicPlaylistListEntryPlaylistStart(this, playlists, this.playlist, loadedTracks);
            list.add(start);
            loadedTracks.getTrackList().getTracks().forEach(track -> {
                GuiMusicPlaylistListEntryPlaylistTrack entry = new GuiMusicPlaylistListEntryPlaylistTrack(start, playlists, this.playlist, loadedTracks, (IAudioTrack)track);
                start.addEntry(entry);
                list.add((GuiMusicPlaylistListEntryFunctions)((Object)entry));
            });
        }
        list.forEach(this::addEntry);
    }

    public void addAllEntries() {
        if (!this.playlist.isLoaded()) {
            return;
        }
        if (!this.tracksLoaded) {
            this.clearEntries();
            this.playlist.getLoadedTracks().forEach(this::addLoadedTrackToGui);
            this.tracksLoaded = true;
        }
    }

    public void removeAllEntries() {
        this.clearEntries();
        this.tracksLoaded = false;
    }

    public void updateAllEntries() {
        this.removeAllEntries();
        this.addAllEntries();
    }

    @Override
    protected boolean isSelected(int index) {
        return index == this.selectedElement;
    }

    public void setSelectedEntryWhenMove(int index) {
        if (index >= 0 || index < this.getSize()) {
            super.setSelectedEntry(index);
            this.canSelectNext = false;
        }
    }

    @Override
    public void setSelectedEntry(int index) {
        if (this.canSelectNext) {
            super.setSelectedEntry(index);
        } else {
            this.canSelectNext = true;
        }
    }

    public void tick() {
        this.getChildren().forEach(GuiMusicPlaylistListEntry::tick);
    }
}

