/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.playlist.search;

import info.u_team.music_player.gui.playlist.GuiMusicPlaylist;
import info.u_team.music_player.gui.playlist.search.GuiMusicSearchList;
import info.u_team.music_player.gui.playlist.search.GuiMusicSearchListEntryMusicTrack;
import info.u_team.music_player.gui.playlist.search.GuiMusicSearchListEntryPlaylist;
import info.u_team.music_player.gui.playlist.search.SearchProvider;
import info.u_team.music_player.init.MusicPlayerLocalization;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrackList;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.u_team_core.gui.elements.GuiButtonClick;
import info.u_team.u_team_core.gui.elements.GuiButtonClickImage;
import info.u_team.u_team_core.gui.elements.backport.GuiScreen1_13;
import info.u_team.u_team_core.gui.elements.backport.GuiTextFieldNew;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class GuiMusicSearch
extends GuiScreen1_13 {
    private final Playlist playlist;
    private GuiTextFieldNew urlField;
    private GuiTextFieldNew searchField;
    private final GuiMusicSearchList searchList;
    private SearchProvider searchProvider;
    private String information;
    private int informationTicks;
    private int maxTicksInformation;

    public GuiMusicSearch(Playlist playlist) {
        this.playlist = playlist;
        this.searchList = new GuiMusicSearchList();
        this.searchProvider = SearchProvider.YOUTUBE;
    }

    public void func_73866_w_() {
        GuiButtonClick backButton = this.addNewButton(new GuiButtonClickImage(1, 1, 15, 15, MusicPlayerResources.textureBack));
        backButton.setClickAction(() -> this.field_146297_k.func_147108_a((GuiScreen)new GuiMusicPlaylist(this.playlist)));
        this.urlField = new GuiTextFieldNew(-1, this.field_146297_k.field_71466_p, 10, 35, this.field_146294_l / 2 - 10, 20){

            @Override
            public boolean keyPressed(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
                GuiMusicSearch.this.keyFromTextField(this, this.getText(), key);
                return super.keyPressed(key, p_keyPressed_2_, p_keyPressed_3_);
            }
        };
        this.urlField.setMaxStringLength(10000);
        this.children.add(this.urlField);
        GuiButtonClick openFileButton = this.addNewButton(new GuiButtonClick(this.field_146294_l / 2 + 10, 34, this.field_146294_l / 4 - 15, 22, MusicPlayerLocalization.getTranslation("gui.search.load.file", new Object[0])));
        openFileButton.setClickAction(() -> {
            String response = TinyFileDialogs.openFileDialog(MusicPlayerLocalization.getTranslation("gui.search.load.file", new Object[0]), null, MusicPlayerLocalization.getTranslation("gui.search.music_files", new Object[0]), false);
            if (response != null) {
                this.searchList.clear();
                this.addTrack(response);
            }
        });
        GuiButtonClick openFolderButton = this.addNewButton(new GuiButtonClick((int)((double)this.field_146294_l * 0.75) + 5, 34, this.field_146294_l / 4 - 15, 22, MusicPlayerLocalization.getTranslation("gui.search.load.folder", new Object[0])));
        openFolderButton.setClickAction(() -> {
            String response = TinyFileDialogs.selectFolderDialog(MusicPlayerLocalization.getTranslation("gui.search.load.folder", new Object[0]), System.getProperty("user.home"));
            if (response != null) {
                this.searchList.clear();
                try (Stream<Path> stream = Files.list(Paths.get(response, new String[0]));){
                    stream.filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> this.addTrack(path.toString()));
                }
                catch (IOException ex) {
                    this.setInformation(TextFormatting.RED + ex.getMessage(), 150);
                }
            }
        });
        GuiButtonClickImage searchButton = this.addNewButton(new GuiButtonClickImage(10, 76, 24, 24, this.searchProvider.getLogo()));
        searchButton.setClickAction(() -> {
            this.searchProvider = SearchProvider.toggle(this.searchProvider);
            searchButton.setResource(this.searchProvider.getLogo());
        });
        this.searchField = new GuiTextFieldNew(-1, this.field_146297_k.field_71466_p, 40, 78, this.field_146294_l - 51, 20){

            @Override
            public boolean keyPressed(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
                GuiMusicSearch.this.keyFromTextField(this, GuiMusicSearch.this.searchProvider.getPrefix() + this.getText(), key);
                return super.keyPressed(key, p_keyPressed_2_, p_keyPressed_3_);
            }
        };
        this.searchField.setMaxStringLength(1000);
        this.searchField.setFocused(true);
        this.setFocused(this.searchField);
        this.children.add(this.searchField);
        GuiButtonClick addAllButton = this.addNewButton(new GuiButtonClick(this.field_146294_l - 110, 105, 100, 20, MusicPlayerLocalization.getTranslation("gui.search.add_all", new Object[0])));
        addAllButton.setClickAction(() -> {
            List<GuiMusicSearchListEntryPlaylist> list = this.searchList.getChildren().stream().filter(entry -> entry instanceof GuiMusicSearchListEntryPlaylist).map(entry -> (GuiMusicSearchListEntryPlaylist)entry).collect(Collectors.toList());
            if (list.size() > 0) {
                list.forEach(entry -> this.playlist.add(entry.getTrackList()));
            } else {
                this.searchList.getChildren().stream().filter(entry -> entry instanceof GuiMusicSearchListEntryMusicTrack).map(entry -> (GuiMusicSearchListEntryMusicTrack)entry).filter(entry -> !entry.isPlaylistEntry()).forEach(entry -> this.playlist.add(entry.getTrack()));
            }
            this.setInformation(TextFormatting.GREEN + MusicPlayerLocalization.getTranslation("gui.search.added_all", new Object[0]), 150);
        });
        this.searchList.updateSettings(this.field_146294_l - 24, this.field_146295_m, 130, this.field_146295_m - 10, 12, this.field_146294_l - 12);
        this.children.add(this.searchList);
        super.func_73866_w_();
    }

    public void func_175273_b(Minecraft minecraft, int width, int height) {
        String urlFieldText = this.urlField.getText();
        boolean urlFieldFocus = this.urlField.isFocused() && this.getFocused() == this.urlField;
        String searchFieldText = this.searchField.getText();
        boolean searchFieldFocus = this.searchField.isFocused() && this.getFocused() == this.searchField;
        this.func_146280_a(minecraft, width, height);
        this.urlField.setText(urlFieldText);
        this.urlField.setFocused(urlFieldFocus);
        if (urlFieldFocus) {
            this.setFocused(this.urlField);
        }
        this.searchField.setText(searchFieldText);
        this.searchField.setFocused(searchFieldFocus);
        if (searchFieldFocus) {
            this.setFocused(this.searchField);
        }
    }

    public void func_73876_c() {
        this.urlField.tick();
        this.searchField.tick();
        ++this.informationTicks;
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146278_c(0);
        this.searchList.drawScreen(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146297_k.field_71466_p, MusicPlayerLocalization.getTranslation("gui.search.header", new Object[0]), this.field_146294_l / 2, 5, 0xFFFFFF);
        this.func_73731_b(this.field_146297_k.field_71466_p, MusicPlayerLocalization.getTranslation("gui.search.search.uri", new Object[0]), 10, 20, 0xFFFFFF);
        this.func_73731_b(this.field_146297_k.field_71466_p, MusicPlayerLocalization.getTranslation("gui.search.search.file", new Object[0]), 10 + this.field_146294_l / 2, 20, 0xFFFFFF);
        this.func_73731_b(this.field_146297_k.field_71466_p, MusicPlayerLocalization.getTranslation("gui.search.search.search", new Object[0]), 10, 63, 0xFFFFFF);
        if (this.information != null && this.informationTicks <= this.maxTicksInformation) {
            this.func_73731_b(this.field_146297_k.field_71466_p, this.information, 15, 110, 0xFFFFFF);
        }
        this.urlField.drawTextField(mouseX, mouseY, partialTicks);
        this.searchField.drawTextField(mouseX, mouseY, partialTicks);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void setInformation(String information, int maxTicksInformation) {
        this.information = information;
        this.maxTicksInformation = maxTicksInformation;
        this.informationTicks = 0;
    }

    private void keyFromTextField(GuiTextFieldNew field, String text, int key) {
        if (field.getVisible() && field.isFocused() && (key == 28 || key == 156)) {
            this.searchList.clear();
            this.addTrack(text);
            field.setText("");
        }
    }

    private void addTrack(String uri) {
        MusicPlayerManager.getPlayer().getTrackSearch().getTracks(uri, result -> this.field_146297_k.func_152344_a(() -> {
            if (result.hasError()) {
                this.setInformation(TextFormatting.RED + result.getErrorMessage(), 150);
            } else if (result.isList()) {
                IAudioTrackList list = result.getTrackList();
                if (!list.isSearch()) {
                    this.searchList.add(new GuiMusicSearchListEntryPlaylist(this, this.playlist, list));
                }
                list.getTracks().forEach(track -> this.searchList.add(new GuiMusicSearchListEntryMusicTrack(this, this.playlist, (IAudioTrack)track, !list.isSearch())));
            } else {
                IAudioTrack track2 = result.getTrack();
                this.searchList.add(new GuiMusicSearchListEntryMusicTrack(this, this.playlist, track2, false));
            }
        }));
    }
}

