/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.musicplayer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import info.u_team.music_player.dependency.DependencyManager;
import info.u_team.music_player.lavaplayer.api.IMusicPlayer;
import info.u_team.music_player.musicplayer.PlaylistManager;
import info.u_team.music_player.musicplayer.SettingsManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MusicPlayerManager {
    private static final Logger logger = LogManager.getLogger();
    private static IMusicPlayer player;
    private static final Gson gson;
    private static final PlaylistManager playlistManager;
    private static final SettingsManager settingsManager;

    public static void setup() {
        MusicPlayerManager.generatePlayer();
        player.startAudioOutput();
        playlistManager.loadFromFile();
        settingsManager.loadFromFile();
        player.setVolume(settingsManager.getSettings().getVolume());
    }

    private static void generatePlayer() {
        try {
            Class<?> clazz = Class.forName("info.u_team.music_player.lavaplayer.MusicPlayer", true, DependencyManager.getClassLoader());
            if (!IMusicPlayer.class.isAssignableFrom(clazz)) {
                throw new IllegalAccessError("The class " + clazz + " does not implement IMusicPlayer! This should not happen?!");
            }
            player = (IMusicPlayer)clazz.newInstance();
            logger.info("Successfully created music player instance");
        }
        catch (Exception ex) {
            logger.fatal("Cannot create music player instance. This is a serious bug and the mod will not work. Report to the mod authors", (Throwable)ex);
            FMLCommonHandler.instance().exitJava(0, false);
        }
    }

    public static IMusicPlayer getPlayer() {
        return player;
    }

    public static PlaylistManager getPlaylistManager() {
        return playlistManager;
    }

    public static SettingsManager getSettingsManager() {
        return settingsManager;
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().create();
        playlistManager = new PlaylistManager(gson);
        settingsManager = new SettingsManager(gson);
    }
}

