/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.render;

import info.u_team.music_player.gui.util.GuiTrackUtils;
import info.u_team.music_player.lavaplayer.api.audio.IPlayingTrack;
import info.u_team.music_player.lavaplayer.api.queue.ITrackManager;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.u_team_core.gui.elements.RenderScalingText;
import info.u_team.u_team_core.gui.elements.RenderScrollingText;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.math.MathHelper;

public class RenderOverlayMusicDisplay {
    private final ITrackManager manager = MusicPlayerManager.getPlayer().getTrackManager();
    private int width = 120;
    private int height = 35;
    private final RenderScrollingText title;
    private final RenderScrollingText author;
    private final RenderScalingText position;
    private final RenderScalingText duration;

    public RenderOverlayMusicDisplay() {
        FontRenderer fontRender = Minecraft.func_71410_x().field_71466_p;
        this.title = new RenderScrollingText(() -> fontRender, () -> GuiTrackUtils.getValueOfPlayingTrack(track -> track.getInfo().getFixedTitle()));
        this.title.setStepSize(0.5f);
        this.title.setColor(0xFFFF00);
        this.title.setWidth(114);
        this.title.setSpeedTime(35);
        this.author = new RenderScrollingText(() -> fontRender, () -> GuiTrackUtils.getValueOfPlayingTrack(track -> track.getInfo().getFixedAuthor()));
        this.author.setStepSize(0.5f);
        this.author.setColor(0xFFFF00);
        this.author.setScale(0.75f);
        this.author.setWidth(114);
        this.author.setSpeedTime(35);
        this.position = new RenderScalingText(() -> fontRender, () -> GuiTrackUtils.getValueOfPlayingTrack(GuiTrackUtils::getFormattedPosition));
        this.position.setColor(0xFFFF00);
        this.position.setScale(0.5f);
        this.duration = new RenderScalingText(() -> fontRender, () -> GuiTrackUtils.getValueOfPlayingTrack(GuiTrackUtils::getFormattedDuration));
        this.duration.setColor(0xFFFF00);
        this.duration.setScale(0.5f);
    }

    public void draw(float x, float y) {
        IPlayingTrack track = this.manager.getCurrentTrack();
        if (track == null) {
            return;
        }
        int intX = MathHelper.func_76123_f((float)x);
        int intY = MathHelper.func_76123_f((float)y);
        Gui.func_73734_a((int)intX, (int)intY, (int)(intX + this.width), (int)(intY + this.height), (int)-14606047);
        double progress = track.getInfo().isStream() ? 0.5 : (double)track.getPosition() / (double)track.getDuration();
        Gui.func_73734_a((int)(intX + 6), (int)(intY + 23), (int)(intX + this.width - 6), (int)(intY + 26), (int)-11184811);
        Gui.func_73734_a((int)(intX + 6), (int)(intY + 23), (int)(intX + 6 + (int)((double)(this.width - 12) * progress)), (int)(intY + 26), (int)-12676864);
        this.title.draw(x + 3.0f, y + 2.0f);
        this.author.draw(x + 3.0f, y + 12.0f);
        this.position.draw(x + 6.0f, y + 28.0f);
        this.duration.draw(x + (float)this.width - 6.0f - this.duration.getTextWidth(), y + 28.0f);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

