/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.tinyfd;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import info.u_team.music_player.MusicPlayerMod;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class TinyFileDialogs {
    private static String getFileDependingOnSystem() {
        String name = "lwjgl_tinyfd";
        if (Platform.isWindows()) {
            if (!Platform.is64Bit()) {
                name = name + "32";
            }
            name = name + ".dll";
        } else if (Platform.isLinux() || Platform.isMac()) {
            name = "lib" + name + (Platform.isMac() ? ".dylib" : ".so");
        } else {
            throw new UnsatisfiedLinkError("System no supported");
        }
        return name;
    }

    private static File extractFile(String resource) {
        try {
            Path path = Files.createTempFile(resource, null, new FileAttribute[0]);
            InputStream stream = MusicPlayerMod.class.getResourceAsStream("/" + resource);
            Files.copy(stream, path, StandardCopyOption.REPLACE_EXISTING);
            return path.toFile();
        }
        catch (Exception ex) {
            throw new LinkageError("Error occured when extracting file", ex);
        }
    }

    protected TinyFileDialogs() {
        throw new UnsupportedOperationException();
    }

    public static native long ntinyfd_openFileDialog(long var0, long var2, int var4, long var5, long var7, int var9);

    public static native long ntinyfd_selectFolderDialog(long var0, long var2);

    public static String openFileDialog(String aTitle, String aDefaultPathAndFile, String aSingleFilterDescription, boolean aAllowMultipleSelects) {
        long result = TinyFileDialogs.ntinyfd_openFileDialog(TinyFileDialogs.getAddressOfString(aTitle), TinyFileDialogs.getAddressOfString(aDefaultPathAndFile), 0, 0L, TinyFileDialogs.getAddressOfString(aSingleFilterDescription), aAllowMultipleSelects ? 1 : 0);
        return TinyFileDialogs.getStringOfAddress(result);
    }

    public static String selectFolderDialog(String aTitle, String aDefaultPath) {
        long result = TinyFileDialogs.ntinyfd_selectFolderDialog(TinyFileDialogs.getAddressOfString(aTitle), TinyFileDialogs.getAddressOfString(aDefaultPath));
        return TinyFileDialogs.getStringOfAddress(result);
    }

    private static long getAddressOfString(String string) {
        if (string == null) {
            return 0L;
        }
        Memory pointer = new Memory((long)TinyFileDialogs.getStringSize(string));
        pointer.setString(0L, string);
        return Pointer.nativeValue((Pointer)pointer);
    }

    private static String getStringOfAddress(long address) {
        if (address == 0L) {
            return null;
        }
        Pointer pointer = new Pointer(address);
        return pointer.getString(0L);
    }

    private static int getStringSize(String string) {
        try {
            return string.getBytes(Native.DEFAULT_ENCODING).length + 1;
        }
        catch (UnsupportedEncodingException e) {
            return string.getBytes().length + 1;
        }
    }

    static {
        System.load(TinyFileDialogs.extractFile(TinyFileDialogs.getFileDependingOnSystem()).getAbsolutePath());
    }
}

