/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.event;

import info.u_team.music_player.gui.GuiMusicPlayer;
import info.u_team.music_player.gui.controls.GuiControls;
import info.u_team.music_player.init.MusicPlayerKeys;
import info.u_team.music_player.lavaplayer.api.queue.ITrackManager;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.MusicPlayerUtils;
import info.u_team.music_player.musicplayer.settings.IngameOverlayPosition;
import info.u_team.music_player.musicplayer.settings.Settings;
import info.u_team.music_player.render.RenderOverlayMusicDisplay;
import info.u_team.u_team_core.gui.render.ScrollingTextRender;
import java.util.List;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandlerMusicPlayer {
    private final Settings settings;
    private RenderOverlayMusicDisplay overlayRender;
    private ScrollingTextRender titleRender;
    private ScrollingTextRender authorRender;

    public EventHandlerMusicPlayer(Settings settings) {
        this.settings = settings;
    }

    @SubscribeEvent
    public void on(InputEvent.KeyInputEvent event) {
        this.handleKeyboard(false, -1, -1);
    }

    @SubscribeEvent
    public void on(GuiScreenEvent.KeyboardKeyPressedEvent.Post event) {
        if (this.settings.isKeyWorkInGui()) {
            event.setCanceled(this.handleKeyboard(true, event.getKeyCode(), event.getScanCode()));
        }
    }

    private boolean handleKeyboard(boolean gui, int keyCode, int scanCode) {
        boolean handled;
        ITrackManager manager = MusicPlayerManager.getPlayer().getTrackManager();
        if (this.isKeyDown(MusicPlayerKeys.OPEN, gui, keyCode, scanCode)) {
            Minecraft mc = Minecraft.func_71410_x();
            if (!(mc.field_71462_r instanceof GuiMusicPlayer)) {
                mc.func_147108_a((Screen)new GuiMusicPlayer());
            }
            handled = true;
        } else if (this.isKeyDown(MusicPlayerKeys.PAUSE, gui, keyCode, scanCode)) {
            if (manager.getCurrentTrack() != null) {
                manager.setPaused(!manager.isPaused());
            }
            handled = true;
        } else if (this.isKeyDown(MusicPlayerKeys.SKIP_FORWARD, gui, keyCode, scanCode)) {
            if (manager.getCurrentTrack() != null) {
                MusicPlayerUtils.skipForward();
            }
            handled = true;
        } else if (this.isKeyDown(MusicPlayerKeys.SKIP_BACK, gui, keyCode, scanCode)) {
            MusicPlayerUtils.skipBack();
            handled = true;
        } else {
            handled = false;
        }
        return handled;
    }

    private boolean isKeyDown(KeyBinding binding, boolean gui, int keyCode, int scanCode) {
        if (gui) {
            return binding.isActiveAndMatches(InputMappings.func_197954_a((int)keyCode, (int)scanCode));
        }
        return binding.func_151468_f();
    }

    @SubscribeEvent
    public void on(RenderGameOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT && !mc.field_71474_y.field_74330_P && mc.field_71462_r == null && this.settings.isShowIngameOverlay()) {
            if (this.overlayRender == null) {
                this.overlayRender = new RenderOverlayMusicDisplay();
            }
            IngameOverlayPosition position = this.settings.getIngameOverlayPosition();
            MainWindow window = mc.field_195558_d;
            int width = window.func_198107_o();
            int height = window.func_198087_p();
            int x = position.isLeft() ? 3 : width - 3 - this.overlayRender.getWidth();
            int y = position.isUp() ? 3 : height - 3 - this.overlayRender.getHeight();
            this.overlayRender.draw(x, y);
        }
    }

    @SubscribeEvent
    public void on(GuiScreenEvent.InitGuiEvent.Pre event) {
        Screen gui = event.getGui();
        if (gui instanceof IngameMenuScreen && this.settings.isShowIngameMenueOverlay()) {
            gui.children().stream().filter(element -> element instanceof GuiControls).map(element -> (GuiControls)element).findAny().ifPresent(controls -> {
                this.titleRender = controls.getTitleRender();
                this.authorRender = controls.getAuthorRender();
            });
        }
    }

    @SubscribeEvent
    public void on(GuiScreenEvent.InitGuiEvent.Post event) {
        Screen gui = event.getGui();
        if (gui instanceof IngameMenuScreen && this.settings.isShowIngameMenueOverlay()) {
            GuiControls controls = new GuiControls(gui, 3, gui.width);
            if (this.titleRender != null) {
                controls.setTitleRender(this.titleRender);
                this.titleRender = null;
            }
            if (this.authorRender != null) {
                controls.setAuthorRender(this.authorRender);
                this.authorRender = null;
            }
            List list = gui.children();
            list.add(controls);
        }
    }

    @SubscribeEvent
    public void on(GuiScreenEvent.DrawScreenEvent.Post event) {
        Screen gui = event.getGui();
        if (gui instanceof IngameMenuScreen && this.settings.isShowIngameMenueOverlay()) {
            gui.children().stream().filter(element -> element instanceof GuiControls).map(element -> (GuiControls)element).findAny().ifPresent(controls -> controls.drawScreen(event.getMouseX(), event.getMouseY(), event.getRenderPartialTicks()));
        }
    }

    @SubscribeEvent
    public void on(GuiScreenEvent.MouseReleasedEvent.Pre event) {
        Screen gui = event.getGui();
        if (gui instanceof IngameMenuScreen && this.settings.isShowIngameMenueOverlay()) {
            gui.children().stream().filter(element -> element instanceof GuiControls).map(element -> (GuiControls)element).findAny().ifPresent(controls -> controls.mouseReleased(event.getMouseX(), event.getMouseY(), event.getButton()));
        }
    }

    @SubscribeEvent
    public void on(TickEvent.ClientTickEvent event) {
        Screen gui;
        if (event.phase == TickEvent.Phase.END && (gui = Minecraft.func_71410_x().field_71462_r) instanceof IngameMenuScreen && this.settings.isShowIngameMenueOverlay()) {
            gui.children().stream().filter(element -> element instanceof GuiControls).map(element -> (GuiControls)element).findAny().ifPresent(GuiControls::tick);
        }
    }
}

