/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.dependency;

import info.u_team.music_player.dependency.classloader.DependencyClassLoader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class DependencyManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker MARKER = MarkerManager.getMarker((String)"Load");
    private static final DependencyClassLoader MUSICPLAYER_CLASSLOADER = new DependencyClassLoader();

    public static void construct() {
        LOGGER.info(MARKER, "Load dependencies");
        String devPath = System.getProperty("musicplayer.dev");
        if (devPath != null) {
            DependencyManager.findJarFilesInDev(Paths.get(devPath, "musicplayer-lavaplayer/build/libs"), DependencyManager::addToMusicPlayerDependencies);
            DependencyManager.findJarFilesInDev(Paths.get(devPath, "musicplayer-lavaplayer/build/dependencies"), DependencyManager::addToMusicPlayerDependencies);
        } else {
            DependencyManager.findJarFilesInJar("dependencies/internal", path -> DependencyManager.addToInternalDependencies(DependencyManager.createInternalURL(path)));
            DependencyManager.findJarFilesInJar("dependencies/musicplayer", path -> DependencyManager.addToMusicPlayerDependencies(DependencyManager.createInternalURL(path)));
        }
        LOGGER.info(MARKER, "Finished loading dependencies");
    }

    public static DependencyClassLoader getClassLoader() {
        return MUSICPLAYER_CLASSLOADER;
    }

    private static void findJarFilesInDev(Path path, Consumer<Path> consumer) {
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
            stream.filter(file -> file.toString().endsWith(".jar")).forEach(consumer);
        }
        catch (IOException ex) {
            LOGGER.error(MARKER, "When searching for jar files in dev an exception occured.", (Throwable)ex);
        }
    }

    private static void findJarFilesInJar(String folder, Consumer<Path> consumer) {
        ModFile modfile = ModList.get().getModFileById("musicplayer").getFile();
        try (Stream<Path> stream = Files.walk(modfile.findResource("/" + folder), new FileVisitOption[0]);){
            stream.filter(file -> file.toString().endsWith(".jar")).forEach(consumer);
        }
        catch (IOException ex) {
            LOGGER.error(MARKER, "When searching for jar files in jar an exception occured.", (Throwable)ex);
        }
    }

    private static URL createInternalURL(Path path) {
        String url = "modjar://musicplayer" + path;
        LOGGER.debug(MARKER, "Load url" + url);
        try {
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            LOGGER.error(MARKER, "Could not create url from internal path", (Throwable)ex);
            return null;
        }
    }

    private static void addToMusicPlayerDependencies(URL url) {
        MUSICPLAYER_CLASSLOADER.addURL(url);
    }

    private static void addToMusicPlayerDependencies(Path path) {
        MUSICPLAYER_CLASSLOADER.addPath(path);
    }

    private static void addToInternalDependencies(URL url) {
        try {
            URLClassLoader systemClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)systemClassLoader, url);
        }
        catch (Exception ex) {
            LOGGER.error(MARKER, "Method addURL on system classloader could not be invoked", (Throwable)ex);
        }
    }
}

