/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.dependency.classloader;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DependencyClassLoader
extends URLClassLoader {
    private static final Logger LOGGER = LogManager.getLogger();

    public DependencyClassLoader() {
        super(new URL[0], (ClassLoader)null);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            return super.loadClass(name);
        }
        catch (ClassNotFoundException ex) {
            if (name.startsWith("info.u_team.music_player.lavaplayer.api")) {
                return this.getClass().getClassLoader().loadClass(name);
            }
            throw ex;
        }
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public void addPath(Path path) {
        try {
            this.addURL(path.toUri().toURL());
        }
        catch (MalformedURLException ex) {
            LOGGER.error("Could not add dependency path to classloader", (Throwable)ex);
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

