/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.controls;

import com.mojang.blaze3d.matrix.MatrixStack;
import info.u_team.music_player.gui.util.GuiTrackUtils;
import info.u_team.music_player.lavaplayer.api.audio.IPlayingTrack;
import info.u_team.music_player.lavaplayer.api.queue.ITrackManager;
import info.u_team.u_team_core.gui.elements.ProgressBar;
import info.u_team.u_team_core.gui.render.ScalingTextRender;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class GuiMusicProgressBar
extends ProgressBar {
    private final ScalingTextRender positionRender;
    private final ScalingTextRender durationRender;

    public GuiMusicProgressBar(ITrackManager manager, int x, int y, int width, int height, float scale) {
        super(x, y, width, height, -11184811, -12676864, () -> GuiMusicProgressBar.getProgress(manager), value -> GuiMusicProgressBar.updateProgress(manager, value));
        FontRenderer fontRender = Minecraft.func_71410_x().field_71466_p;
        this.positionRender = new ScalingTextRender(() -> fontRender, () -> GuiTrackUtils.getFormattedPosition(manager.getCurrentTrack()));
        this.positionRender.setScale(scale);
        this.positionRender.setColor(0xFFFF00);
        this.durationRender = new ScalingTextRender(() -> fontRender, () -> GuiTrackUtils.getFormattedDuration(manager.getCurrentTrack()));
        this.durationRender.setScale(scale);
        this.durationRender.setColor(0xFFFF00);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.positionRender.draw((float)this.getX() - this.positionRender.getTextWidth() - (float)(this.positionRender.getScale() < 1.0f ? 3 : 5), (float)(this.getY() - (this.positionRender.getScale() < 1.0f ? 1 : 2)));
        this.durationRender.draw((float)(this.getX() + this.getWidth() + (this.positionRender.getScale() < 1.0f ? 3 : 5)), (float)(this.getY() - (this.positionRender.getScale() < 1.0f ? 1 : 2)));
    }

    private static double getProgress(ITrackManager manager) {
        IPlayingTrack track = manager.getCurrentTrack();
        if (track == null) {
            return 0.0;
        }
        if (track.getInfo().isStream()) {
            return 0.5;
        }
        return (double)track.getPosition() / (double)track.getDuration();
    }

    private static void updateProgress(ITrackManager manager, double value) {
        IPlayingTrack track = manager.getCurrentTrack();
        if (track != null) {
            track.setPosition((long)((double)track.getDuration() * value));
        }
    }
}

