/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.playlist;

import com.mojang.blaze3d.matrix.MatrixStack;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntry;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntryError;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntryPlaylistStart;
import info.u_team.music_player.gui.util.GuiTrackUtils;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.lavaplayer.api.queue.ITrackManager;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.playlist.LoadedTracks;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.music_player.musicplayer.playlist.Playlists;
import info.u_team.u_team_core.gui.elements.ToggleImageButton;
import net.minecraft.client.gui.widget.Widget;

public abstract class GuiMusicPlaylistListEntryPlayable
extends GuiMusicPlaylistListEntry {
    private final ITrackManager manager;
    private final IAudioTrack track;
    private final LoadedTracks loadedTrack;
    protected final ToggleImageButton playTrackButton;

    GuiMusicPlaylistListEntryPlayable(Playlists playlists, Playlist playlist, LoadedTracks loadedTrack, IAudioTrack track) {
        this.track = track;
        this.loadedTrack = loadedTrack;
        this.manager = MusicPlayerManager.getPlayer().getTrackManager();
        this.playTrackButton = (ToggleImageButton)this.addButton((Widget)new ToggleImageButton(0, 0, 20, 20, MusicPlayerResources.TEXTURE_PLAY, MusicPlayerResources.TEXTURE_PAUSE));
        if (loadedTrack.hasError() || track == null) {
            this.playTrackButton.field_230694_p_ = false;
        } else {
            this.playTrackButton.toggle(track == this.getCurrentlyPlaying());
            this.playTrackButton.setPressable(() -> {
                boolean play = this.playTrackButton.isToggled();
                if (play) {
                    if (this.manager.isPaused() && this.getCurrentlyPlaying() == track) {
                        this.manager.setPaused(false);
                    } else {
                        playlists.setPlaying(playlist);
                        playlist.setPlayable(loadedTrack, track);
                        this.manager.setTrackQueue(playlist);
                        this.manager.start();
                    }
                } else {
                    this.manager.setPaused(true);
                }
            });
        }
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (button == 2) {
            String uri;
            String string = uri = this instanceof GuiMusicPlaylistListEntryPlaylistStart || this instanceof GuiMusicPlaylistListEntryError ? this.loadedTrack.getUri().get() : this.track.getInfo().getURI();
            if (GuiTrackUtils.openURI(uri)) {
                return true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public void func_230432_a_(MatrixStack matrixStack, int slotIndex, int entryY, int entryX, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
        this.playTrackButton.field_230690_l_ = entryWidth - 65;
        this.playTrackButton.field_230691_m_ = entryY + 8;
        this.playTrackButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void tick() {
        if (this.isPlaying()) {
            this.playTrackButton.toggle(!this.manager.isPaused());
        } else {
            this.playTrackButton.toggle(false);
        }
    }

    protected IAudioTrack getCurrentlyPlaying() {
        return this.manager.getCurrentTrack() == null ? null : this.manager.getCurrentTrack().getOriginalTrack();
    }

    protected boolean isPlaying() {
        return this.getCurrentlyPlaying() == this.track;
    }

    public IAudioTrack getTrack() {
        return this.track;
    }

    public ToggleImageButton getPlayTrackButton() {
        return this.playTrackButton;
    }
}

