/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.playlist.search;

import com.mojang.blaze3d.matrix.MatrixStack;
import info.u_team.music_player.gui.BetterScreen;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylist;
import info.u_team.music_player.gui.playlist.search.GuiMusicSearchList;
import info.u_team.music_player.gui.playlist.search.GuiMusicSearchListEntryMusicTrack;
import info.u_team.music_player.gui.playlist.search.GuiMusicSearchListEntryPlaylist;
import info.u_team.music_player.gui.playlist.search.SearchProvider;
import info.u_team.music_player.init.MusicPlayerLocalization;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrackList;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.u_team_core.gui.elements.ImageButton;
import info.u_team.u_team_core.gui.elements.UButton;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class GuiMusicSearch
extends BetterScreen {
    private final Playlist playlist;
    private TextFieldWidget urlField;
    private TextFieldWidget searchField;
    private final GuiMusicSearchList searchList;
    private SearchProvider searchProvider;
    private String information;
    private int informationTicks;
    private int maxTicksInformation;

    public GuiMusicSearch(Playlist playlist) {
        super((ITextComponent)new StringTextComponent("musicsearch"));
        this.playlist = playlist;
        this.searchList = new GuiMusicSearchList();
        this.searchProvider = SearchProvider.YOUTUBE;
    }

    protected void func_231160_c_() {
        ImageButton backButton = (ImageButton)this.func_230480_a_((Widget)new ImageButton(1, 1, 15, 15, MusicPlayerResources.TEXTURE_BACK));
        backButton.setPressable(() -> this.field_230706_i_.func_147108_a((Screen)new GuiMusicPlaylist(this.playlist)));
        this.urlField = new TextFieldWidget(this.field_230712_o_, 10, 35, this.field_230708_k_ / 2 - 10, 20, ITextComponent.func_244388_a((String)"")){

            public boolean func_231046_a_(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
                GuiMusicSearch.this.keyFromTextField(this, this.func_146179_b(), key);
                return super.func_231046_a_(key, p_keyPressed_2_, p_keyPressed_3_);
            }
        };
        this.urlField.func_146203_f(10000);
        this.field_230705_e_.add(this.urlField);
        UButton openFileButton = (UButton)this.func_230480_a_((Widget)new UButton(this.field_230708_k_ / 2 + 10, 34, this.field_230708_k_ / 4 - 15, 22, ITextComponent.func_244388_a((String)MusicPlayerLocalization.getTranslation("gui.search.load.file", new Object[0]))));
        openFileButton.setPressable(() -> {
            String response = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)MusicPlayerLocalization.getTranslation("gui.search.load.file", new Object[0]), null, null, (CharSequence)MusicPlayerLocalization.getTranslation("gui.search.music_files", new Object[0]), (boolean)false);
            if (response != null) {
                this.searchList.clear();
                this.addTrack(response);
            }
        });
        UButton openFolderButton = (UButton)this.func_230480_a_((Widget)new UButton((int)((double)this.field_230708_k_ * 0.75) + 5, 34, this.field_230708_k_ / 4 - 15, 22, ITextComponent.func_244388_a((String)MusicPlayerLocalization.getTranslation("gui.search.load.folder", new Object[0]))));
        openFolderButton.setPressable(() -> {
            String response = TinyFileDialogs.tinyfd_selectFolderDialog((CharSequence)MusicPlayerLocalization.getTranslation("gui.search.load.folder", new Object[0]), (CharSequence)System.getProperty("user.home"));
            if (response != null) {
                this.searchList.clear();
                try (Stream<Path> stream = Files.list(Paths.get(response, new String[0]));){
                    stream.filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> this.addTrack(path.toString()));
                }
                catch (IOException ex) {
                    this.setInformation(TextFormatting.RED + ex.getMessage(), 150);
                }
            }
        });
        ImageButton searchButton = (ImageButton)this.func_230480_a_((Widget)new ImageButton(10, 76, 24, 24, this.searchProvider.getLogo()));
        searchButton.setPressable(() -> {
            this.searchProvider = SearchProvider.toggle(this.searchProvider);
            searchButton.setResource(this.searchProvider.getLogo());
        });
        this.searchField = new TextFieldWidget(this.field_230712_o_, 40, 78, this.field_230708_k_ - 51, 20, ITextComponent.func_244388_a((String)"")){

            public boolean func_231046_a_(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
                GuiMusicSearch.this.keyFromTextField(this, GuiMusicSearch.this.searchProvider.getPrefix() + this.func_146179_b(), key);
                return super.func_231046_a_(key, p_keyPressed_2_, p_keyPressed_3_);
            }

            public boolean func_231049_c__(boolean p_changeFocus_1_) {
                System.out.println("CHANGEED FOR Search FIELD to " + p_changeFocus_1_);
                return super.func_231049_c__(p_changeFocus_1_);
            }
        };
        this.searchField.func_146203_f(1000);
        this.searchField.func_146195_b(true);
        this.func_231035_a_((IGuiEventListener)this.searchField);
        this.field_230705_e_.add(this.searchField);
        UButton addAllButton = (UButton)this.func_230480_a_((Widget)new UButton(this.field_230708_k_ - 110, 105, 100, 20, ITextComponent.func_244388_a((String)MusicPlayerLocalization.getTranslation("gui.search.add_all", new Object[0]))));
        addAllButton.setPressable(() -> {
            List<GuiMusicSearchListEntryPlaylist> list = this.searchList.func_231039_at__().stream().filter(entry -> entry instanceof GuiMusicSearchListEntryPlaylist).map(entry -> (GuiMusicSearchListEntryPlaylist)((Object)((Object)entry))).collect(Collectors.toList());
            if (list.size() > 0) {
                list.forEach(entry -> this.playlist.add(entry.getTrackList()));
            } else {
                this.searchList.func_231039_at__().stream().filter(entry -> entry instanceof GuiMusicSearchListEntryMusicTrack).map(entry -> (GuiMusicSearchListEntryMusicTrack)((Object)((Object)entry))).filter(entry -> !entry.isPlaylistEntry()).forEach(entry -> this.playlist.add(entry.getTrack()));
            }
            this.setInformation(TextFormatting.GREEN + MusicPlayerLocalization.getTranslation("gui.search.added_all", new Object[0]), 150);
        });
        this.searchList.updateSettings(this.field_230708_k_ - 24, this.field_230709_l_, 130, this.field_230709_l_ - 10, 12, this.field_230708_k_ - 12);
        this.field_230705_e_.add(this.searchList);
    }

    public void func_231152_a_(Minecraft minecraft, int width, int height) {
        String urlFieldText = this.urlField.func_146179_b();
        boolean urlFieldFocus = this.urlField.func_230999_j_() && this.func_241217_q_() == this.urlField;
        String searchFieldText = this.searchField.func_146179_b();
        boolean searchFieldFocus = this.searchField.func_230999_j_() && this.func_241217_q_() == this.searchField;
        this.func_231158_b_(minecraft, width, height);
        this.urlField.func_146180_a(urlFieldText);
        this.urlField.func_146195_b(urlFieldFocus);
        if (urlFieldFocus) {
            this.func_231035_a_((IGuiEventListener)this.urlField);
        }
        this.searchField.func_146180_a(searchFieldText);
        this.searchField.func_146195_b(searchFieldFocus);
        if (searchFieldFocus) {
            this.func_231035_a_((IGuiEventListener)this.searchField);
        }
    }

    public void func_231023_e_() {
        this.urlField.func_146178_a();
        this.searchField.func_146178_a();
        ++this.informationTicks;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_231165_f_(0);
        this.searchList.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        GuiMusicSearch.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)MusicPlayerLocalization.getTranslation("gui.search.header", new Object[0]), (int)(this.field_230708_k_ / 2), (int)5, (int)0xFFFFFF);
        GuiMusicSearch.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)MusicPlayerLocalization.getTranslation("gui.search.search.uri", new Object[0]), (int)10, (int)20, (int)0xFFFFFF);
        GuiMusicSearch.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)MusicPlayerLocalization.getTranslation("gui.search.search.file", new Object[0]), (int)(10 + this.field_230708_k_ / 2), (int)20, (int)0xFFFFFF);
        GuiMusicSearch.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)MusicPlayerLocalization.getTranslation("gui.search.search.search", new Object[0]), (int)10, (int)63, (int)0xFFFFFF);
        if (this.information != null && this.informationTicks <= this.maxTicksInformation) {
            GuiMusicSearch.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)this.information, (int)15, (int)110, (int)0xFFFFFF);
        }
        this.urlField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.searchField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.urlField.func_231044_a_(mouseX, mouseY, button)) {
            this.func_231035_a_((IGuiEventListener)this.urlField);
            this.urlField.func_146195_b(true);
            this.searchField.func_146195_b(false);
            return true;
        }
        if (this.searchField.func_231044_a_(mouseX, mouseY, button)) {
            this.func_231035_a_((IGuiEventListener)this.searchField);
            this.searchField.func_146195_b(true);
            this.urlField.func_146195_b(false);
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public void setInformation(String information, int maxTicksInformation) {
        this.information = information;
        this.maxTicksInformation = maxTicksInformation;
        this.informationTicks = 0;
    }

    private void keyFromTextField(TextFieldWidget field, String text, int key) {
        if (field.func_146176_q() && field.func_230999_j_() && (key == 257 || key == 335)) {
            this.searchList.clear();
            this.addTrack(text);
            field.func_146180_a("");
        }
    }

    private void addTrack(String uri) {
        MusicPlayerManager.getPlayer().getTrackSearch().getTracks(uri, result -> this.field_230706_i_.execute(() -> {
            if (result.hasError()) {
                this.setInformation(TextFormatting.RED + result.getErrorMessage(), 150);
            } else if (result.isList()) {
                IAudioTrackList list = result.getTrackList();
                if (!list.isSearch()) {
                    this.searchList.add(new GuiMusicSearchListEntryPlaylist(this, this.playlist, list));
                }
                list.getTracks().forEach(track -> this.searchList.add(new GuiMusicSearchListEntryMusicTrack(this, this.playlist, (IAudioTrack)track, !list.isSearch())));
            } else {
                IAudioTrack track2 = result.getTrack();
                this.searchList.add(new GuiMusicSearchListEntryMusicTrack(this, this.playlist, track2, false));
            }
        }));
    }
}

