/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import info.u_team.music_player.init.MusicPlayerLocalization;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrackInfo;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.util.TimeUtil;
import java.net.URI;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.event.ClickEvent;

public final class GuiTrackUtils {
    private static final Minecraft MINECRAFT = Minecraft.func_71410_x();

    public static String trimToWith(String string, int width) {
        String newString = GuiTrackUtils.MINECRAFT.field_71466_p.func_238412_a_(string, width);
        if (!newString.equals(string)) {
            newString = newString + "...";
        }
        return newString;
    }

    public static void addTrackInfo(MatrixStack matrixStack, IAudioTrack track, int x, int y, int entryWidth, int leftMargin, int titleColor) {
        int textSize = entryWidth - 150 - leftMargin;
        IAudioTrackInfo info = track.getInfo();
        String title = GuiTrackUtils.trimToWith(info.getFixedTitle(), textSize);
        String author = GuiTrackUtils.trimToWith(info.getFixedAuthor(), textSize);
        String duration = GuiTrackUtils.getFormattedDuration(track);
        GuiTrackUtils.MINECRAFT.field_71466_p.func_238421_b_(matrixStack, title, (float)(x + leftMargin), (float)(y + 5), titleColor);
        GuiTrackUtils.MINECRAFT.field_71466_p.func_238421_b_(matrixStack, author, (float)(x + leftMargin + 4), (float)(y + 25), 14183708);
        GuiTrackUtils.MINECRAFT.field_71466_p.func_238421_b_(matrixStack, duration, (float)(x + entryWidth - 140), (float)(y + 15), 0xFFFF00);
    }

    public static boolean openURI(String uri) {
        Style style = ITextComponent.func_244388_a(null).func_150256_b();
        try {
            new URI(uri);
            style = style.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, uri));
        }
        catch (Exception ex) {
            style = style.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_FILE, uri));
        }
        return GuiTrackUtils.MINECRAFT.field_71462_r.func_230455_a_(style);
    }

    public static String getFormattedDuration(IAudioTrack track) {
        long seconds;
        if (track == null) {
            seconds = 0L;
        } else {
            IAudioTrackInfo info = track.getInfo();
            if (info.isStream()) {
                return MusicPlayerLocalization.getTranslation("gui.track.duration_undefined", new Object[0]);
            }
            seconds = track.getDuration() / 1000L;
        }
        return TimeUtil.timeConversion(seconds);
    }

    public static String getFormattedPosition(IAudioTrack track) {
        return TimeUtil.timeConversion(track == null ? 0L : track.getPosition() / 1000L);
    }

    public static <T> T getValueOfPlayingTrack(Function<IAudioTrack, T> function) {
        return GuiTrackUtils.getValueOfNullableTrack(MusicPlayerManager.getPlayer().getTrackManager().getCurrentTrack(), function);
    }

    public static <T> T getValueOfNullableTrack(IAudioTrack track, Function<IAudioTrack, T> function) {
        if (track != null) {
            return function.apply(track);
        }
        return null;
    }
}

