/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.musicplayer;

import info.u_team.music_player.lavaplayer.api.audio.IPlayingTrack;
import info.u_team.music_player.lavaplayer.api.queue.ITrackManager;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.music_player.musicplayer.playlist.Skip;

public final class MusicPlayerUtils {
    public static void skipForward() {
        ITrackManager manager = MusicPlayerManager.getPlayer().getTrackManager();
        Playlist playlist = MusicPlayerManager.getPlaylistManager().getPlaylists().getPlaying();
        if (playlist != null && playlist.skip(Skip.FORWARD)) {
            manager.skip();
        }
    }

    public static void skipBack() {
        ITrackManager manager = MusicPlayerManager.getPlayer().getTrackManager();
        Playlist playlist = MusicPlayerManager.getPlaylistManager().getPlaylists().getPlaying();
        if (playlist != null) {
            IPlayingTrack currentlyPlaying = manager.getCurrentTrack();
            long maxDuration = currentlyPlaying.getDuration() / 10L;
            if (maxDuration > 10000L) {
                maxDuration = 10000L;
            }
            if (currentlyPlaying.getPosition() > maxDuration && !currentlyPlaying.getInfo().isStream()) {
                currentlyPlaying.setPosition(0L);
            } else if (playlist.skip(Skip.PREVIOUS)) {
                manager.skip();
            }
        }
    }
}

