/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import info.u_team.music_player.gui.util.GuiTrackUtils;
import info.u_team.music_player.lavaplayer.api.audio.IPlayingTrack;
import info.u_team.music_player.lavaplayer.api.queue.ITrackManager;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.u_team_core.gui.render.ScalingTextRender;
import info.u_team.u_team_core.gui.render.ScrollingTextRender;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.math.MathHelper;

public class RenderOverlayMusicDisplay {
    private final ITrackManager manager = MusicPlayerManager.getPlayer().getTrackManager();
    private final int width;
    private final int height;
    private final ScrollingTextRender title;
    private final ScrollingTextRender author;
    private final ScalingTextRender position;
    private final ScalingTextRender duration;

    public RenderOverlayMusicDisplay() {
        this.height = 35;
        this.width = 120;
        FontRenderer fontRender = Minecraft.func_71410_x().field_71466_p;
        this.title = new ScrollingTextRender(() -> fontRender, () -> GuiTrackUtils.getValueOfPlayingTrack(track -> track.getInfo().getFixedTitle()));
        this.title.setStepSize(0.5f);
        this.title.setColor(0xFFFF00);
        this.title.setWidth(114);
        this.title.setSpeedTime(35);
        this.author = new ScrollingTextRender(() -> fontRender, () -> GuiTrackUtils.getValueOfPlayingTrack(track -> track.getInfo().getFixedAuthor()));
        this.author.setStepSize(0.5f);
        this.author.setColor(0xFFFF00);
        this.author.setScale(0.75f);
        this.author.setWidth(114);
        this.author.setSpeedTime(35);
        this.position = new ScalingTextRender(() -> fontRender, () -> GuiTrackUtils.getValueOfPlayingTrack(GuiTrackUtils::getFormattedPosition));
        this.position.setColor(0xFFFF00);
        this.position.setScale(0.5f);
        this.duration = new ScalingTextRender(() -> fontRender, () -> GuiTrackUtils.getValueOfPlayingTrack(GuiTrackUtils::getFormattedDuration));
        this.duration.setColor(0xFFFF00);
        this.duration.setScale(0.5f);
    }

    public void draw(MatrixStack matrixStack, float x, float y) {
        IPlayingTrack track = this.manager.getCurrentTrack();
        if (track == null) {
            return;
        }
        int intX = MathHelper.func_76123_f((float)x);
        int intY = MathHelper.func_76123_f((float)y);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)intX, (int)intY, (int)(intX + this.width), (int)(intY + this.height), (int)-14606047);
        double progress = track.getInfo().isStream() ? 0.5 : (double)track.getPosition() / (double)track.getDuration();
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(intX + 6), (int)(intY + 23), (int)(intX + this.width - 6), (int)(intY + 26), (int)-11184811);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(intX + 6), (int)(intY + 23), (int)(intX + 6 + (int)((double)(this.width - 12) * progress)), (int)(intY + 26), (int)-12676864);
        this.title.draw(x + 3.0f, y + 2.0f);
        this.author.draw(x + 3.0f, y + 12.0f);
        this.position.draw(x + 6.0f, y + 28.0f);
        this.duration.draw(x + (float)this.width - 6.0f - this.duration.getTextWidth(), y + 28.0f);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

