/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ObjectHolder;

public class BulletEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private static final Random random = new Random();
    static final double GRAVITY = 0.05;
    static final double AIR_FRICTION = 0.99;
    static final double WATER_FRICTION = 0.6;
    public static float damageFactorMin;
    public static float damageFactorMax;
    public UUID shooterUuid;
    public short ticksLeft = (short)50;
    @ObjectHolder(value="musketmod:bullet")
    public static EntityType<BulletEntity> TYPE;
    private static final UUID EMPTY_UUID;

    public BulletEntity(World world) {
        super(TYPE, world);
    }

    public BulletEntity(FMLPlayMessages.SpawnEntity packet, World world) {
        this(world);
    }

    public Entity getShooter() {
        return this.shooterUuid != null && this.field_70170_p instanceof ServerWorld ? ((ServerWorld)this.field_70170_p).func_217461_a(this.shooterUuid) : null;
    }

    public DamageSource causeMusketDamage(BulletEntity bullet, Entity attacker) {
        return new IndirectEntityDamageSource("musket", (Entity)bullet, attacker).func_76349_b();
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.processCollision()) {
            this.func_70106_y();
            return;
        }
        this.ticksLeft = (short)(this.ticksLeft - 1);
        if (this.ticksLeft <= 0) {
            this.func_70106_y();
            return;
        }
        Vec3d motion = this.func_213322_ci();
        double posX = this.func_226277_ct_() + motion.field_72450_a;
        double posY = this.func_226278_cu_() + motion.field_72448_b;
        double posZ = this.func_226281_cx_() + motion.field_72449_c;
        motion = motion.func_178786_a(0.0, 0.05, 0.0);
        double friction = 0.99;
        if (this.func_70090_H()) {
            int count = 4;
            for (int i = 0; i != 4; ++i) {
                double t = ((double)i + 1.0) / 4.0;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, posX - motion.field_72450_a * t, posY - motion.field_72448_b * t, posZ - motion.field_72449_c * t, motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
            }
            friction = 0.6;
        }
        this.func_213317_d(motion.func_186678_a(friction));
        this.func_70107_b(posX, posY, posZ);
        this.func_145775_I();
    }

    private boolean processCollision() {
        Entity target;
        Vec3d to;
        Vec3d from = new Vec3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        BlockRayTraceResult collision = this.field_70170_p.func_217299_a(new RayTraceContext(from, to = from.func_178787_e(this.func_213322_ci()), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
        if (collision.func_216346_c() != RayTraceResult.Type.MISS) {
            to = collision.func_216347_e();
        }
        if ((target = this.closestEntityOnPath(from, to)) != null) {
            Entity shooter;
            if (target instanceof PlayerEntity && (shooter = this.getShooter()) instanceof PlayerEntity && !((PlayerEntity)shooter).func_96122_a((PlayerEntity)target)) {
                target = null;
            }
            if (target != null) {
                this.hitEntity(target);
                return true;
            }
        }
        if (collision.func_216346_c() == RayTraceResult.Type.MISS) {
            return false;
        }
        BlockState blockstate = this.field_70170_p.func_180495_p(collision.func_216350_a());
        blockstate.func_215690_a(this.field_70170_p, blockstate, collision, (Entity)this);
        int impactParticleCount = (int)(this.func_213322_ci().func_189985_c() / 20.0);
        if (impactParticleCount > 0) {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate), to.field_72450_a, to.field_72448_b, to.field_72449_c, impactParticleCount, 0.0, 0.0, 0.0, 0.01);
        }
        return true;
    }

    private void hitEntity(Entity target) {
        Entity shooter = this.getShooter();
        DamageSource damagesource = this.causeMusketDamage(this, (Entity)(shooter != null ? shooter : this));
        float energy = (float)this.func_213322_ci().func_189985_c();
        float factor = damageFactorMin + random.nextFloat() * (damageFactorMax - damageFactorMin);
        target.func_70097_a(damagesource, energy * factor);
    }

    private Predicate<Entity> getTargetPredicate() {
        Entity shooter = this.getShooter();
        return entity -> !entity.func_175149_v() && entity.func_70089_S() && entity.func_70067_L() && entity != shooter;
    }

    private Entity closestEntityOnPath(Vec3d start, Vec3d end) {
        Vec3d motion = this.func_213322_ci();
        Entity shooter = this.getShooter();
        Entity result = null;
        double result_dist = motion.func_72433_c() + 0.05;
        AxisAlignedBB aabbSelection = this.func_174813_aQ().func_72321_a(motion.field_72450_a, motion.field_72448_b, motion.field_72449_c).func_186662_g(0.5);
        for (Entity entity : this.field_70170_p.func_175674_a((Entity)this, aabbSelection, this.getTargetPredicate())) {
            double dist;
            AxisAlignedBB aabb;
            Optional optional;
            if (entity == shooter || !(optional = (aabb = entity.func_174813_aQ()).func_216365_b(start, end)).isPresent() || !((dist = start.func_72436_e((Vec3d)optional.get())) < result_dist) && result != null) continue;
            result = entity;
            result_dist = dist;
        }
        return result;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_186855_b("shooterUuid")) {
            this.shooterUuid = compound.func_186857_a("shooterUuid");
        }
        this.ticksLeft = compound.func_74765_d("ticksLeft");
    }

    protected void func_213281_b(CompoundNBT compound) {
        if (this.shooterUuid != null) {
            compound.func_186854_a("shooterUuid", this.shooterUuid);
        }
        compound.func_74777_a("ticksLeft", this.ticksLeft);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer data) {
        data.func_179252_a(this.shooterUuid != null ? this.shooterUuid : EMPTY_UUID);
        data.writeShort((int)this.ticksLeft);
        Vec3d motion = this.func_213322_ci();
        data.writeFloat((float)motion.field_72450_a);
        data.writeFloat((float)motion.field_72448_b);
        data.writeFloat((float)motion.field_72449_c);
    }

    public void readSpawnData(PacketBuffer data) {
        UUID uuid = data.func_179253_g();
        if (!uuid.equals(EMPTY_UUID)) {
            this.shooterUuid = uuid;
        }
        this.ticksLeft = data.readShort();
        Vec3d motion = new Vec3d((double)data.readFloat(), (double)data.readFloat(), (double)data.readFloat());
        this.func_213317_d(motion);
    }

    static {
        EMPTY_UUID = new UUID(0L, 0L);
    }
}

