/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import ewewukek.musketmod.BulletEntity;
import ewewukek.musketmod.MusketItem;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="musketmod", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    public static final Config INSTANCE;
    public static final ForgeConfigSpec SPEC;
    public final ForgeConfigSpec.ConfigValue<Double> bulletStdDev;
    public final ForgeConfigSpec.ConfigValue<Double> bulletSpeed;
    public final ForgeConfigSpec.ConfigValue<Double> damageMin;
    public final ForgeConfigSpec.ConfigValue<Double> damageMax;

    public Config(ForgeConfigSpec.Builder builder) {
        builder.push("musket");
        this.bulletStdDev = builder.comment("Standard deviation of bullet spread (in degrees)").define("bulletStdDev", (Object)1.0);
        this.bulletSpeed = builder.comment("Muzzle velocity of bullet (in blocks per second)").define("bulletSpeed", (Object)180.0);
        this.damageMin = builder.comment("Minimum damage at point-blank range").define("damageMin", (Object)20.5);
        this.damageMax = builder.comment("Maximum damage at point-blank range").define("damageMax", (Object)21.5);
        builder.pop();
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == SPEC) {
            MusketItem.bulletStdDev = (float)Math.toRadians((Double)Config.INSTANCE.bulletStdDev.get());
            MusketItem.bulletSpeed = (Double)Config.INSTANCE.bulletSpeed.get() / 20.0;
            double maxEnergy = MusketItem.bulletSpeed * MusketItem.bulletSpeed;
            BulletEntity.damageFactorMin = (float)((Double)Config.INSTANCE.damageMin.get() / maxEnergy);
            BulletEntity.damageFactorMax = (float)((Double)Config.INSTANCE.damageMax.get() / maxEnergy);
        }
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(Config::new);
        INSTANCE = (Config)pair.getLeft();
        SPEC = (ForgeConfigSpec)pair.getRight();
    }
}

