/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import ewewukek.musketmod.BulletEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.registries.ObjectHolder;

public class MusketItem
extends Item {
    public static final int DURABILITY = 250;
    public static final int LOADING_STAGE_1 = 5;
    public static final int LOADING_STAGE_2 = 10;
    public static final int LOADING_STAGE_3 = 20;
    public static final int RELOAD_DURATION = 30;
    public static float bulletStdDev;
    public static double bulletSpeed;
    @ObjectHolder(value="musketmod:cartridge")
    public static Item CARTRIDGE;
    @ObjectHolder(value="musketmod:musket_load0")
    public static SoundEvent SOUND_MUSKET_LOAD_0;
    @ObjectHolder(value="musketmod:musket_load1")
    public static SoundEvent SOUND_MUSKET_LOAD_1;
    @ObjectHolder(value="musketmod:musket_load2")
    public static SoundEvent SOUND_MUSKET_LOAD_2;
    @ObjectHolder(value="musketmod:musket_ready")
    public static SoundEvent SOUND_MUSKET_READY;
    @ObjectHolder(value="musketmod:musket_fire")
    public static SoundEvent SOUND_MUSKET_FIRE;

    public MusketItem(Item.Properties properties) {
        super(properties.func_200915_b(250));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand hand) {
        if (hand != Hand.MAIN_HAND) {
            return super.func_77659_a(worldIn, player, hand);
        }
        ItemStack stack = player.func_184586_b(hand);
        boolean creative = player.field_71075_bZ.field_75098_d;
        if (player.func_208600_a((ITag)FluidTags.field_206959_a) && !creative) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        boolean haveAmmo = !this.findAmmo(player).func_190926_b() || creative;
        boolean loaded = MusketItem.isLoaded(stack);
        if (loaded && MusketItem.isReady(stack)) {
            if (!worldIn.field_72995_K) {
                this.fireBullet(worldIn, player);
            }
            player.func_184185_a(SOUND_MUSKET_FIRE, 1.5f, 1.0f);
            MusketItem.damageItem(stack, player);
            this.setReady(stack, false);
            this.setLoaded(stack, false);
            return ActionResult.func_226249_b_((Object)stack);
        }
        if (loaded || haveAmmo) {
            if (!loaded) {
                this.setLoadingStage(stack, 0);
            }
            player.func_184598_c(hand);
            return ActionResult.func_226249_b_((Object)stack);
        }
        return ActionResult.func_226251_d_((Object)stack);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (MusketItem.isLoaded(stack)) {
            this.setReady(stack, true);
        }
    }

    public void func_219972_a(World world, LivingEntity entity, ItemStack stack, int timeLeft) {
        if (world.field_72995_K || !(entity instanceof PlayerEntity)) {
            return;
        }
        int usingDuration = this.func_77626_a(stack) - timeLeft;
        int loadingStage = this.getLoadingStage(stack);
        double posX = entity.func_226277_ct_();
        double posY = entity.func_226278_cu_();
        double posZ = entity.func_226281_cx_();
        if (loadingStage == 0 && usingDuration >= 5) {
            world.func_184148_a(null, posX, posY, posZ, SOUND_MUSKET_LOAD_0, SoundCategory.PLAYERS, 0.5f, 1.0f);
            loadingStage = 1;
        } else if (loadingStage == 1 && usingDuration >= 10) {
            world.func_184148_a(null, posX, posY, posZ, SOUND_MUSKET_LOAD_1, SoundCategory.PLAYERS, 0.5f, 1.0f);
            loadingStage = 2;
        } else if (loadingStage == 2 && usingDuration >= 20) {
            world.func_184148_a(null, posX, posY, posZ, SOUND_MUSKET_LOAD_2, SoundCategory.PLAYERS, 0.5f, 1.0f);
            loadingStage = 3;
        }
        this.setLoadingStage(stack, loadingStage);
    }

    public void onUsingTick(ItemStack stack, LivingEntity entityLiving, int timeLeft) {
        if (!(entityLiving instanceof PlayerEntity)) {
            return;
        }
        if (this.func_77626_a(stack) - timeLeft >= 30 && !MusketItem.isLoaded(stack)) {
            PlayerEntity player = (PlayerEntity)entityLiving;
            if (!player.field_71075_bZ.field_75098_d) {
                ItemStack ammoStack = this.findAmmo(player);
                if (ammoStack.func_190926_b()) {
                    return;
                }
                ammoStack.func_190918_g(1);
                if (ammoStack.func_190926_b()) {
                    player.field_71071_by.func_184437_d(ammoStack);
                }
            }
            player.func_184185_a(SOUND_MUSKET_READY, 0.5f, 1.0f);
            this.setLoaded(stack, true);
        }
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!worldIn.field_72995_K && entityLiving instanceof PlayerEntity && state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            MusketItem.damageItem(stack, (PlayerEntity)entityLiving);
        }
        return false;
    }

    public static void damageItem(ItemStack stack, PlayerEntity player) {
        stack.func_222118_a(1, (LivingEntity)player, entity -> entity.func_213334_d(player.func_184600_cs()));
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public static boolean isLoaded(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        return tag != null && tag.func_74771_c("loaded") == 1;
    }

    public static boolean isReady(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        return tag != null && tag.func_74771_c("ready") == 1;
    }

    private boolean isAmmo(ItemStack stack) {
        return stack.func_77973_b() == CARTRIDGE;
    }

    private ItemStack findAmmo(PlayerEntity player) {
        if (this.isAmmo(player.func_184586_b(Hand.OFF_HAND))) {
            return player.func_184586_b(Hand.OFF_HAND);
        }
        if (this.isAmmo(player.func_184586_b(Hand.MAIN_HAND))) {
            return player.func_184586_b(Hand.MAIN_HAND);
        }
        for (int i = 0; i != player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isAmmo(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    private Vector3d getPlayerFiringPoint(PlayerEntity player) {
        Vector3d side = Vector3d.func_189986_a((float)0.0f, (float)(player.field_70177_z + 90.0f));
        if (player.func_184600_cs() == Hand.OFF_HAND) {
            side = side.func_186678_a(-1.0);
        }
        Vector3d down = Vector3d.func_189986_a((float)(player.field_70125_A + 90.0f), (float)player.field_70177_z);
        double posX = player.func_226277_ct_();
        double posY = player.func_226278_cu_();
        double posZ = player.func_226281_cx_();
        return new Vector3d(posX, posY + (double)player.func_70047_e(), posZ).func_178787_e(side.func_178787_e(down).func_186678_a(0.1));
    }

    private void fireBullet(World worldIn, PlayerEntity player) {
        Vector3d pos = this.getPlayerFiringPoint(player);
        Vector3d front = Vector3d.func_189986_a((float)player.field_70125_A, (float)player.field_70177_z);
        float angle = (float)Math.PI * 2 * field_77697_d.nextFloat();
        float gaussian = Math.abs((float)field_77697_d.nextGaussian());
        if (gaussian > 4.0f) {
            gaussian = 4.0f;
        }
        front = front.func_178789_a(bulletStdDev * gaussian * MathHelper.func_76126_a((float)angle)).func_178785_b(bulletStdDev * gaussian * MathHelper.func_76134_b((float)angle));
        Vector3d motion = front.func_186678_a(bulletSpeed);
        Vector3d playerMotion = player.func_213322_ci();
        motion.func_72441_c(playerMotion.field_72450_a, player.func_233570_aj_() ? 0.0 : playerMotion.field_72448_b, playerMotion.field_72449_c);
        BulletEntity bullet = new BulletEntity(worldIn);
        bullet.func_212361_a((Entity)player);
        bullet.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        bullet.func_213317_d(motion);
        bullet.doFireParticles = true;
        worldIn.func_217376_c((Entity)bullet);
    }

    private void setLoaded(ItemStack stack, boolean loaded) {
        stack.func_196082_o().func_74774_a("loaded", (byte)(loaded ? 1 : 0));
    }

    private void setReady(ItemStack stack, boolean ready) {
        stack.func_196082_o().func_74774_a("ready", (byte)(ready ? 1 : 0));
    }

    private void setLoadingStage(ItemStack stack, int loadingStage) {
        stack.func_196082_o().func_74768_a("loadingStage", loadingStage);
    }

    private int getLoadingStage(ItemStack stack) {
        return stack.func_196082_o().func_74762_e("loadingStage");
    }
}

