/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts;

import chumbanotz.mutantbeasts.MBConfig;
import chumbanotz.mutantbeasts.entity.CreeperMinionEntity;
import chumbanotz.mutantbeasts.entity.EndersoulFragmentEntity;
import chumbanotz.mutantbeasts.entity.MBEntityType;
import chumbanotz.mutantbeasts.entity.mutant.MutantCreeperEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantZombieEntity;
import chumbanotz.mutantbeasts.entity.mutant.SpiderPigEntity;
import chumbanotz.mutantbeasts.item.ArmorBlockItem;
import chumbanotz.mutantbeasts.item.HulkHammerItem;
import chumbanotz.mutantbeasts.item.MBItems;
import chumbanotz.mutantbeasts.particles.MBParticleTypes;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import chumbanotz.mutantbeasts.util.SeismicWave;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mutantbeasts")
public class EventHandler {
    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof CreatureEntity) {
            CreatureEntity creature = (CreatureEntity)event.getEntity();
            if (EntityUtil.isFeline((LivingEntity)creature)) {
                creature.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal(creature, MutantCreeperEntity.class, 16.0f, 1.33, 1.33));
            }
            if (creature.func_200600_R() == EntityType.field_200784_X) {
                creature.field_70714_bg.func_75776_a(2, (Goal)new TemptGoal(creature, 1.0, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151071_bq}), false));
            }
            if (creature.func_200600_R() == EntityType.field_200756_av) {
                creature.field_70714_bg.func_75776_a(0, (Goal)new AvoidEntityGoal(creature, MutantZombieEntity.class, 12.0f, 0.8, 0.8));
            }
            if (creature.func_200600_R() == EntityType.field_220351_aK) {
                creature.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal(creature, MutantZombieEntity.class, 12.0f, 0.5, 0.5));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getPlayer().func_184586_b(event.getHand());
        if (event.getTarget().func_200600_R() == EntityType.field_200784_X && !((LivingEntity)event.getTarget()).func_70644_a(Effects.field_189112_A) && stack.func_77973_b() == Items.field_151071_bq) {
            if (!event.getPlayer().func_184812_l_()) {
                stack.func_190918_g(1);
            }
            ((LivingEntity)event.getTarget()).func_195064_c(new EffectInstance(Effects.field_189112_A, 600, 13));
            event.setCancellationResult(ActionResultType.SUCCESS);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        float damage;
        if (event.getEntityLiving() instanceof PlayerEntity && event.getEntityLiving().func_184582_a(EquipmentSlotType.HEAD).func_77973_b() instanceof ArmorBlockItem && !((damage = event.getAmount()) <= 0.0f)) {
            if ((damage /= 4.0f) < 1.0f) {
                damage = 1.0f;
            }
            ItemStack itemstack = event.getEntityLiving().func_184582_a(EquipmentSlotType.HEAD);
            if (!event.getSource().func_76347_k() || !itemstack.func_77973_b().func_234687_u_()) {
                itemstack.func_222118_a((int)damage, event.getEntityLiving(), livingEntity -> livingEntity.func_213361_c(EquipmentSlotType.HEAD));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        ItemStack itemStack;
        Entity trueSource = event.getSource().func_76346_g();
        if (SpiderPigEntity.isPigOrSpider(event.getEntityLiving()) && trueSource instanceof SpiderPigEntity) {
            event.setCanceled(true);
        }
        if ((trueSource instanceof MutantCreeperEntity && ((MutantCreeperEntity)trueSource).isCharged() || trueSource instanceof CreeperMinionEntity && ((CreeperMinionEntity)trueSource).isCharged()) && event.getSource().func_94541_c() && !(itemStack = EntityUtil.getSkullDrop(event.getEntityLiving())).func_190926_b()) {
            event.getDrops().add(new ItemEntity(trueSource.field_70170_p, event.getEntityLiving().func_226277_ct_(), event.getEntityLiving().func_226278_cu_(), event.getEntityLiving().func_226281_cx_(), itemStack));
        }
    }

    @SubscribeEvent
    public static void onLivingUseItem(LivingEntityUseItemEvent.Tick event) {
        if (event.getEntityLiving().func_184582_a(EquipmentSlotType.CHEST).func_77973_b() == MBItems.MUTANT_SKELETON_CHESTPLATE && event.getItem().func_77975_n() == UseAction.BOW && event.getDuration() > 4) {
            event.setDuration(event.getDuration() - 3);
        }
    }

    @SubscribeEvent
    public static void onPlayerShootArrow(ArrowLooseEvent event) {
        if (event.getPlayer().func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == MBItems.MUTANT_SKELETON_SKULL && event.hasAmmo()) {
            event.setCanceled(true);
            PlayerEntity player = event.getPlayer();
            World world = event.getWorld();
            ItemStack bow = event.getBow();
            boolean inAir = !player.func_233570_aj_() && !player.func_70090_H() && !player.func_180799_ab();
            ItemStack ammo = player.func_213356_f(bow);
            if (!ammo.func_190926_b() || event.hasAmmo()) {
                boolean infiniteArrows;
                if (ammo.func_190926_b()) {
                    ammo = new ItemStack((IItemProvider)Items.field_151032_g);
                }
                float velocity = BowItem.func_185059_b((int)(bow.func_77988_m() - event.getCharge()));
                boolean bl = infiniteArrows = player.field_71075_bZ.field_75098_d || ammo.func_77973_b() instanceof ArrowItem && ((ArrowItem)ammo.func_77973_b()).isInfinite(ammo, bow, player);
                if (!world.field_72995_K) {
                    int k;
                    int j;
                    ArrowItem arrowitem = (ArrowItem)(ammo.func_77973_b() instanceof ArrowItem ? ammo.func_77973_b() : Items.field_151032_g);
                    AbstractArrowEntity abstractarrowentity = arrowitem.func_200887_a(world, ammo, (LivingEntity)player);
                    abstractarrowentity = ((BowItem)bow.func_77973_b()).customArrow(abstractarrowentity);
                    abstractarrowentity.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, velocity * 3.0f, 1.0f);
                    if (velocity == 1.0f && inAir) {
                        abstractarrowentity.func_70243_d(true);
                    }
                    if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)bow)) > 0) {
                        abstractarrowentity.func_70239_b(abstractarrowentity.func_70242_d() + (double)j * 0.5 + 0.5);
                    }
                    if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)bow)) > 0) {
                        abstractarrowentity.func_70240_a(k);
                    }
                    if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)bow) > 0) {
                        abstractarrowentity.func_70015_d(100);
                    }
                    abstractarrowentity.func_70239_b(abstractarrowentity.func_70242_d() * (inAir ? 2.0 : 0.5));
                    bow.func_222118_a(1, (LivingEntity)player, p_220009_1_ -> p_220009_1_.func_213334_d(player.func_184600_cs()));
                    if (infiniteArrows || player.field_71075_bZ.field_75098_d && (ammo.func_77973_b() == Items.field_185166_h || ammo.func_77973_b() == Items.field_185167_i)) {
                        abstractarrowentity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                    }
                    world.func_217376_c((Entity)abstractarrowentity);
                }
                world.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (player.func_70681_au().nextFloat() * 0.4f + 1.2f) + velocity * 0.5f);
                if (!infiniteArrows && !player.field_71075_bZ.field_75098_d) {
                    ammo.func_190918_g(1);
                    if (ammo.func_190926_b()) {
                        player.field_71071_by.func_184437_d(ammo);
                    }
                }
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)bow.func_77973_b()));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EventHandler.playShoulderEntitySound(event.player, event.player.func_192023_dk());
        EventHandler.playShoulderEntitySound(event.player, event.player.func_192025_dl());
        if (!event.player.field_70170_p.field_72995_K && !HulkHammerItem.WAVES.isEmpty() && HulkHammerItem.WAVES.containsKey(event.player.func_110124_au())) {
            PlayerEntity player = event.player;
            List<SeismicWave> waveList = HulkHammerItem.WAVES.get(player.func_110124_au());
            while (waveList.size() > 16) {
                waveList.remove(0);
            }
            SeismicWave wave = waveList.remove(0);
            wave.affectBlocks(player.field_70170_p, (Entity)player);
            AxisAlignedBB box = new AxisAlignedBB((double)wave.func_177958_n(), (double)wave.func_177956_o() + 1.0, (double)wave.func_177952_p(), (double)wave.func_177958_n() + 1.0, (double)wave.func_177956_o() + 2.0, (double)wave.func_177952_p() + 1.0);
            for (LivingEntity livingEntity : player.field_70170_p.func_217357_a(LivingEntity.class, box)) {
                if (livingEntity == player || player.func_184187_bx() == livingEntity) continue;
                livingEntity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player).func_151518_m(), (float)(6 + player.func_70681_au().nextInt(3)));
            }
            if (waveList.isEmpty()) {
                HulkHammerItem.WAVES.remove(player.func_110124_au());
            }
        }
    }

    @SubscribeEvent
    public static void onItemToss(ItemTossEvent event) {
        World world = event.getPlayer().field_70170_p;
        PlayerEntity player = event.getPlayer();
        if (!world.field_72995_K) {
            boolean isHand;
            ItemStack stack = event.getEntityItem().func_92059_d();
            boolean bl = isHand = stack.func_77973_b() == MBItems.ENDERSOUL_HAND && stack.func_77951_h();
            if (stack.func_77973_b() == Items.field_151061_bv || isHand) {
                int count = 0;
                for (EndersoulFragmentEntity orb : world.func_217357_a(EndersoulFragmentEntity.class, player.func_174813_aQ().func_186662_g(8.0))) {
                    if (orb.getOwner() != player) continue;
                    ++count;
                    orb.func_70106_y();
                }
                if (count > 0) {
                    EntityUtil.sendParticlePacket((Entity)player, (IParticleData)MBParticleTypes.ENDERSOUL, 256);
                    int addDmg = count * 60;
                    if (isHand) {
                        int dmg = stack.func_77952_i() - addDmg;
                        stack.func_196085_b(Math.max(dmg, 0));
                    } else {
                        ItemStack newStack = new ItemStack((IItemProvider)MBItems.ENDERSOUL_HAND);
                        newStack.func_196085_b(MBItems.ENDERSOUL_HAND.getMaxDamage(stack) - addDmg);
                        event.getEntityItem().func_92058_a(newStack);
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void addBiomeSpawns(BiomeLoadingEvent event) {
        ResourceLocation name = event.getName();
        List biomeWhitelist = (List)MBConfig.COMMON.biomeWhitelist.get();
        if (biomeWhitelist.isEmpty() || !biomeWhitelist.contains(name.func_110624_b())) {
            return;
        }
        Biome.Category category = event.getCategory();
        List monsterSpawners = event.getSpawns().getSpawner(EntityClassification.MONSTER);
        if (!monsterSpawners.isEmpty() && category != Biome.Category.MUSHROOM) {
            if (category != Biome.Category.NETHER || Biomes.field_235254_j_.getRegistryName().equals((Object)name) || Biomes.field_235252_ay_.getRegistryName().equals((Object)name) || Biomes.field_235250_aA_.getRegistryName().equals((Object)name)) {
                EventHandler.addSpawn(monsterSpawners, MBEntityType.MUTANT_ENDERMAN, (Integer)MBConfig.COMMON.mutantEndermanSpawnWeight.get(), 1, 1);
                if ((Biomes.field_235252_ay_.getRegistryName().equals((Object)name) || Biomes.field_235250_aA_.getRegistryName().equals((Object)name)) && (Integer)MBConfig.COMMON.mutantEndermanSpawnWeight.get() > 0) {
                    event.getSpawns().func_242573_a(MBEntityType.MUTANT_ENDERMAN, 0.7, 0.15);
                }
            }
            if (category != Biome.Category.THEEND) {
                if (category != Biome.Category.NETHER || Biomes.field_235252_ay_.getRegistryName().equals((Object)name)) {
                    EventHandler.addSpawn(monsterSpawners, MBEntityType.MUTANT_SKELETON, (Integer)MBConfig.COMMON.mutantSkeletonSpawnWeight.get(), 1, 1);
                    if (Biomes.field_235252_ay_.getRegistryName().equals((Object)name) && (Integer)MBConfig.COMMON.mutantSkeletonSpawnWeight.get() > 0) {
                        event.getSpawns().func_242573_a(MBEntityType.MUTANT_SKELETON, 0.7, 0.15);
                    }
                }
                if (category != Biome.Category.NETHER) {
                    EventHandler.addSpawn(monsterSpawners, MBEntityType.MUTANT_CREEPER, (Integer)MBConfig.COMMON.mutantCreeperSpawnWeight.get(), 1, 1);
                    EventHandler.addSpawn(monsterSpawners, MBEntityType.MUTANT_ZOMBIE, (Integer)MBConfig.COMMON.mutantZombieSpawnWeight.get(), 1, 1);
                }
            }
        }
    }

    private static void addSpawn(List<MobSpawnInfo.Spawners> spawners, EntityType<? extends MobEntity> entityType, int weight, int min, int max) {
        if (weight > 0) {
            spawners.add(new MobSpawnInfo.Spawners(entityType, weight, min, max));
        }
    }

    private static void playShoulderEntitySound(PlayerEntity player, @Nullable CompoundNBT compoundNBT) {
        block3: {
            block2: {
                if (compoundNBT != null && !compoundNBT.func_74764_b("Silent")) break block2;
                if (compoundNBT.func_74767_n("Silent")) break block3;
            }
            EntityType.func_220327_a((String)compoundNBT.func_74779_i("id")).filter(MBEntityType.CREEPER_MINION::equals).ifPresent(entityType -> {
                if (player.field_70170_p.field_73012_v.nextInt(500) == 0) {
                    player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), MBSoundEvents.ENTITY_CREEPER_MINION_AMBIENT, player.func_184176_by(), 1.0f, (player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.5f);
                }
            });
        }
    }
}

