/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.animationapi;

import chumbanotz.mutantbeasts.client.animationapi.Animation;
import chumbanotz.mutantbeasts.packet.AnimationPacket;
import chumbanotz.mutantbeasts.packet.MBPacketHandler;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.commons.lang3.ArrayUtils;

public interface IAnimatedEntity
extends IEntityAdditionalSpawnData {
    public Animation getAnimation();

    public void setAnimation(Animation var1);

    public Animation[] getAnimations();

    public int getAnimationTick();

    public void setAnimationTick(int var1);

    default public boolean isAnimationPlaying() {
        return this.getAnimation() != Animation.NONE;
    }

    default public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(ArrayUtils.indexOf((Object[])this.getAnimations(), (Object)this.getAnimation()));
        buffer.writeInt(this.getAnimationTick());
    }

    default public void readSpawnData(PacketBuffer additionalData) {
        int animationId = additionalData.readInt();
        this.setAnimation(animationId < 0 ? Animation.NONE : this.getAnimations()[animationId]);
        this.setAnimationTick(additionalData.readInt());
    }

    public static <T extends Entity> void sendAnimationPacket(T entity, Animation animation) {
        if (!entity.field_70170_p.field_72995_K) {
            ((IAnimatedEntity)entity).setAnimation(animation);
            ((IAnimatedEntity)entity).setAnimationTick(0);
            MBPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new AnimationPacket(entity.func_145782_y(), ArrayUtils.indexOf((Object[])((IAnimatedEntity)entity).getAnimations(), (Object)animation)));
        }
    }
}

