/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.renderer.entity;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.client.renderer.MBRenderType;
import chumbanotz.mutantbeasts.client.renderer.entity.AlternateMobRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.layers.EndersoulLayer;
import chumbanotz.mutantbeasts.client.renderer.entity.model.MutantEndermanModel;
import chumbanotz.mutantbeasts.entity.mutant.MutantEndermanEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EndermanModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class MutantEndermanRenderer
extends AlternateMobRenderer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>> {
    private static final ResourceLocation TEXTURE = MutantBeasts.getEntityTexture("mutant_enderman/mutant_enderman");
    private static final ResourceLocation DEATH_TEXTURE = MutantBeasts.getEntityTexture("mutant_enderman/death");
    private static final RenderType EYES_RENDER_TYPE = MBRenderType.getEyes(MutantBeasts.getEntityTexture("mutant_enderman/eyes"));
    private static final RenderType DEATH_RENDER_TYPE = RenderType.func_228648_g_((ResourceLocation)TEXTURE);
    private final MutantEndermanModel endermanModel;
    private final EndermanModel<MutantEndermanEntity> cloneModel;
    private boolean teleportAttack;

    public MutantEndermanRenderer(EntityRendererManager manager) {
        super(manager, new MutantEndermanModel(), 0.8f);
        this.endermanModel = (MutantEndermanModel)this.field_77045_g;
        this.cloneModel = new EndermanModel(0.0f);
        this.func_177094_a(new EyesLayer((IEntityRenderer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>>)this));
        this.func_177094_a(new SoulLayer((IEntityRenderer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>>)this));
        this.func_177094_a(new HeldBlocksLayer((IEntityRenderer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>>)this));
    }

    public boolean shouldRender(MutantEndermanEntity livingEntityIn, ClippingHelper camera, double camX, double camY, double camZ) {
        if (super.func_225626_a_((MobEntity)livingEntityIn, camera, camX, camY, camZ)) {
            return true;
        }
        if (livingEntityIn.getAnimation() == MutantEndermanEntity.TELEPORT_ANIMATION) {
            AxisAlignedBB teleportBoundingBox = livingEntityIn.getTeleportPosition().map(Vector3d::func_237492_c_).map(arg_0 -> ((EntitySize)livingEntityIn.func_200600_R().func_220334_j()).func_242286_a(arg_0)).get();
            return camera.func_228957_a_(teleportBoundingBox);
        }
        return false;
    }

    public void render(MutantEndermanEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (entityIn.isClone()) {
            this.field_77045_g = this.cloneModel;
            this.cloneModel.field_78125_b = entityIn.func_213398_dR();
            this.field_76989_e = 0.5f;
            this.field_76987_f = 0.5f;
        } else {
            this.field_77045_g = this.endermanModel;
            this.field_76989_e = 0.8f;
            this.field_76987_f = entityIn.field_70725_aQ > 80 ? 1.0f - MutantEndermanRenderer.getDeathProgress(entityIn) : 1.0f;
        }
        this.teleportAttack = false;
        super.func_225623_a_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        if (entityIn.getAnimation() == MutantEndermanEntity.TELEPORT_ANIMATION) {
            this.teleportAttack = true;
            entityIn.getTeleportPosition().ifPresent(pos -> {
                matrixStackIn.func_227860_a_();
                double d0 = MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70142_S, (double)entityIn.func_226277_ct_());
                double d1 = MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70137_T, (double)entityIn.func_226278_cu_());
                double d2 = MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70136_U, (double)entityIn.func_226281_cx_());
                matrixStackIn.func_227861_a_((double)pos.func_177958_n() + 0.5 - d0, (double)pos.func_177956_o() - d1, (double)pos.func_177952_p() + 0.5 - d2);
                super.func_225623_a_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
                matrixStackIn.func_227865_b_();
            });
        }
    }

    @Override
    protected boolean hasAlternateRender(MutantEndermanEntity mob, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (mob.field_70725_aQ > 80) {
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_239264_a_((ResourceLocation)DEATH_TEXTURE, (float)MutantEndermanRenderer.getDeathProgress(mob)));
            this.field_77045_g.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            IVertexBuilder ivertexbuilder1 = bufferIn.getBuffer(DEATH_RENDER_TYPE);
            this.field_77045_g.func_225598_a_(matrixStackIn, ivertexbuilder1, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public Vector3d getRenderOffset(MutantEndermanEntity entityIn, float partialTicks) {
        boolean death;
        boolean stare = entityIn.getAnimation() == MutantEndermanEntity.STARE_ANIMATION;
        boolean scream = entityIn.getAnimation() == MutantEndermanEntity.SCREAM_ANIMATION;
        boolean clone = entityIn.isClone() && entityIn.func_213398_dR();
        boolean telesmash = entityIn.getAnimation() == MutantEndermanEntity.TELESMASH_ANIMATION && entityIn.getAnimationTick() < 18;
        boolean bl = death = entityIn.getAnimation() == MutantEndermanEntity.DEATH_ANIMATION;
        if (stare || scream || clone || telesmash || death) {
            double shake = 0.03;
            if (clone) {
                shake = 0.02;
            } else if (death) {
                shake = entityIn.getAnimationTick() < 80 ? (double)0.02f : (double)0.05f;
            } else if (entityIn.getAnimationTick() >= 40) {
                shake *= 0.5;
            }
            return new Vector3d(entityIn.func_70681_au().nextGaussian() * shake, 0.0, entityIn.func_70681_au().nextGaussian() * shake);
        }
        return super.func_225627_b_((Entity)entityIn, partialTicks);
    }

    protected float getDeathMaxRotation(MutantEndermanEntity livingEntity) {
        return 0.0f;
    }

    protected RenderType func_230496_a_(MutantEndermanEntity livingEntity, boolean isVisible, boolean visibleToSpectator, boolean isGlowing) {
        return livingEntity.isClone() ? null : super.func_230496_a_((LivingEntity)livingEntity, isVisible, visibleToSpectator, isGlowing);
    }

    private static float getDeathProgress(MutantEndermanEntity mutantEnderman) {
        return (float)(mutantEnderman.field_70725_aQ - 80) / (float)(MutantEndermanEntity.DEATH_ANIMATION.getDuration() - 80);
    }

    public ResourceLocation getEntityTexture(MutantEndermanEntity entity) {
        return TEXTURE;
    }

    static class HeldBlocksLayer
    extends LayerRenderer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>> {
        public HeldBlocksLayer(IEntityRenderer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, MutantEndermanEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entity.getAnimation() == MutantEndermanEntity.CLONE_ANIMATION) {
                return;
            }
            for (int i = 0; i < 4; ++i) {
                if (entity.getHeldBlock(i) <= 0) continue;
                matrixStackIn.func_227860_a_();
                ((MutantEndermanModel)this.func_215332_c()).translateRotateArm(matrixStackIn, i);
                matrixStackIn.func_227861_a_(0.0, 1.2, 0.0);
                float tick = (float)entity.field_70173_aa + (float)(i + 1) * 2.0f * (float)Math.PI + partialTicks;
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(tick * 10.0f));
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(tick * 8.0f));
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(tick * 6.0f));
                matrixStackIn.func_227862_a_(-0.75f, -0.75f, 0.75f);
                matrixStackIn.func_227861_a_(-0.5, -0.5, 0.5);
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                Minecraft.func_71410_x().func_175602_ab().renderBlock(Block.func_196257_b((int)entity.getHeldBlock(i)), matrixStackIn, bufferIn, packedLightIn, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
                matrixStackIn.func_227865_b_();
            }
        }
    }

    class SoulLayer
    extends EndersoulLayer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>> {
        public SoulLayer(IEntityRenderer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>> entityRendererIn) {
            super(entityRendererIn);
        }

        @Override
        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, MutantEndermanEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            boolean teleport = entity.getAnimation() == MutantEndermanEntity.TELEPORT_ANIMATION && entity.getAnimationTick() < 10;
            boolean scream = entity.getAnimation() == MutantEndermanEntity.SCREAM_ANIMATION;
            boolean clone = entity.isClone();
            if (teleport || scream || clone) {
                float scale = 0.0f;
                if (teleport) {
                    scale = 1.2f + ((float)entity.getAnimationTick() + partialTicks) / 10.0f;
                    if (MutantEndermanRenderer.this.teleportAttack) {
                        scale = 2.2f - ((float)entity.getAnimationTick() + partialTicks) / 10.0f;
                    }
                }
                if (scream) {
                    scale = entity.getAnimationTick() < 40 ? 1.2f + ((float)entity.getAnimationTick() + partialTicks) / 40.0f : (entity.getAnimationTick() < 160 ? 2.2f : Math.max(0.0f, 2.2f - ((float)entity.getAnimationTick() + partialTicks) / 10.0f));
                }
                matrixStackIn.func_227860_a_();
                if (!clone) {
                    matrixStackIn.func_227862_a_(scale, scale * 0.8f, scale);
                }
                super.render(matrixStackIn, bufferIn, packedLightIn, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                matrixStackIn.func_227865_b_();
            }
        }

        @Override
        protected float getAlpha(MutantEndermanEntity entity, float partialTicks) {
            float alpha = 1.0f;
            if (entity.getAnimation() == MutantEndermanEntity.TELEPORT_ANIMATION) {
                if (!MutantEndermanRenderer.this.teleportAttack && entity.getAnimationTick() >= 8) {
                    alpha -= ((float)entity.getAnimationTick() - 8.0f + partialTicks) / 2.0f;
                }
                if (MutantEndermanRenderer.this.teleportAttack && entity.getAnimationTick() < 2) {
                    alpha = ((float)entity.getAnimationTick() + partialTicks) / 2.0f;
                }
            }
            if (entity.getAnimation() == MutantEndermanEntity.SCREAM_ANIMATION) {
                if (entity.getAnimationTick() < 40) {
                    alpha = ((float)entity.getAnimationTick() + partialTicks) / 40.0f;
                } else if (entity.getAnimationTick() >= 160) {
                    alpha = 1.0f - ((float)entity.getAnimationTick() + partialTicks) / 40.0f;
                }
            }
            return alpha;
        }
    }

    static class EyesLayer
    extends LayerRenderer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>> {
        public EyesLayer(IEntityRenderer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, MutantEndermanEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!entity.isClone()) {
                IVertexBuilder ivertexbuilder = bufferIn.getBuffer(EYES_RENDER_TYPE);
                this.func_215332_c().func_225598_a_(matrixStackIn, ivertexbuilder, 0xF00000, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, entity.field_70725_aQ > 80 ? 1.0f - MutantEndermanRenderer.getDeathProgress(entity) : 1.0f);
            }
        }
    }
}

