/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.renderer.entity.model;

import chumbanotz.mutantbeasts.client.animationapi.Animator;
import chumbanotz.mutantbeasts.client.renderer.entity.model.MutantCrossbowModel;
import chumbanotz.mutantbeasts.client.renderer.model.JointModelRenderer;
import chumbanotz.mutantbeasts.client.renderer.model.ScalableModelRenderer;
import chumbanotz.mutantbeasts.entity.mutant.MutantSkeletonEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public class MutantSkeletonModel
extends EntityModel<MutantSkeletonEntity> {
    private final List<ModelRenderer> modelRenderers = new ArrayList<ModelRenderer>();
    protected ModelRenderer skeleBase;
    protected ModelRenderer pelvis;
    protected ModelRenderer waist;
    protected Spine[] spine;
    protected ModelRenderer neck;
    protected JointModelRenderer head;
    protected ModelRenderer jaw;
    protected ModelRenderer shoulder1;
    protected ModelRenderer shoulder2;
    protected JointModelRenderer arm1;
    protected JointModelRenderer arm2;
    protected JointModelRenderer forearm1;
    protected JointModelRenderer forearm2;
    protected JointModelRenderer leg1;
    protected JointModelRenderer leg2;
    protected JointModelRenderer foreleg1;
    protected JointModelRenderer foreleg2;
    protected MutantCrossbowModel crossbow;
    protected final Animator animator = new Animator();
    protected float partialTick;

    public MutantSkeletonModel() {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
        this.skeleBase = new ModelRenderer((Model)this);
        this.skeleBase.func_78793_a(0.0f, 3.0f, 0.0f);
        this.pelvis = new ModelRenderer((Model)this, 0, 16);
        this.pelvis.func_228300_a_(-4.0f, -6.0f, -3.0f, 8.0f, 6.0f, 6.0f);
        this.skeleBase.func_78792_a(this.pelvis);
        this.waist = new ModelRenderer((Model)this, 32, 0);
        this.waist.func_228300_a_(-2.5f, -8.0f, -2.0f, 5.0f, 8.0f, 4.0f);
        this.waist.func_78793_a(0.0f, -5.0f, 0.0f);
        this.pelvis.func_78792_a(this.waist);
        this.spine = new Spine[3];
        this.spine[0] = new Spine((Model)this);
        this.spine[0].middle.func_78793_a(0.0f, -7.0f, 0.0f);
        this.waist.func_78792_a(this.spine[0].middle);
        for (int i = 1; i < this.spine.length; ++i) {
            this.spine[i] = new Spine((Model)this);
            this.spine[i].middle.func_78793_a(0.0f, -5.0f, 0.0f);
            this.spine[i - 1].middle.func_78792_a(this.spine[i].middle);
        }
        this.neck = new ModelRenderer((Model)this, 64, 0);
        this.neck.func_228300_a_(-1.5f, -4.0f, -1.5f, 3.0f, 4.0f, 3.0f);
        this.neck.func_78793_a(0.0f, -4.0f, 0.0f);
        this.spine[2].middle.func_78792_a(this.neck);
        this.head = new JointModelRenderer((Model)this, 0, 0);
        this.head.func_228301_a_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, 0.4f);
        this.head.func_78793_a(0.0f, -4.0f, -1.0f);
        this.neck.func_78792_a((ModelRenderer)this.head);
        this.jaw = new ModelRenderer((Model)this, 72, 0);
        this.jaw.func_228301_a_(-4.0f, -3.0f, -8.0f, 8.0f, 3.0f, 8.0f, 0.7f);
        this.jaw.func_78793_a(0.0f, -0.2f, 3.5f);
        this.head.func_78792_a(this.jaw);
        this.shoulder1 = new ModelRenderer((Model)this, 28, 16);
        this.shoulder1.func_228300_a_(-4.0f, -3.0f, -3.0f, 8.0f, 3.0f, 6.0f);
        this.shoulder1.func_78793_a(-7.0f, -3.0f, -1.0f);
        this.spine[2].middle.func_78792_a(this.shoulder1);
        this.shoulder2 = new ModelRenderer((Model)this, 28, 16);
        this.shoulder2.field_78809_i = true;
        this.shoulder2.func_228300_a_(-4.0f, -3.0f, -3.0f, 8.0f, 3.0f, 6.0f);
        this.shoulder2.func_78793_a(7.0f, -3.0f, -1.0f);
        this.spine[2].middle.func_78792_a(this.shoulder2);
        this.arm1 = new JointModelRenderer((Model)this, 0, 28);
        this.arm1.func_228300_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f);
        this.arm1.func_78793_a(-1.0f, -1.0f, 0.0f);
        this.shoulder1.func_78792_a((ModelRenderer)this.arm1);
        this.arm2 = new JointModelRenderer((Model)this, 0, 28);
        this.arm2.field_78809_i = true;
        this.arm2.func_228300_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f);
        this.arm2.func_78793_a(1.0f, -1.0f, 0.0f);
        this.shoulder2.func_78792_a((ModelRenderer)this.arm2);
        this.forearm1 = new JointModelRenderer((Model)this, 16, 28);
        this.forearm1.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 14.0f, 4.0f, -0.01f);
        this.forearm1.func_78793_a(0.0f, 11.0f, 0.0f);
        this.arm1.func_78792_a(this.forearm1);
        this.forearm2 = new JointModelRenderer((Model)this, 16, 28);
        this.forearm2.field_78809_i = true;
        this.forearm2.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 14.0f, 4.0f, -0.01f);
        this.forearm2.func_78793_a(0.0f, 11.0f, 0.0f);
        this.arm2.func_78792_a(this.forearm2);
        this.leg1 = new JointModelRenderer((Model)this, 0, 28);
        this.leg1.func_228300_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f);
        this.leg1.func_78793_a(-2.5f, -2.5f, 0.0f);
        this.pelvis.func_78792_a((ModelRenderer)this.leg1);
        this.leg2 = new JointModelRenderer((Model)this, 0, 28);
        this.leg2.field_78809_i = true;
        this.leg2.func_228300_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f);
        this.leg2.func_78793_a(2.5f, -2.5f, 0.0f);
        this.pelvis.func_78792_a((ModelRenderer)this.leg2);
        this.foreleg1 = new JointModelRenderer((Model)this, 32, 28);
        this.foreleg1.func_228300_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f);
        this.foreleg1.func_78793_a(0.0f, 12.0f, 0.0f);
        this.leg1.func_78792_a(this.foreleg1);
        this.foreleg2 = new JointModelRenderer((Model)this, 32, 28);
        this.foreleg2.field_78809_i = true;
        this.foreleg2.func_228300_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f);
        this.foreleg2.func_78793_a(0.0f, 12.0f, 0.0f);
        this.leg2.func_78792_a(this.foreleg2);
        this.crossbow = new MutantCrossbowModel((Model)this);
        this.crossbow.armwear.func_78793_a(0.0f, 8.0f, 0.0f);
    }

    public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.skeleBase.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    public void setRotationAngles(MutantSkeletonEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.animator.update(entityIn, this.partialTick);
        this.setAngles();
        this.animate(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    public void accept(ModelRenderer modelRenderer) {
        this.modelRenderers.add(modelRenderer);
    }

    protected void setAngles() {
        for (ModelRenderer modelRenderer : this.modelRenderers) {
            modelRenderer.field_78795_f = 0.0f;
            modelRenderer.field_78796_g = 0.0f;
            modelRenderer.field_78808_h = 0.0f;
        }
        this.skeleBase.field_78797_d = 3.0f;
        this.pelvis.field_78795_f = -0.31415927f;
        this.waist.field_78795_f = 0.22439948f;
        for (int i = 0; i < this.spine.length; ++i) {
            this.spine[i].setAngles((float)Math.PI, i == 1);
        }
        this.neck.field_78795_f = -0.1308997f;
        this.head.field_78795_f = -0.1308997f;
        this.jaw.field_78795_f = 0.09817477f;
        this.shoulder1.field_78795_f = -0.7853982f;
        this.shoulder2.field_78795_f = -0.7853982f;
        this.arm1.getModel().field_78795_f = 0.5235988f;
        this.arm1.getModel().field_78808_h = 0.31415927f;
        this.arm2.getModel().field_78795_f = 0.5235988f;
        this.arm2.getModel().field_78808_h = -0.31415927f;
        this.forearm1.getModel().field_78795_f = -0.5235988f;
        this.forearm2.getModel().field_78795_f = -0.5235988f;
        this.leg1.field_78795_f = -0.2617994f - this.pelvis.field_78795_f;
        this.leg1.field_78808_h = 0.19634955f;
        this.leg2.field_78795_f = -0.2617994f - this.pelvis.field_78795_f;
        this.leg2.field_78808_h = -0.19634955f;
        this.foreleg1.field_78808_h = -0.1308997f;
        this.foreleg1.getModel().field_78795_f = 0.31415927f;
        this.foreleg2.field_78808_h = 0.1308997f;
        this.foreleg2.getModel().field_78795_f = 0.31415927f;
        this.crossbow.setAngles((float)Math.PI);
        this.crossbow.rotateRope();
    }

    protected void animate(MutantSkeletonEntity skele, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float scale;
        float walkAnim1 = MathHelper.func_76126_a((float)(limbSwing * 0.5f));
        float walkAnim2 = MathHelper.func_76126_a((float)(limbSwing * 0.5f - 1.1f));
        float breatheAnim = MathHelper.func_76126_a((float)(ageInTicks * 0.1f));
        float faceYaw = netHeadYaw * (float)Math.PI / 180.0f;
        float facePitch = headPitch * (float)Math.PI / 180.0f;
        if (skele.getAnimation() == MutantSkeletonEntity.MELEE_ANIMATION) {
            this.animateMelee(skele.getAnimationTick(), skele.func_184638_cS());
            this.crossbow.rotateRope();
            scale = 1.0f - MathHelper.func_76131_a((float)((float)skele.getAnimationTick() / 4.0f), (float)0.0f, (float)1.0f);
            walkAnim1 *= scale;
            walkAnim2 *= scale;
        } else if (skele.getAnimation() == MutantSkeletonEntity.SHOOT_ANIMATION) {
            this.animateShoot(skele.getAnimationTick(), facePitch, faceYaw, skele.func_184638_cS());
            scale = 1.0f - MathHelper.func_76131_a((float)((float)skele.getAnimationTick() / 4.0f), (float)0.0f, (float)1.0f);
            walkAnim1 *= scale;
            walkAnim2 *= scale;
            facePitch *= scale;
            faceYaw *= scale;
        } else if (skele.getAnimation() == MutantSkeletonEntity.MULTI_SHOT_ANIMATION) {
            this.animateMultiShoot(skele.getAnimationTick(), facePitch, faceYaw, skele.func_184638_cS());
            scale = 1.0f - MathHelper.func_76131_a((float)((float)skele.getAnimationTick() / 4.0f), (float)0.0f, (float)1.0f);
            walkAnim1 *= scale;
            walkAnim2 *= scale;
            facePitch *= scale;
            faceYaw *= scale;
        } else if (this.animator.setAnimation(MutantSkeletonEntity.CONSTRICT_RIBS_ANIMATION)) {
            this.animateConstrict();
            this.crossbow.rotateRope();
            scale = 1.0f - MathHelper.func_76131_a((float)((float)skele.getAnimationTick() / 6.0f), (float)0.0f, (float)1.0f);
            facePitch *= scale;
            faceYaw *= scale;
        } else {
            this.crossbow.rotateRope();
        }
        this.skeleBase.field_78797_d -= (-0.5f + Math.abs(walkAnim1)) * limbSwingAmount;
        this.spine[0].middle.field_78796_g -= walkAnim1 * 0.06f * limbSwingAmount;
        this.arm1.field_78795_f -= walkAnim1 * 0.9f * limbSwingAmount;
        this.arm2.field_78795_f += walkAnim1 * 0.9f * limbSwingAmount;
        this.leg1.field_78795_f += (0.2f + walkAnim1) * 1.0f * limbSwingAmount;
        this.leg2.field_78795_f -= (-0.2f + walkAnim1) * 1.0f * limbSwingAmount;
        this.foreleg1.getModel().field_78795_f += (0.6f + walkAnim2) * 0.6f * limbSwingAmount;
        this.foreleg2.getModel().field_78795_f -= (-0.6f + walkAnim2) * 0.6f * limbSwingAmount;
        for (Spine spine : this.spine) {
            spine.animate(breatheAnim);
        }
        this.head.field_78795_f -= breatheAnim * 0.02f;
        this.jaw.field_78795_f += breatheAnim * 0.04f + 0.04f;
        this.arm1.field_78808_h += breatheAnim * 0.025f;
        this.arm2.field_78808_h -= breatheAnim * 0.025f;
        this.head.getModel().field_78795_f += facePitch;
        this.head.getModel().field_78796_g += faceYaw;
    }

    protected void animateMelee(int fullTick, boolean leftHanded) {
        int offset;
        JointModelRenderer meleeArm = leftHanded ? this.arm2 : this.arm1;
        JointModelRenderer offArm = leftHanded ? this.arm1 : this.arm2;
        int n = offset = leftHanded ? -1 : 1;
        if (fullTick < 3) {
            float tick = ((float)fullTick + this.partialTick) / 3.0f;
            float f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            for (Spine spine : this.spine) {
                spine.middle.field_78796_g += f * (float)Math.PI / 16.0f * (float)offset;
            }
            meleeArm.field_78796_g += f * (float)Math.PI / 10.0f * (float)offset;
            meleeArm.field_78808_h += f * (float)Math.PI / 4.0f * (float)offset;
            offArm.field_78808_h += f * (float)(-Math.PI) / 16.0f * (float)offset;
        } else if (fullTick < 5) {
            float tick = ((float)(fullTick - 3) + this.partialTick) / 2.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            for (Spine spine : this.spine) {
                spine.middle.field_78796_g += (f * 0.5890486f - 0.3926991f) * (float)offset;
            }
            meleeArm.field_78796_g += (f * 2.7307692f - 2.41661f) * (float)offset;
            meleeArm.field_78808_h += (f * 1.1780972f - 0.3926991f) * (float)offset;
            offArm.field_78808_h += -0.19634955f * (float)offset;
        } else if (fullTick < 8) {
            for (Spine spine : this.spine) {
                spine.middle.field_78796_g += -0.3926991f * (float)offset;
            }
            meleeArm.field_78796_g += -2.41661f * (float)offset;
            meleeArm.field_78808_h += -0.3926991f * (float)offset;
            offArm.field_78808_h += -0.19634955f * (float)offset;
        } else if (fullTick < 14) {
            float tick = ((float)(fullTick - 8) + this.partialTick) / 6.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            for (Spine spine : this.spine) {
                spine.middle.field_78796_g += f * (float)(-Math.PI) / 8.0f * (float)offset;
            }
            meleeArm.field_78796_g += f * (float)(-Math.PI) / 1.3f * (float)offset;
            meleeArm.field_78808_h += f * (float)(-Math.PI) / 8.0f * (float)offset;
            offArm.field_78808_h += f * (float)(-Math.PI) / 16.0f * (float)offset;
        }
    }

    protected void animateShoot(int fullTick, float facePitch, float faceYaw, boolean leftHanded) {
        int offset;
        JointModelRenderer drawingArm = leftHanded ? this.arm2 : this.arm1;
        JointModelRenderer holdingArm = leftHanded ? this.arm1 : this.arm2;
        JointModelRenderer drawingForearm = leftHanded ? this.forearm2 : this.forearm1;
        JointModelRenderer holdingforearm = leftHanded ? this.forearm1 : this.forearm2;
        int n = offset = leftHanded ? -1 : 1;
        if (fullTick < 5) {
            float tick = ((float)fullTick + this.partialTick) / 5.0f;
            float f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            drawingArm.getModel().field_78795_f += -f * (float)Math.PI / 4.0f;
            drawingArm.field_78796_g += -f * (float)Math.PI / 2.0f * (float)offset;
            drawingArm.field_78808_h += f * (float)Math.PI / 16.0f * (float)offset;
            drawingForearm.field_78795_f += f * (float)Math.PI / 7.0f;
            holdingArm.getModel().field_78795_f += -f * (float)Math.PI / 4.0f;
            holdingArm.field_78796_g += f * (float)Math.PI / 2.0f * (float)offset;
            holdingArm.field_78808_h += -f * (float)Math.PI / 16.0f * (float)offset;
            holdingArm.getModel().field_78808_h += -f * (float)Math.PI / 8.0f * (float)offset;
            holdingforearm.field_78795_f += -f * (float)Math.PI / 6.0f;
            this.crossbow.rotateRope();
        } else if (fullTick < 12) {
            float tick = ((float)(fullTick - 5) + this.partialTick) / 7.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            float f1s = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f * 0.4f));
            this.head.getModel().field_78796_g += f1 * (float)Math.PI / 4.0f * (float)offset;
            for (Spine spine : this.spine) {
                spine.middle.field_78796_g += -f1 * (float)Math.PI / 12.0f * (float)offset;
                spine.middle.field_78795_f += f1 * facePitch / 3.0f;
                spine.middle.field_78796_g += f1 * faceYaw / 3.0f;
            }
            drawingArm.getModel().field_78795_f += f * 0.2617994f - 1.0471976f;
            drawingArm.field_78796_g += (f * -0.9424778f - 0.62831855f) * (float)offset;
            drawingArm.field_78808_h += (f * -0.850848f + 1.0471976f) * (float)offset;
            drawingForearm.field_78795_f += 0.44879895f;
            holdingArm.getModel().field_78795_f += f * 1.8325956f - 2.6179938f;
            holdingArm.field_78796_g += (f * 0.9424778f + 0.62831855f) * (float)offset;
            holdingArm.field_78808_h += (f * 0.850848f - 1.0471976f) * (float)offset;
            holdingArm.getModel().field_78808_h += -f * (float)Math.PI / 8.0f * (float)offset;
            holdingforearm.field_78795_f += f * 0.10471976f - 0.62831855f;
            this.crossbow.middle1.field_78795_f += -f1s * (float)Math.PI / 16.0f;
            this.crossbow.side1.field_78795_f += -f1s * (float)Math.PI / 24.0f;
            this.crossbow.middle2.field_78795_f += f1s * (float)Math.PI / 16.0f;
            this.crossbow.side2.field_78795_f += f1s * (float)Math.PI / 24.0f;
            this.crossbow.rotateRope();
            this.crossbow.rope1.field_78795_f += f1s * (float)Math.PI / 6.0f;
            this.crossbow.rope2.field_78795_f += -f1s * (float)Math.PI / 6.0f;
        } else if (fullTick < 26) {
            this.head.getModel().field_78796_g += 0.7853982f * (float)offset;
            for (Spine spine : this.spine) {
                spine.middle.field_78796_g += -0.2617994f * (float)offset;
                spine.middle.field_78795_f += facePitch / 3.0f;
                spine.middle.field_78796_g += faceYaw / 3.0f;
            }
            drawingArm.getModel().field_78795_f += -1.0471976f;
            drawingArm.field_78796_g += -0.62831855f * (float)offset;
            drawingArm.field_78808_h += 1.0f * (float)offset;
            drawingForearm.field_78795_f += 0.44879895f;
            holdingArm.getModel().field_78795_f += -2.6179938f;
            holdingArm.field_78796_g += 0.62831855f * (float)offset;
            holdingArm.field_78808_h += -1.0471976f * (float)offset;
            holdingforearm.field_78795_f += -0.62831855f;
            float tick = MathHelper.func_76131_a((float)((float)(fullTick - 25) + this.partialTick), (float)0.0f, (float)1.0f);
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            this.crossbow.middle1.field_78795_f += -f * (float)Math.PI / 16.0f;
            this.crossbow.side1.field_78795_f += -f * (float)Math.PI / 24.0f;
            this.crossbow.middle2.field_78795_f += f * (float)Math.PI / 16.0f;
            this.crossbow.side2.field_78795_f += f * (float)Math.PI / 24.0f;
            this.crossbow.rotateRope();
            this.crossbow.rope1.field_78795_f += f * (float)Math.PI / 6.0f;
            this.crossbow.rope2.field_78795_f += -f * (float)Math.PI / 6.0f;
        } else if (fullTick < 30) {
            float tick = ((float)(fullTick - 26) + this.partialTick) / 4.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            this.head.getModel().field_78796_g += f * (float)Math.PI / 4.0f * (float)offset;
            for (Spine spine : this.spine) {
                spine.middle.field_78796_g += -f * (float)Math.PI / 12.0f * (float)offset;
                spine.middle.field_78795_f += f * facePitch / 3.0f;
                spine.middle.field_78796_g += f * faceYaw / 3.0f;
            }
            drawingArm.getModel().field_78795_f += -f * (float)Math.PI / 3.0f;
            drawingArm.field_78796_g += -f * (float)Math.PI / 5.0f * (float)offset;
            drawingArm.field_78808_h += f * (float)Math.PI / 3.0f * (float)offset;
            drawingForearm.field_78795_f += f * (float)Math.PI / 7.0f;
            holdingArm.getModel().field_78795_f += -f * (float)Math.PI / 1.2f;
            holdingArm.field_78796_g += f * (float)Math.PI / 5.0f * (float)offset;
            holdingArm.field_78808_h += -f * (float)Math.PI / 3.0f * (float)offset;
            holdingforearm.field_78795_f += -f * (float)Math.PI / 5.0f;
            this.crossbow.rotateRope();
        }
    }

    protected void animateMultiShoot(int fullTick, float facePitch, float faceYaw, boolean leftHanded) {
        if (fullTick < 10) {
            float tick = ((float)fullTick + this.partialTick) / 10.0f;
            float f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.skeleBase.field_78797_d += f * 3.5f;
            this.spine[0].middle.field_78795_f += f * (float)Math.PI / 6.0f;
            this.head.field_78795_f += -f * (float)Math.PI / 4.0f;
            this.arm1.field_78795_f += f * (float)Math.PI / 6.0f;
            this.arm1.field_78808_h += f * (float)Math.PI / 16.0f;
            this.arm2.field_78795_f += f * (float)Math.PI / 6.0f;
            this.arm2.field_78808_h += -f * (float)Math.PI / 16.0f;
            this.leg1.field_78795_f += -f * (float)Math.PI / 8.0f;
            this.leg2.field_78795_f += -f * (float)Math.PI / 8.0f;
            this.foreleg1.getModel().field_78795_f += f * (float)Math.PI / 4.0f;
            this.foreleg2.getModel().field_78795_f += f * (float)Math.PI / 4.0f;
            this.crossbow.rotateRope();
        } else {
            int offset;
            JointModelRenderer drawingArm = leftHanded ? this.arm2 : this.arm1;
            JointModelRenderer holdingArm = leftHanded ? this.arm1 : this.arm2;
            JointModelRenderer drawingForearm = leftHanded ? this.forearm2 : this.forearm1;
            JointModelRenderer holdingforearm = leftHanded ? this.forearm1 : this.forearm2;
            int n = offset = leftHanded ? -1 : 1;
            if (fullTick < 12) {
                float tick = ((float)(fullTick - 10) + this.partialTick) / 2.0f;
                float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
                float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
                this.skeleBase.field_78797_d += f * 3.5f;
                this.spine[0].middle.field_78795_f += f * (float)Math.PI / 6.0f;
                this.head.field_78795_f += -f * (float)Math.PI / 4.0f;
                drawingArm.field_78795_f += f * (float)Math.PI / 6.0f;
                drawingArm.field_78808_h += f * (float)Math.PI / 16.0f * (float)offset;
                holdingArm.field_78795_f += f * (float)Math.PI / 6.0f;
                holdingArm.field_78808_h += -f * (float)Math.PI / 16.0f * (float)offset;
                this.leg1.field_78795_f += -f * (float)Math.PI / 8.0f;
                this.leg2.field_78795_f += -f * (float)Math.PI / 8.0f;
                this.foreleg1.getModel().field_78795_f += f * (float)Math.PI / 4.0f;
                this.foreleg2.getModel().field_78795_f += f * (float)Math.PI / 4.0f;
                drawingArm.field_78808_h += -f1 * (float)Math.PI / 14.0f * (float)offset;
                holdingArm.field_78808_h += f1 * (float)Math.PI / 14.0f * (float)offset;
                this.leg1.field_78808_h += -f1 * (float)Math.PI / 24.0f;
                this.leg2.field_78808_h += f1 * (float)Math.PI / 24.0f;
                this.foreleg1.field_78808_h += f1 * (float)Math.PI / 64.0f;
                this.foreleg2.field_78808_h += -f1 * (float)Math.PI / 64.0f;
                this.crossbow.rotateRope();
            } else if (fullTick < 14) {
                drawingArm.field_78808_h += -0.22439948f * (float)offset;
                holdingArm.field_78808_h += 0.22439948f * (float)offset;
                this.leg1.field_78808_h += -0.1308997f;
                this.leg2.field_78808_h += 0.1308997f;
                this.foreleg1.field_78808_h += 0.049087387f;
                this.foreleg2.field_78808_h += -0.049087387f;
                this.crossbow.rotateRope();
            } else if (fullTick < 17) {
                float tick = ((float)(fullTick - 14) + this.partialTick) / 3.0f;
                float f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
                float f1 = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
                drawingArm.field_78808_h += -f1 * (float)Math.PI / 14.0f * (float)offset;
                holdingArm.field_78808_h += f1 * (float)Math.PI / 14.0f * (float)offset;
                this.leg1.field_78808_h += -f1 * (float)Math.PI / 24.0f;
                this.leg2.field_78808_h += f1 * (float)Math.PI / 24.0f;
                this.foreleg1.field_78808_h += f1 * (float)Math.PI / 64.0f;
                this.foreleg2.field_78808_h += -f1 * (float)Math.PI / 64.0f;
                drawingArm.getModel().field_78795_f += -f * (float)Math.PI / 4.0f;
                drawingArm.field_78796_g += -f * (float)Math.PI / 2.0f * (float)offset;
                drawingArm.field_78808_h += f * (float)Math.PI / 16.0f * (float)offset;
                drawingForearm.field_78795_f += f * (float)Math.PI / 7.0f;
                holdingArm.getModel().field_78795_f += -f * (float)Math.PI / 4.0f;
                holdingArm.field_78796_g += f * (float)Math.PI / 2.0f * (float)offset;
                holdingArm.field_78808_h += -f * (float)Math.PI / 16.0f * (float)offset;
                holdingArm.getModel().field_78808_h += -f * (float)Math.PI / 8.0f * (float)offset;
                holdingforearm.field_78795_f += -f * (float)Math.PI / 6.0f;
                this.crossbow.rotateRope();
            } else if (fullTick < 20) {
                float tick = ((float)(fullTick - 17) + this.partialTick) / 3.0f;
                float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
                float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
                float f1s = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f * 0.4f));
                this.head.getModel().field_78796_g += f1 * (float)Math.PI / 4.0f * (float)offset;
                for (Spine spine : this.spine) {
                    spine.middle.field_78796_g += -f1 * (float)Math.PI / 12.0f * (float)offset;
                    spine.middle.field_78795_f += f1 * facePitch / 3.0f;
                    spine.middle.field_78796_g += f1 * faceYaw / 3.0f;
                }
                drawingArm.getModel().field_78795_f += f * 0.2617994f - 1.0471976f;
                drawingArm.field_78796_g += (f * -0.9424778f - 0.62831855f) * (float)offset;
                drawingArm.field_78808_h += (f * -0.850848f + 1.0471976f) * (float)offset;
                drawingForearm.field_78795_f += 0.44879895f;
                holdingArm.getModel().field_78795_f += f * 1.8325956f - 2.6179938f;
                holdingArm.field_78796_g += (f * 0.9424778f + 0.62831855f) * (float)offset;
                holdingArm.field_78808_h += (f * 0.850848f - 1.0471976f) * (float)offset;
                holdingArm.getModel().field_78808_h += -f * (float)Math.PI / 8.0f * (float)offset;
                holdingforearm.field_78795_f += f * 0.10471976f - 0.62831855f;
                this.crossbow.middle1.field_78795_f += -f1s * (float)Math.PI / 16.0f;
                this.crossbow.side1.field_78795_f += -f1s * (float)Math.PI / 24.0f;
                this.crossbow.middle2.field_78795_f += f1s * (float)Math.PI / 16.0f;
                this.crossbow.side2.field_78795_f += f1s * (float)Math.PI / 24.0f;
                this.crossbow.rotateRope();
                this.crossbow.rope1.field_78795_f += f1s * (float)Math.PI / 6.0f;
                this.crossbow.rope2.field_78795_f += -f1s * (float)Math.PI / 6.0f;
            } else if (fullTick < 24) {
                this.head.getModel().field_78796_g += 0.7853982f * (float)offset;
                for (Spine spine : this.spine) {
                    spine.middle.field_78796_g += -0.2617994f * (float)offset;
                    spine.middle.field_78795_f += facePitch / 3.0f;
                    spine.middle.field_78796_g += faceYaw / 3.0f;
                }
                drawingArm.getModel().field_78795_f += -1.0471976f;
                drawingArm.field_78796_g += -0.62831855f * (float)offset;
                drawingArm.field_78808_h += 1.0f * (float)offset;
                drawingForearm.field_78795_f += 0.44879895f;
                holdingArm.getModel().field_78795_f += -2.6179938f;
                holdingArm.field_78796_g += 0.62831855f * (float)offset;
                holdingArm.field_78808_h += -1.0471976f * (float)offset;
                holdingforearm.field_78795_f += -0.62831855f;
                float tick = MathHelper.func_76131_a((float)((float)(fullTick - 25) + this.partialTick), (float)0.0f, (float)1.0f);
                float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
                this.crossbow.middle1.field_78795_f += -f * (float)Math.PI / 16.0f;
                this.crossbow.side1.field_78795_f += -f * (float)Math.PI / 24.0f;
                this.crossbow.middle2.field_78795_f += f * (float)Math.PI / 16.0f;
                this.crossbow.side2.field_78795_f += f * (float)Math.PI / 24.0f;
                this.crossbow.rotateRope();
                this.crossbow.rope1.field_78795_f += f * (float)Math.PI / 6.0f;
                this.crossbow.rope2.field_78795_f += -f * (float)Math.PI / 6.0f;
            } else if (fullTick < 28) {
                float tick = ((float)(fullTick - 24) + this.partialTick) / 4.0f;
                float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
                this.head.getModel().field_78796_g += f * (float)Math.PI / 4.0f * (float)offset;
                for (Spine spine : this.spine) {
                    spine.middle.field_78796_g += -f * (float)Math.PI / 12.0f * (float)offset;
                    spine.middle.field_78795_f += f * facePitch / 3.0f;
                    spine.middle.field_78796_g += f * faceYaw / 3.0f;
                }
                drawingArm.getModel().field_78795_f += -f * (float)Math.PI / 3.0f;
                drawingArm.field_78796_g += -f * (float)Math.PI / 5.0f * (float)offset;
                drawingArm.field_78808_h += f * (float)Math.PI / 3.0f * (float)offset;
                drawingForearm.field_78795_f += f * (float)Math.PI / 7.0f;
                holdingArm.getModel().field_78795_f += -f * (float)Math.PI / 1.2f;
                holdingArm.field_78796_g += f * (float)Math.PI / 5.0f * (float)offset;
                holdingArm.field_78808_h += -f * (float)Math.PI / 3.0f * (float)offset;
                holdingforearm.field_78795_f += -f * (float)Math.PI / 5.0f;
                this.crossbow.rotateRope();
            }
        }
    }

    protected void animateConstrict() {
        block6: {
            float f;
            float tick;
            int animTick;
            block7: {
                block5: {
                    this.animator.startPhase(5);
                    this.animator.rotate(this.waist, 0.1308997f, 0.0f, 0.0f);
                    for (animTick = 0; animTick < this.spine.length; ++animTick) {
                        tick = animTick == 0 ? 0.3926991f : (animTick == 2 ? -0.3926991f : 0.0f);
                        f = animTick == 1 ? 0.3926991f : 0.31415927f;
                        this.animator.rotate(this.spine[animTick].side1[0], tick, f, 0.0f);
                        this.animator.rotate(this.spine[animTick].side1[1], 0.0f, 0.15707964f, 0.0f);
                        this.animator.rotate(this.spine[animTick].side1[2], 0.0f, 0.2617994f, 0.0f);
                        this.animator.rotate(this.spine[animTick].side2[0], tick, -f, 0.0f);
                        this.animator.rotate(this.spine[animTick].side2[1], 0.0f, -0.15707964f, 0.0f);
                        this.animator.rotate(this.spine[animTick].side2[2], 0.0f, -0.2617994f, 0.0f);
                    }
                    this.animator.rotate(this.arm1, 0.0f, 0.0f, 0.8975979f);
                    this.animator.rotate(this.arm2, 0.0f, 0.0f, -0.8975979f);
                    this.animator.move(this.skeleBase, 0.0f, 1.0f, 0.0f);
                    this.animator.rotate(this.leg1, -0.44879895f, 0.0f, 0.0f);
                    this.animator.rotate(this.leg2, -0.44879895f, 0.0f, 0.0f);
                    this.animator.rotate(this.foreleg1.getModel(), 0.5235988f, 0.0f, 0.0f);
                    this.animator.rotate(this.foreleg2.getModel(), 0.5235988f, 0.0f, 0.0f);
                    this.animator.endPhase();
                    this.animator.setStationaryPhase(2);
                    this.animator.startPhase(1);
                    this.animator.rotate(this.neck, 0.19634955f, 0.0f, 0.0f);
                    this.animator.rotate(this.head, 0.15707964f, 0.0f, 0.0f);
                    this.animator.rotate(this.waist, 0.31415927f, 0.0f, 0.0f);
                    this.animator.rotate(this.spine[0].middle, 0.2617994f, 0.0f, 0.0f);
                    for (animTick = 0; animTick < this.spine.length; ++animTick) {
                        tick = animTick == 0 ? 0.1308997f : (animTick == 2 ? -0.1308997f : 0.0f);
                        f = animTick == 1 ? -0.17453294f : -0.22439948f;
                        this.animator.rotate(this.spine[animTick].side1[0], tick - 0.08f, f, 0.0f);
                        this.animator.rotate(this.spine[animTick].side1[1], 0.0f, 0.15707964f, 0.0f);
                        this.animator.rotate(this.spine[animTick].side1[2], 0.0f, 0.2617994f, 0.0f);
                        this.animator.rotate(this.spine[animTick].side2[0], tick + 0.08f, -f, 0.0f);
                        this.animator.rotate(this.spine[animTick].side2[1], 0.0f, -0.15707964f, 0.0f);
                        this.animator.rotate(this.spine[animTick].side2[2], 0.0f, -0.2617994f, 0.0f);
                    }
                    this.animator.move(this.skeleBase, 0.0f, 1.0f, 0.0f);
                    this.animator.rotate(this.leg1, -0.44879895f, 0.0f, 0.0f);
                    this.animator.rotate(this.leg2, -0.44879895f, 0.0f, 0.0f);
                    this.animator.rotate(this.foreleg1.getModel(), 0.5235988f, 0.0f, 0.0f);
                    this.animator.rotate(this.foreleg2.getModel(), 0.5235988f, 0.0f, 0.0f);
                    this.animator.endPhase();
                    this.animator.setStationaryPhase(4);
                    this.animator.resetPhase(8);
                    animTick = this.animator.getEntity().getAnimationTick();
                    if (animTick >= 5) break block5;
                    tick = ((float)animTick + this.partialTick) / 5.0f;
                    f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
                    for (Spine spine : this.spine) {
                        spine.side1[0].setScale(1.0f + f * 0.6f);
                        spine.side2[0].setScale(1.0f + f * 0.6f);
                    }
                    break block6;
                }
                if (animTick >= 12) break block7;
                for (Spine spine : this.spine) {
                    spine.side1[0].setScale(1.6f);
                    spine.side2[0].setScale(1.6f);
                }
                break block6;
            }
            if (animTick >= 20) break block6;
            tick = ((float)(animTick - 12) + this.partialTick) / 8.0f;
            f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            for (Spine spine : this.spine) {
                spine.side1[0].setScale(1.0f + f * 0.6f);
                spine.side2[0].setScale(1.0f + f * 0.6f);
            }
        }
    }

    public void translateHand(boolean leftHanded, MatrixStack matrixStackIn) {
        this.skeleBase.func_228307_a_(matrixStackIn);
        this.pelvis.func_228307_a_(matrixStackIn);
        this.waist.func_228307_a_(matrixStackIn);
        for (Spine spine : this.spine) {
            spine.middle.func_228307_a_(matrixStackIn);
        }
        if (leftHanded) {
            this.shoulder2.func_228307_a_(matrixStackIn);
            this.arm2.func_228307_a_(matrixStackIn);
            this.arm2.getModel().func_228307_a_(matrixStackIn);
            this.forearm2.func_228307_a_(matrixStackIn);
            this.forearm2.getModel().func_228307_a_(matrixStackIn);
        } else {
            this.shoulder1.func_228307_a_(matrixStackIn);
            this.arm1.func_228307_a_(matrixStackIn);
            this.arm1.getModel().func_228307_a_(matrixStackIn);
            this.forearm1.func_228307_a_(matrixStackIn);
            this.forearm1.getModel().func_228307_a_(matrixStackIn);
        }
    }

    public MutantCrossbowModel getCrossbow() {
        return this.crossbow;
    }

    public void setLivingAnimations(MutantSkeletonEntity entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.partialTick = partialTick;
    }

    static class Spine {
        public final ModelRenderer middle;
        public final ScalableModelRenderer[] side1;
        public final ScalableModelRenderer[] side2;

        public Spine(Model model) {
            this(model, false);
        }

        public Spine(Model model, boolean skeletonPart) {
            this.middle = new ModelRenderer(model, 50, 0);
            this.middle.func_228301_a_(-2.5f, -4.0f, -2.0f, 5.0f, 4.0f, 4.0f, 0.5f);
            this.side1 = new ScalableModelRenderer[3];
            this.side2 = new ScalableModelRenderer[3];
            this.side1[0] = new ScalableModelRenderer(model, 32, 12);
            this.side1[0].func_228301_a_(skeletonPart ? 0.0f : -6.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, 0.25f);
            if (!skeletonPart) {
                this.side1[0].func_78793_a(-3.0f, -1.0f, 1.75f);
            }
            this.middle.func_78792_a((ModelRenderer)this.side1[0]);
            this.side2[0] = new ScalableModelRenderer(model, 32, 12);
            this.side2[0].field_78809_i = true;
            this.side2[0].func_228301_a_(skeletonPart ? -6.0f : 0.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, 0.25f);
            if (!skeletonPart) {
                this.side2[0].func_78793_a(3.0f, -1.0f, 1.75f);
            }
            this.middle.func_78792_a((ModelRenderer)this.side2[0]);
            this.side1[1] = new ScalableModelRenderer(model, 32, 12);
            this.side1[1].field_78809_i = true;
            this.side1[1].func_228301_a_(-6.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, 0.2f);
            this.side1[1].func_78793_a(skeletonPart ? -0.5f : -6.5f, 0.0f, 0.0f);
            this.side1[0].func_78792_a(this.side1[1]);
            this.side2[1] = new ScalableModelRenderer(model, 32, 12);
            this.side2[1].func_228301_a_(0.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, 0.2f);
            this.side2[1].func_78793_a(skeletonPart ? 0.5f : 6.5f, 0.0f, 0.0f);
            this.side2[0].func_78792_a(this.side2[1]);
            this.side1[2] = new ScalableModelRenderer(model, 32, 12);
            this.side1[2].func_228301_a_(-6.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, 0.15f);
            this.side1[2].func_78793_a(-6.4f, 0.0f, 0.0f);
            this.side1[1].func_78792_a(this.side1[2]);
            this.side2[2] = new ScalableModelRenderer(model, 32, 12);
            this.side2[2].field_78809_i = true;
            this.side2[2].func_228301_a_(0.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, 0.15f);
            this.side2[2].func_78793_a(6.4f, 0.0f, 0.0f);
            this.side2[1].func_78792_a(this.side2[2]);
        }

        public void setAngles(float PI, boolean middleSpine) {
            Animator.resetAngles(this.middle);
            Animator.resetAngles(this.side1);
            Animator.resetAngles(this.side2);
            this.middle.field_78795_f = PI / 18.0f;
            this.side1[0].field_78796_g = -PI / 4.5f;
            this.side2[0].field_78796_g = PI / 4.5f;
            this.side1[1].field_78796_g = -PI / 3.0f;
            this.side2[1].field_78796_g = PI / 3.0f;
            this.side1[2].field_78796_g = -PI / 3.5f;
            this.side2[2].field_78796_g = PI / 3.5f;
            if (middleSpine) {
                for (int i = 0; i < this.side1.length; ++i) {
                    this.side1[i].field_78796_g *= 0.98f;
                    this.side2[i].field_78796_g *= 0.98f;
                }
            }
            this.side1[0].setScale(1.0f);
            this.side2[0].setScale(1.0f);
        }

        public void animate(float breatheAnim) {
            this.side1[1].field_78796_g += breatheAnim * 0.02f;
            this.side2[1].field_78796_g -= breatheAnim * 0.02f;
        }
    }
}

