/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.item;

import chumbanotz.mutantbeasts.util.MutatedExplosion;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class CreeperShardItem
extends Item
implements IVanishable {
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public CreeperShardItem(Item.Properties properties) {
        super(properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 2.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.5, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return !player.func_184812_l_();
    }

    public boolean func_77636_d(ItemStack stack) {
        return super.func_77636_d(stack) || stack.func_77952_i() == 0;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        PlayerEntity player = (PlayerEntity)attacker;
        int damage = stack.func_77952_i();
        if (damage > 0) {
            stack.func_196085_b(damage - 1);
            if (!player.func_184812_l_() && player.func_70681_au().nextInt(4) == 0) {
                player.func_195064_c(new EffectInstance(Effects.field_76436_u, 80 + player.func_70681_au().nextInt(40)));
            }
        }
        target.func_233627_a_(0.9f, player.func_226277_ct_() - target.func_226277_ct_(), player.func_226281_cx_() - target.func_226281_cx_());
        player.field_70170_p.func_184133_a(null, target.func_233580_cy_(), SoundEvents.field_187539_bB, SoundCategory.NEUTRAL, 0.3f, 0.8f + player.func_70681_au().nextFloat() * 0.4f);
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        int maxDmg = stack.func_77958_k();
        int dmg = stack.func_77952_i();
        if (!worldIn.field_72995_K) {
            float damage = 5.0f * (float)(maxDmg - dmg) / 32.0f;
            if (dmg == 0) {
                damage += 2.0f;
            }
            MutatedExplosion.create(worldIn, (Entity)playerIn, playerIn.func_226277_ct_(), playerIn.func_226278_cu_() + 1.0, playerIn.func_226281_cx_(), damage, false, playerIn.func_175142_cm() ? Explosion.Mode.DESTROY : Explosion.Mode.NONE);
        }
        if (!playerIn.field_71075_bZ.field_75098_d) {
            stack.func_196085_b(maxDmg);
        }
        playerIn.func_184811_cZ().func_185145_a((Item)this, (maxDmg - dmg) * 2);
        playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        return ActionResult.func_226248_a_((Object)stack);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        return slot == EquipmentSlotType.MAINHAND ? this.attributeModifiers : super.getAttributeModifiers(slot, stack);
    }

    public boolean func_234685_a_(DamageSource damageSource) {
        return !damageSource.func_94541_c();
    }
}

