/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.item;

import chumbanotz.mutantbeasts.util.SeismicWave;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class HulkHammerItem
extends Item
implements IVanishable {
    public static final Map<UUID, List<SeismicWave>> WAVES = new HashMap<UUID, List<SeismicWave>>();
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public HulkHammerItem(Item.Properties properties) {
        super(properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 8.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -3.0, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    public EquipmentSlotType getEquipmentSlot(ItemStack stack) {
        return EquipmentSlotType.MAINHAND;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, e -> e.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            stack.func_222118_a(2, entityLiving, e -> e.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        PlayerEntity playerEntity = context.func_195999_j();
        ItemStack itemStack = context.func_195996_i();
        if (context.func_196000_l() != Direction.UP) {
            return ActionResultType.PASS;
        }
        if (!world.field_72995_K) {
            ArrayList<SeismicWave> list = new ArrayList<SeismicWave>();
            Vector3d vec = Vector3d.func_189986_a((float)0.0f, (float)playerEntity.field_70177_z);
            int x = MathHelper.func_76128_c((double)(playerEntity.func_226277_ct_() + vec.field_72450_a * 1.5));
            int y = MathHelper.func_76128_c((double)playerEntity.func_174813_aQ().field_72338_b);
            int z = MathHelper.func_76128_c((double)(playerEntity.func_226281_cx_() + vec.field_72449_c * 1.5));
            int x1 = MathHelper.func_76128_c((double)(playerEntity.func_226277_ct_() + vec.field_72450_a * 8.0));
            int z1 = MathHelper.func_76128_c((double)(playerEntity.func_226281_cx_() + vec.field_72449_c * 8.0));
            SeismicWave.createWaves(world, list, x, z, x1, z1, y);
            HulkHammerItem.addWave(playerEntity.func_110124_au(), list);
        }
        world.func_184133_a(playerEntity, context.func_195995_a(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 0.8f, 0.8f + playerEntity.func_70681_au().nextFloat() * 0.4f);
        playerEntity.func_184811_cZ().func_185145_a((Item)this, 25);
        playerEntity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        itemStack.func_222118_a(1, (LivingEntity)playerEntity, e -> e.func_213334_d(context.func_221531_n()));
        return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        return slot == EquipmentSlotType.MAINHAND ? this.attributeModifiers : super.getAttributeModifiers(slot, stack);
    }

    public static void addWave(UUID name, List<SeismicWave> list) {
        List<SeismicWave> waves = null;
        Iterator<List<SeismicWave>> iterator = WAVES.values().iterator();
        while (iterator.hasNext()) {
            List<SeismicWave> waves1;
            waves = waves1 = iterator.next();
        }
        if (waves == null) {
            WAVES.put(name, list);
        } else {
            waves.addAll(list);
            WAVES.put(name, waves);
        }
    }
}

