/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.packet;

import chumbanotz.mutantbeasts.client.animationapi.Animation;
import chumbanotz.mutantbeasts.client.animationapi.IAnimatedEntity;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class AnimationPacket {
    private final int entityId;
    private final int index;

    public AnimationPacket(int entityId, int index) {
        this.entityId = entityId;
        this.index = index;
    }

    void encode(PacketBuffer buffer) {
        buffer.func_150787_b(this.entityId);
        buffer.func_150787_b(this.index);
    }

    AnimationPacket(PacketBuffer buffer) {
        this.entityId = buffer.func_150792_a();
        this.index = buffer.func_150792_a();
    }

    void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Optional optional = (Optional)LogicalSidedProvider.CLIENTWORLD.get(((NetworkEvent.Context)context.get()).getDirection().getReceptionSide());
            optional.ifPresent(world -> {
                Entity entity = world.func_73045_a(this.entityId);
                if (entity instanceof IAnimatedEntity) {
                    IAnimatedEntity animatedEntity = (IAnimatedEntity)entity;
                    if (this.index == -1) {
                        animatedEntity.setAnimation(Animation.NONE);
                    } else {
                        animatedEntity.setAnimation(animatedEntity.getAnimations()[this.index]);
                    }
                    animatedEntity.setAnimationTick(0);
                }
            });
        });
        context.get().setPacketHandled(true);
    }
}

