/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.pathfinding;

import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.FluidState;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class MBWalkNodeProcessor
extends WalkNodeProcessor {
    protected PathNodeType func_215744_a(IBlockReader blockReader, boolean canOpenDoors, boolean canEnterDoors, BlockPos blockPos, PathNodeType pathNodeType) {
        if (pathNodeType == PathNodeType.DOOR_WOOD_CLOSED && canOpenDoors && canEnterDoors) {
            pathNodeType = PathNodeType.WALKABLE;
        }
        if (pathNodeType == PathNodeType.DOOR_OPEN && !canEnterDoors) {
            pathNodeType = PathNodeType.BLOCKED;
        }
        if (pathNodeType == PathNodeType.LEAVES) {
            pathNodeType = PathNodeType.BLOCKED;
        }
        return pathNodeType;
    }

    public PathNodeType func_186330_a(IBlockReader blockaccessIn, int x, int y, int z) {
        return MBWalkNodeProcessor.func_237231_a_(blockaccessIn, new BlockPos.Mutable(x, y, z));
    }

    public static PathNodeType func_237231_a_(IBlockReader blockReader, BlockPos.Mutable mutable) {
        int i = mutable.func_177958_n();
        int j = mutable.func_177956_o();
        int k = mutable.func_177952_p();
        PathNodeType rawNode = MBWalkNodeProcessor.func_237238_b_(blockReader, (BlockPos)mutable);
        if (rawNode == PathNodeType.OPEN && j >= 1) {
            PathNodeType nodeBelow = MBWalkNodeProcessor.func_237238_b_(blockReader, (BlockPos)mutable.func_181079_c(i, j - 1, k));
            rawNode = nodeBelow != PathNodeType.WALKABLE && nodeBelow != PathNodeType.OPEN && nodeBelow != PathNodeType.WATER && nodeBelow != PathNodeType.LAVA ? PathNodeType.WALKABLE : PathNodeType.OPEN;
            switch (nodeBelow) {
                case DAMAGE_FIRE: 
                case DAMAGE_CACTUS: 
                case DAMAGE_OTHER: 
                case DANGER_OTHER: 
                case STICKY_HONEY: {
                    rawNode = nodeBelow;
                    break;
                }
            }
        }
        if (rawNode == PathNodeType.WALKABLE) {
            rawNode = MBWalkNodeProcessor.func_237232_a_(blockReader, mutable.func_181079_c(i, j, k), rawNode);
        }
        return rawNode;
    }

    public static PathNodeType func_237232_a_(IBlockReader blockReader, BlockPos.Mutable mutable, PathNodeType pathNodeType) {
        int x = mutable.func_177958_n();
        int y = mutable.func_177956_o();
        int z = mutable.func_177952_p();
        for (int extraX = -1; extraX <= 1; ++extraX) {
            for (int extraY = -1; extraY <= 1; ++extraY) {
                for (int extraZ = -1; extraZ <= 1; ++extraZ) {
                    if (extraX == 0 && extraZ == 0) continue;
                    mutable.func_181079_c(x + extraX, y + extraY, z + extraZ);
                    PathNodeType rawNode = MBWalkNodeProcessor.func_237238_b_(blockReader, (BlockPos)mutable);
                    switch (rawNode) {
                        case DAMAGE_CACTUS: {
                            return PathNodeType.DANGER_CACTUS;
                        }
                        case DAMAGE_OTHER: 
                        case DANGER_OTHER: {
                            return PathNodeType.DANGER_OTHER;
                        }
                        case DAMAGE_FIRE: {
                            return PathNodeType.DANGER_FIRE;
                        }
                        case WATER: {
                            return PathNodeType.WATER_BORDER;
                        }
                        case LAVA: {
                            return rawNode;
                        }
                    }
                }
            }
        }
        return pathNodeType;
    }

    protected static PathNodeType func_237238_b_(IBlockReader blockReader, BlockPos blockPos) {
        BlockState blockstate = blockReader.func_180495_p(blockPos);
        PathNodeType type = blockstate.getAiPathNodeType(blockReader, blockPos);
        if (type != null) {
            return type;
        }
        Block block = blockstate.func_177230_c();
        if (block.isAir(blockstate, blockReader, blockPos)) {
            return PathNodeType.OPEN;
        }
        if (!blockstate.func_235714_a_((ITag)BlockTags.field_212185_E) && !blockstate.func_203425_a(Blocks.field_196651_dG)) {
            if (blockstate.func_203425_a(Blocks.field_150434_aF)) {
                return PathNodeType.DAMAGE_CACTUS;
            }
            if (blockstate.func_203425_a(Blocks.field_222434_lW) || blockstate.func_235714_a_((ITag)BlockTags.field_226154_ad_)) {
                return PathNodeType.DAMAGE_OTHER;
            }
            if (block.func_226892_n_() < 1.0f) {
                return PathNodeType.STICKY_HONEY;
            }
            if (block.func_226891_m_() < 1.0f || blockstate.func_203425_a(Blocks.field_196553_aF) || blockstate.func_235714_a_((ITag)BlockTags.field_232885_k_) || blockstate.func_203425_a(Blocks.field_150473_bD) || blockstate.func_203425_a(Blocks.field_222388_bz)) {
                return PathNodeType.DANGER_OTHER;
            }
            if (blockstate.func_203425_a(Blocks.field_150375_by)) {
                return PathNodeType.COCOA;
            }
            FluidState fluidstate = blockReader.func_204610_c(blockPos);
            if (fluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) {
                return PathNodeType.WATER;
            }
            if (fluidstate.func_206884_a((ITag)FluidTags.field_206960_b)) {
                return PathNodeType.LAVA;
            }
            if (blockstate.func_235714_a_((ITag)BlockTags.field_232872_am_) || blockstate.func_203425_a(Blocks.field_150353_l) || blockstate.func_203425_a(Blocks.field_196814_hQ) || CampfireBlock.func_226915_i_((BlockState)blockstate)) {
                return PathNodeType.DAMAGE_FIRE;
            }
            if (DoorBlock.func_235492_h_((BlockState)blockstate) && !((Boolean)blockstate.func_177229_b((Property)DoorBlock.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_WOOD_CLOSED;
            }
            if (block instanceof DoorBlock && blockstate.func_185904_a() == Material.field_151573_f && !((Boolean)blockstate.func_177229_b((Property)DoorBlock.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_IRON_CLOSED;
            }
            if (block instanceof DoorBlock && ((Boolean)blockstate.func_177229_b((Property)DoorBlock.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_OPEN;
            }
            if (block instanceof AbstractRailBlock) {
                return PathNodeType.RAIL;
            }
            if (block instanceof LeavesBlock) {
                return PathNodeType.LEAVES;
            }
            if (!(block.func_203417_a((ITag)BlockTags.field_219748_G) || block.func_203417_a((ITag)BlockTags.field_219757_z) || block instanceof FenceGateBlock && !((Boolean)blockstate.func_177229_b((Property)FenceGateBlock.field_176466_a)).booleanValue())) {
                return !blockstate.func_196957_g(blockReader, blockPos, PathType.LAND) ? PathNodeType.BLOCKED : PathNodeType.OPEN;
            }
            return PathNodeType.FENCE;
        }
        return PathNodeType.TRAPDOOR;
    }
}

