/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.util;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.packet.MBPacketHandler;
import chumbanotz.mutantbeasts.packet.SpawnParticlePacket;
import chumbanotz.mutantbeasts.particles.MBParticleTypes;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityMetadataPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.PacketDistributor;

public class EntityUtil {
    private static final Field STUN_TICK = ObfuscationReflectionHelper.findField(RavagerEntity.class, (String)"field_213692_bA");
    private static final Method GET_SKULL_DROP = ObfuscationReflectionHelper.findMethod(ZombieEntity.class, (String)"func_190732_dj", (Class[])new Class[0]);

    public static float getHeadAngle(LivingEntity livingEntity, double x, double z) {
        return MathHelper.func_203301_d((float)((float)(Math.atan2(z, x) * 180.0 / Math.PI) + 90.0f), (float)livingEntity.field_70759_as);
    }

    public static void spawnLingeringCloud(LivingEntity livingEntity) {
        Collection collection = livingEntity.func_70651_bq();
        if (!collection.isEmpty()) {
            AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(livingEntity.field_70170_p, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_());
            areaeffectcloudentity.func_184483_a(1.5f);
            areaeffectcloudentity.func_184495_b(-0.5f);
            areaeffectcloudentity.func_184485_d(10);
            areaeffectcloudentity.func_184486_b(areaeffectcloudentity.func_184489_o() / 2);
            areaeffectcloudentity.func_184487_c(-areaeffectcloudentity.func_184490_j() / (float)areaeffectcloudentity.func_184489_o());
            for (EffectInstance effectinstance : collection) {
                areaeffectcloudentity.func_184496_a(new EffectInstance(effectinstance));
            }
            livingEntity.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
        }
    }

    public static void stunRavager(LivingEntity livingEntity) {
        if (livingEntity instanceof RavagerEntity) {
            try {
                if (STUN_TICK.getInt(livingEntity) == 0) {
                    STUN_TICK.setInt(livingEntity, 40);
                    livingEntity.func_184185_a(SoundEvents.field_219649_fi, 1.0f, 1.0f);
                    livingEntity.field_70170_p.func_72960_a((Entity)livingEntity, (byte)39);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                MutantBeasts.LOGGER.warn("Failed to access ravager stunTick", (Throwable)e);
            }
        }
    }

    public static void disableShield(LivingEntity livingEntity, int ticks) {
        if (livingEntity instanceof PlayerEntity && livingEntity.func_184585_cz()) {
            ((PlayerEntity)livingEntity).func_184811_cZ().func_185145_a(livingEntity.func_184607_cu().func_77973_b(), ticks);
            livingEntity.func_184602_cy();
            livingEntity.field_70170_p.func_72960_a((Entity)livingEntity, (byte)30);
        }
    }

    public static void sendPlayerVelocityPacket(Entity entity) {
        if (entity instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)entity).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(entity));
        }
    }

    public static void sendMetadataPacket(Entity entity) {
        if (entity.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217218_b(entity, (IPacket)new SEntityMetadataPacket(entity.func_145782_y(), entity.func_184212_Q(), false));
        }
    }

    public static boolean isFeline(LivingEntity livingEntity) {
        return livingEntity instanceof OcelotEntity || livingEntity instanceof CatEntity;
    }

    public static boolean shouldAttackEntity(TameableEntity attacker, LivingEntity target, LivingEntity owner, boolean canTargetCreepers) {
        if (owner instanceof PlayerEntity) {
            if (target instanceof CreeperEntity) {
                return canTargetCreepers;
            }
            if (target instanceof TameableEntity) {
                return !((TameableEntity)target).func_152114_e(owner);
            }
            if (target instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
                return false;
            }
            if (target instanceof GolemEntity && !(target instanceof IMob)) {
                return false;
            }
            return !(target instanceof AbstractHorseEntity) || !((AbstractHorseEntity)target).func_110248_bS();
        }
        return true;
    }

    public static <T extends MobEntity> T convertMobWithNBT(LivingEntity mobToConvert, EntityType<T> newEntityType, boolean dropInventory) {
        MobEntity newMob = (MobEntity)newEntityType.func_200721_a(mobToConvert.field_70170_p);
        CompoundNBT copiedNBT = mobToConvert.func_189511_e(new CompoundNBT());
        copiedNBT.func_186854_a("UUID", newMob.func_110124_au());
        copiedNBT.func_218657_a("Attributes", (INBT)newMob.func_233645_dx_().func_233794_c_());
        copiedNBT.func_74776_a("Health", newMob.func_110143_aJ());
        if (mobToConvert.func_96124_cp() != null) {
            copiedNBT.func_74778_a("Team", mobToConvert.func_96124_cp().func_96661_b());
        }
        if (copiedNBT.func_150297_b("ActiveEffects", 9)) {
            ListNBT activeEffects = copiedNBT.func_150295_c("ActiveEffects", 10);
            for (int i = 0; i < activeEffects.size(); ++i) {
                CompoundNBT compoundnbt = activeEffects.func_150305_b(i);
                EffectInstance effectInstance = EffectInstance.func_82722_b((CompoundNBT)compoundnbt);
                if (effectInstance == null || newMob.func_70687_e(effectInstance)) continue;
                activeEffects.remove(i);
                --i;
            }
        }
        copiedNBT.func_74757_a("CanPickUpLoot", !dropInventory && copiedNBT.func_74767_n("CanPickUpLoot"));
        if (dropInventory && mobToConvert.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            BlockState blockState;
            ItemStack itemStack;
            if (copiedNBT.func_150297_b("ArmorItems", 9)) {
                ListNBT armorItems = copiedNBT.func_150295_c("ArmorItems", 10);
                ListNBT armorDropChances = copiedNBT.func_150295_c("ArmorDropChances", 5);
                for (int i = 0; i < armorItems.size(); ++i) {
                    itemStack = ItemStack.func_199557_a((CompoundNBT)armorItems.func_150305_b(i));
                    if (itemStack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)itemStack) || !(armorDropChances.func_150308_e(i) > 1.0f)) continue;
                    mobToConvert.func_199701_a_(itemStack);
                }
                armorItems.clear();
                armorDropChances.clear();
            }
            if (copiedNBT.func_150297_b("HandItems", 9)) {
                ListNBT handItems = copiedNBT.func_150295_c("HandItems", 10);
                ListNBT handDropChances = copiedNBT.func_150295_c("HandDropChances", 5);
                for (int i = 0; i < handItems.size(); ++i) {
                    itemStack = ItemStack.func_199557_a((CompoundNBT)handItems.func_150305_b(i));
                    if (itemStack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)itemStack) || !(handDropChances.func_150308_e(i) > 1.0f)) continue;
                    mobToConvert.func_199701_a_(itemStack);
                }
                handItems.clear();
                handDropChances.clear();
            }
            if (mobToConvert.func_200600_R() == EntityType.field_200803_q && copiedNBT.func_150297_b("carriedBlockState", 10) && !(blockState = NBTUtil.func_190008_d((CompoundNBT)copiedNBT.func_74775_l("carriedBlockState"))).func_196958_f()) {
                mobToConvert.func_199703_a((IItemProvider)blockState.func_177230_c());
            }
        }
        newMob.func_70020_e(copiedNBT);
        mobToConvert.field_70170_p.func_217376_c((Entity)newMob);
        mobToConvert.func_70106_y();
        return (T)newMob;
    }

    public static void spawnEndersoulParticles(Entity entity, Random random, int amount, float speed) {
        for (int i = 0; i < amount; ++i) {
            float f = (random.nextFloat() - 0.5f) * speed;
            float f1 = (random.nextFloat() - 0.5f) * speed;
            float f2 = (random.nextFloat() - 0.5f) * speed;
            double tempX = entity.func_226277_ct_() + (double)((random.nextFloat() - 0.5f) * entity.func_213311_cf());
            double tempY = entity.func_226278_cu_() + (double)((random.nextFloat() - 0.5f) * entity.func_213302_cg()) + 0.5;
            double tempZ = entity.func_226281_cx_() + (double)((random.nextFloat() - 0.5f) * entity.func_213311_cf());
            entity.field_70170_p.func_195594_a((IParticleData)MBParticleTypes.ENDERSOUL, tempX, tempY, tempZ, (double)f, (double)f1, (double)f2);
        }
    }

    public static void sendParticlePacket(Entity entity, IParticleData particleData, int amount) {
        double x = entity.func_226277_ct_();
        double y = entity.func_226278_cu_();
        double z = entity.func_226281_cx_();
        MBPacketHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(x, y, z, 1024.0, entity.field_70170_p.func_234923_W_())), (Object)new SpawnParticlePacket(particleData, x, y, z, entity.func_213311_cf(), entity.func_213302_cg(), entity.func_213311_cf(), amount));
    }

    public static Vector3d getDirVector(float rotation, float scale) {
        float rad = rotation * ((float)Math.PI / 180);
        return new Vector3d((double)(-MathHelper.func_76126_a((float)rad) * scale), 0.0, (double)(MathHelper.func_76134_b((float)rad) * scale));
    }

    public static boolean teleportTo(MobEntity mob, double x, double y, double z) {
        BlockPos.Mutable pos = new BlockPos.Mutable(x, y, z);
        boolean success = false;
        if (mob.field_70170_p.func_195588_v((BlockPos)pos)) {
            do {
                pos.func_189536_c(Direction.DOWN);
            } while (pos.func_177956_o() > 0 && !mob.field_70170_p.func_180495_p((BlockPos)pos).func_185904_a().func_76230_c());
            pos.func_189536_c(Direction.UP);
            AxisAlignedBB bb = mob.func_213305_a(Pose.STANDING).func_242285_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            if (mob.field_70170_p.func_226665_a__((Entity)mob, bb) && !mob.field_70170_p.func_72953_d(bb)) {
                success = true;
            }
        }
        if (!success) {
            return false;
        }
        mob.func_70661_as().func_75499_g();
        mob.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        return true;
    }

    public static void divertAttackers(MobEntity targetedMob, LivingEntity newTarget) {
        for (MobEntity attacker : targetedMob.field_70170_p.func_217357_a(MobEntity.class, targetedMob.func_174813_aQ().func_72314_b(16.0, 10.0, 16.0))) {
            if (attacker == targetedMob || attacker.func_70638_az() != targetedMob) continue;
            attacker.func_70624_b(newTarget);
        }
    }

    public static double getKnockResistanceFactor(Entity entity) {
        return entity instanceof LivingEntity ? 1.0 - ((LivingEntity)entity).func_233637_b_(Attributes.field_233820_c_) : 1.0;
    }

    public static ItemStack getSkullDrop(LivingEntity livingEntity) {
        if (livingEntity instanceof ZombieEntity) {
            try {
                return (ItemStack)GET_SKULL_DROP.invoke((Object)livingEntity, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                MutantBeasts.LOGGER.warn("Failed to access skull drop from zombie", (Throwable)e);
                return livingEntity.func_200600_R() == EntityType.field_200725_aD ? new ItemStack((IItemProvider)Items.field_196186_dz) : ItemStack.field_190927_a;
            }
        }
        if (livingEntity.func_200600_R() == EntityType.field_200797_k) {
            return new ItemStack((IItemProvider)Items.field_196185_dy);
        }
        if (livingEntity.func_200600_R() == EntityType.field_200741_ag) {
            return new ItemStack((IItemProvider)Items.field_196182_dv);
        }
        if (livingEntity.func_200600_R() == EntityType.field_200722_aA) {
            return new ItemStack((IItemProvider)Items.field_196183_dw);
        }
        return ItemStack.field_190927_a;
    }
}

