/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.util;

import chumbanotz.mutantbeasts.entity.SkullSpiritEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantCreeperEntity;
import chumbanotz.mutantbeasts.entity.projectile.ChemicalXEntity;
import chumbanotz.mutantbeasts.util.EntityUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SExplosionPacket;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.EntityExplosionContext;
import net.minecraft.world.Explosion;
import net.minecraft.world.ExplosionContext;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class MutatedExplosion
extends Explosion {
    private final World world;
    private final float size;

    private MutatedExplosion(World worldIn, @Nullable Entity exploderIn, double xIn, double yIn, double zIn, float sizeIn, boolean causesFireIn, Explosion.Mode modeIn) {
        super(worldIn, exploderIn, null, null, xIn, yIn, zIn, sizeIn, causesFireIn, modeIn);
        this.world = worldIn;
        this.size = sizeIn;
    }

    public void func_77278_a() {
        double z;
        double y;
        double x;
        if (this.size <= 0.0f) {
            return;
        }
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        ExplosionContext explosionContext = this.getExploder() == null ? new ExplosionContext() : new EntityExplosionContext(this.getExploder());
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    x = this.getPosition().field_72450_a;
                    y = this.getPosition().field_72448_b;
                    z = this.getPosition().field_72449_c;
                    float attenuation = 0.3f;
                    for (float intensity = this.size * (0.7f + this.world.field_73012_v.nextFloat() * 0.6f); intensity > 0.0f; intensity -= 0.22500001f) {
                        BlockPos blockpos = new BlockPos(x, y, z);
                        BlockState blockstate = this.world.func_180495_p(blockpos);
                        Optional optional = explosionContext.func_230312_a_((Explosion)this, (IBlockReader)this.world, blockpos, blockstate, Fluids.field_204541_a.func_207188_f());
                        if (optional.isPresent()) {
                            intensity -= (((Float)optional.get()).floatValue() + attenuation) * attenuation;
                        }
                        if (intensity > 0.0f && explosionContext.func_230311_a_((Explosion)this, (IBlockReader)this.world, blockpos, blockstate, intensity)) {
                            set.add(blockpos);
                        }
                        x += d0 * (double)attenuation;
                        y += d1 * (double)attenuation;
                        z += d2 * (double)attenuation;
                    }
                }
            }
        }
        this.func_180343_e().addAll(set);
        float diameter = this.size * 2.0f;
        int minX = MathHelper.func_76128_c((double)(this.getPosition().field_72450_a - (double)diameter - 1.0));
        int maxX = MathHelper.func_76128_c((double)(this.getPosition().field_72450_a + (double)diameter + 1.0));
        int minY = MathHelper.func_76128_c((double)(this.getPosition().field_72448_b - (double)diameter - 1.0));
        int maxY = MathHelper.func_76128_c((double)(this.getPosition().field_72448_b + (double)diameter + 1.0));
        int minZ = MathHelper.func_76128_c((double)(this.getPosition().field_72449_c - (double)diameter - 1.0));
        int maxZ = MathHelper.func_76128_c((double)(this.getPosition().field_72449_c + (double)diameter + 1.0));
        List list = this.world.func_175674_a(this.getExploder(), new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ), entity -> {
            if (entity.func_180427_aV()) {
                return false;
            }
            if (this.getExploder() instanceof SkullSpiritEntity) {
                SkullSpiritEntity skullSpirit = (SkullSpiritEntity)this.getExploder();
                if (entity == skullSpirit.getTarget()) {
                    return !skullSpirit.isAttached();
                }
                return !(entity instanceof LivingEntity) || ChemicalXEntity.IS_APPLICABLE.test((LivingEntity)entity);
            }
            return true;
        });
        ForgeEventFactory.onExplosionDetonate((World)this.world, (Explosion)this, (List)list, (double)diameter);
        for (Entity entity2 : list) {
            PlayerEntity playerentity;
            double d0;
            double distance = MathHelper.func_76133_a((double)entity2.func_195048_a(this.getPosition())) / diameter;
            if (!(distance <= 1.0) || (d0 = (double)MathHelper.func_76133_a((double)((x = entity2.func_226277_ct_() - this.getPosition().field_72450_a) * x + (y = entity2.func_226280_cw_() - this.getPosition().field_72448_b) * y + (z = entity2.func_226281_cx_() - this.getPosition().field_72449_c) * z))) == 0.0) continue;
            x /= d0;
            y /= d0;
            z /= d0;
            double impact = (1.0 - distance) * (double)MutatedExplosion.func_222259_a((Vector3d)this.getPosition(), (Entity)entity2);
            float damage = (int)((impact * impact + impact) / 2.0 * 6.0 * (double)diameter + 1.0);
            if (!entity2.func_70097_a(this.func_199591_b(), damage) && this.getExploder() instanceof MutantCreeperEntity && entity2 instanceof PlayerEntity && ((PlayerEntity)entity2).func_184585_cz()) {
                MutantCreeperEntity mutantCreeper = (MutantCreeperEntity)this.getExploder();
                PlayerEntity player = (PlayerEntity)entity2;
                if (mutantCreeper.isJumpAttacking()) {
                    EntityUtil.disableShield((LivingEntity)player, mutantCreeper.isCharged() ? 200 : 100);
                    entity2.func_70097_a(this.func_199591_b(), damage * 0.5f);
                } else {
                    player.func_184607_cu().func_222118_a((int)damage * 2, (LivingEntity)player, e -> e.func_213334_d(player.func_184600_cs()));
                    entity2.func_70097_a(this.func_199591_b(), damage * 0.5f);
                }
            }
            double exposure = impact;
            if (entity2 instanceof LivingEntity) {
                exposure = ProtectionEnchantment.func_92092_a((LivingEntity)((LivingEntity)entity2), (double)impact);
            }
            if (!(entity2 instanceof MutantCreeperEntity)) {
                entity2.func_213317_d(entity2.func_213322_ci().func_72441_c(x * exposure, y * exposure, z * exposure));
            }
            if (!(entity2 instanceof PlayerEntity) || (playerentity = (PlayerEntity)entity2).func_175149_v() || playerentity.func_184812_l_() && playerentity.field_71075_bZ.field_75100_b) continue;
            this.func_77277_b().put(playerentity, new Vector3d(x * impact, y * impact, z * impact));
        }
    }

    public static MutatedExplosion create(@Nonnull Entity exploderIn, float sizeIn, boolean causesFireIn, Explosion.Mode mode) {
        return MutatedExplosion.create(exploderIn.field_70170_p, exploderIn, exploderIn.func_226277_ct_(), exploderIn.func_226278_cu_(), exploderIn.func_226281_cx_(), sizeIn, causesFireIn, mode);
    }

    public static MutatedExplosion create(World worldIn, @Nullable Entity exploderIn, double xIn, double yIn, double zIn, float sizeIn, boolean causesFireIn, Explosion.Mode mode) {
        MutatedExplosion explosion;
        if (exploderIn instanceof MobEntity && !ForgeEventFactory.getMobGriefingEvent((World)worldIn, (Entity)exploderIn)) {
            mode = Explosion.Mode.NONE;
        }
        if (ForgeEventFactory.onExplosionStart((World)worldIn, (Explosion)(explosion = new MutatedExplosion(worldIn, exploderIn, xIn, yIn, zIn, sizeIn, causesFireIn, mode)))) {
            return explosion;
        }
        if (worldIn instanceof ServerWorld) {
            explosion.func_77278_a();
            explosion.func_77279_a(false);
            if (mode == Explosion.Mode.NONE) {
                explosion.func_180342_d();
            }
            for (ServerPlayerEntity serverplayerentity : ((ServerWorld)worldIn).func_217369_A()) {
                if (!(serverplayerentity.func_70092_e(xIn, yIn, zIn) < 4096.0)) continue;
                serverplayerentity.field_71135_a.func_147359_a((IPacket)new SExplosionPacket(xIn, yIn, zIn, sizeIn, explosion.func_180343_e(), (Vector3d)explosion.func_77277_b().get(serverplayerentity)));
            }
        }
        return explosion;
    }
}

