/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.data.recipe;

import com.blakebr0.mysticalagriculture.api.crop.ICrop;
import com.blakebr0.mysticalagriculture.crafting.ingredient.CropComponentIngredient;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class InfusionRecipeBuilder {
    private final Item result;
    private final int count;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final JsonArray conditions = new JsonArray();
    private Ingredient input = Ingredient.field_193370_a;

    public InfusionRecipeBuilder(IItemProvider output, int count) {
        this.result = output.func_199767_j();
        this.count = count;
    }

    public void addIngredient(Ingredient ingredient) {
        this.ingredients.add(ingredient);
    }

    public void addIngredient(IItemProvider ingredient) {
        this.ingredients.add(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ingredient}));
    }

    public void addCondition(JsonObject condition) {
        this.conditions.add((JsonElement)condition);
    }

    public static InfusionRecipeBuilder newSeedRecipe(ICrop crop) {
        InfusionRecipeBuilder builder = new InfusionRecipeBuilder((IItemProvider)crop.getSeeds(), 1);
        CropComponentIngredient essence = new CropComponentIngredient(crop, CropComponentIngredient.ComponentType.ESSENCE);
        CropComponentIngredient seed = new CropComponentIngredient(crop, CropComponentIngredient.ComponentType.SEED);
        CropComponentIngredient material = new CropComponentIngredient(crop, CropComponentIngredient.ComponentType.MATERIAL);
        builder.input = seed;
        builder.addIngredient(material);
        builder.addIngredient(essence);
        builder.addIngredient(material);
        builder.addIngredient(essence);
        builder.addIngredient(material);
        builder.addIngredient(essence);
        builder.addIngredient(material);
        builder.addIngredient(essence);
        JsonObject condition = new JsonObject();
        condition.addProperty("type", "mysticalagriculture:crop_enabled");
        condition.addProperty("crop", crop.getId().toString());
        builder.addCondition(condition);
        condition = new JsonObject();
        condition.addProperty("type", "mysticalagriculture:crop_has_material");
        condition.addProperty("crop", crop.getId().toString());
        builder.addCondition(condition);
        return builder;
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.result, this.count, this.input, this.ingredients, this.conditions));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final Ingredient input;
        private final List<Ingredient> ingredients;
        private final JsonArray conditions;

        public Result(ResourceLocation id, Item result, int count, Ingredient input, List<Ingredient> ingredients, JsonArray conditions) {
            this.id = id;
            this.result = result;
            this.count = count;
            this.input = input;
            this.ingredients = ingredients;
            this.conditions = conditions;
        }

        public void func_218610_a(JsonObject json) {
            json.add("conditions", (JsonElement)this.conditions);
            json.add("input", this.input.func_200304_c());
            JsonArray ingredients = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                ingredients.add(ingredient.func_200304_c());
            }
            json.add("ingredients", (JsonElement)ingredients);
            JsonObject result = new JsonObject();
            result.addProperty("item", Registry.field_212630_s.func_177774_c((Object)this.result).toString());
            if (this.count > 1) {
                result.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)result);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return ModRecipeSerializers.INFUSION;
        }

        public JsonObject func_200440_c() {
            return null;
        }

        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

