/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.tileentity;

import com.blakebr0.cucumber.energy.BaseEnergyStorage;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.SidedItemStackHandlerWrapper;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.mysticalagriculture.api.crafting.ISoulExtractionRecipe;
import com.blakebr0.mysticalagriculture.api.crafting.RecipeTypes;
import com.blakebr0.mysticalagriculture.container.SoulExtractorContainer;
import com.blakebr0.mysticalagriculture.crafting.recipe.SoulExtractionRecipe;
import com.blakebr0.mysticalagriculture.init.ModTileEntities;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class SoulExtractorTileEntity
extends BaseInventoryTileEntity
implements INamedContainerProvider,
ITickableTileEntity {
    private static final int FUEL_TICK_MULTIPLIER = 20;
    private final BaseItemStackHandler inventory;
    private final BaseEnergyStorage energy;
    private final LazyOptional<IItemHandlerModifiable>[] inventoryCapabilities;
    private final LazyOptional<IEnergyStorage> energyCapability = LazyOptional.of(this::getEnergy);
    private int progress;
    private int fuelLeft;
    private int fuelItemValue;
    private int oldEnergy;
    private SoulExtractionRecipe recipe;

    public SoulExtractorTileEntity() {
        super((TileEntityType)ModTileEntities.SOUL_EXTRACTOR.get());
        this.inventory = new BaseItemStackHandler(3, () -> ((SoulExtractorTileEntity)this).markDirtyAndDispatch());
        this.energy = new BaseEnergyStorage(80000);
        this.inventoryCapabilities = SidedItemStackHandlerWrapper.create((BaseItemStackHandler)this.inventory, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH}, this::canInsertStackSided, null);
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.progress = tag.func_74762_e("Progress");
        this.fuelLeft = tag.func_74762_e("FuelLeft");
        this.fuelItemValue = tag.func_74762_e("FuelItemValue");
        this.energy.setEnergy(tag.func_74762_e("Energy"));
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        tag.func_74768_a("Progress", this.progress);
        tag.func_74768_a("FuelLeft", this.fuelLeft);
        tag.func_74768_a("FuelItemValue", this.fuelItemValue);
        tag.func_74768_a("Energy", this.energy.getEnergyStored());
        return tag;
    }

    public void func_73660_a() {
        World world = this.func_145831_w();
        if (world == null || world.func_201670_d()) {
            return;
        }
        boolean mark = false;
        if (this.energy.getEnergyStored() < this.energy.getMaxEnergyStored()) {
            ItemStack fuel = this.inventory.getStackInSlot(1);
            if (this.fuelLeft <= 0 && !fuel.func_190926_b()) {
                this.fuelItemValue = ForgeHooks.getBurnTime((ItemStack)fuel);
                if (this.fuelItemValue > 0) {
                    this.fuelLeft = this.fuelItemValue *= 20;
                    this.inventory.extractItemSuper(1, 1, false);
                    mark = true;
                }
            }
            if (this.fuelLeft > 0) {
                int fuelPerTick = Math.min(Math.min(this.fuelLeft, this.getFuelUsage() * 2), this.energy.getMaxEnergyStored() - this.energy.getEnergyStored());
                this.fuelLeft -= this.energy.receiveEnergy(fuelPerTick, false);
                if (this.fuelLeft <= 0) {
                    this.fuelItemValue = 0;
                }
                mark = true;
            }
        }
        if (this.recipe == null || !this.recipe.matches((IItemHandler)this.inventory)) {
            ISoulExtractionRecipe recipe = world.func_199532_z().func_215371_a(RecipeTypes.SOUL_EXTRACTION, this.inventory.toIInventory(), world).orElse(null);
            SoulExtractionRecipe soulExtractionRecipe = this.recipe = recipe instanceof SoulExtractionRecipe ? (SoulExtractionRecipe)recipe : null;
        }
        if (this.recipe != null) {
            if (this.energy.getEnergyStored() >= this.getFuelUsage()) {
                ++this.progress;
                this.energy.extractEnergy(this.getFuelUsage(), false);
                if (this.progress >= this.getOperationTime()) {
                    this.inventory.extractItemSuper(0, 1, false);
                    this.inventory.setStackInSlot(2, this.recipe.getCraftingResult((IItemHandler)this.inventory));
                    this.progress = 0;
                }
                mark = true;
            }
        } else if (this.progress > 0) {
            this.progress = 0;
            mark = true;
        }
        if (this.oldEnergy != this.energy.getEnergyStored()) {
            this.oldEnergy = this.energy.getEnergyStored();
            mark = true;
        }
        if (mark) {
            this.markDirtyAndDispatch();
        }
    }

    public ITextComponent func_145748_c_() {
        return Localizable.of((String)"container.mysticalagriculture.soul_extractor").build();
    }

    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return SoulExtractorContainer.create(id, playerInventory, arg_0 -> ((SoulExtractorTileEntity)this).isUsableByPlayer(arg_0), this.inventory, this.func_174877_v());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.func_145837_r()) {
            if (cap == CapabilityEnergy.ENERGY) {
                return CapabilityEnergy.ENERGY.orEmpty(cap, this.energyCapability);
            }
            if (side != null && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                if (side == Direction.UP) {
                    return this.inventoryCapabilities[0].cast();
                }
                if (side == Direction.DOWN) {
                    return this.inventoryCapabilities[1].cast();
                }
                return this.inventoryCapabilities[2].cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public BaseEnergyStorage getEnergy() {
        return this.energy;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getOperationTime() {
        return 100;
    }

    public int getFuelLeft() {
        return this.fuelLeft;
    }

    public int getFuelItemValue() {
        return this.fuelItemValue;
    }

    public int getFuelUsage() {
        return 40;
    }

    private boolean canInsertStackSided(int slot, ItemStack stack, Direction direction) {
        if (direction == null) {
            return true;
        }
        if (slot == 0 && direction == Direction.UP) {
            return true;
        }
        if (slot == 1 && direction == Direction.NORTH) {
            return FurnaceTileEntity.func_213991_b((ItemStack)stack);
        }
        return false;
    }
}

