/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.config;

import com.chaosthedude.naturescompass.utils.OverlaySide;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;

public class NaturesCompassConfig {
    private static Path configFilePath;
    private static Gson gson;
    public static boolean allowTeleport;
    public static boolean displayCoordinates;
    public static int maxSamples;
    public static int radiusModifier;
    public static int sampleSpaceModifier;
    public static List<String> biomeBlacklist;
    public static boolean displayWithChatOpen;
    public static boolean fixBiomeNames;
    public static int overlayLineOffset;
    public static OverlaySide overlaySide;

    public static void load() {
        if (NaturesCompassConfig.getFilePath().toFile().exists()) {
            try {
                BufferedReader reader = Files.newBufferedReader(NaturesCompassConfig.getFilePath());
                Data data = (Data)gson.fromJson((Reader)reader, Data.class);
                allowTeleport = data.common.allowTeleport;
                displayCoordinates = data.common.displayCoordinates;
                maxSamples = data.common.maxSamples;
                radiusModifier = data.common.radiusModifier;
                sampleSpaceModifier = data.common.sampleSpaceModifier;
                biomeBlacklist = data.common.biomeBlacklist;
                displayWithChatOpen = data.client.displayWithChatOpen;
                fixBiomeNames = data.client.fixBiomeNames;
                overlayLineOffset = data.client.overlayLineOffset;
                overlaySide = data.client.overlaySide;
                ((Reader)reader).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        NaturesCompassConfig.save();
    }

    public static void save() {
        try {
            BufferedWriter writer = Files.newBufferedWriter(NaturesCompassConfig.getFilePath(), new OpenOption[0]);
            Data data = new Data(new Data.Common(allowTeleport, displayCoordinates, maxSamples, radiusModifier, sampleSpaceModifier, biomeBlacklist), new Data.Client(displayWithChatOpen, fixBiomeNames, overlayLineOffset, overlaySide));
            gson.toJson((Object)data, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Path getFilePath() {
        if (configFilePath == null) {
            configFilePath = FabricLoader.getInstance().getConfigDir().resolve("naturescompass.json");
        }
        return configFilePath;
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        allowTeleport = true;
        displayCoordinates = true;
        maxSamples = 50000;
        radiusModifier = 2500;
        sampleSpaceModifier = 16;
        biomeBlacklist = new ArrayList<String>();
        displayWithChatOpen = true;
        fixBiomeNames = true;
        overlayLineOffset = 1;
        overlaySide = OverlaySide.LEFT;
    }

    private static class Data {
        private Common common;
        private Client client;

        public Data(Common common, Client client) {
            this.common = common;
            this.client = client;
        }

        private static class Client {
            private final String displayWithChatOpenComment = "Displays Nature's Compass information even while chat is open.";
            private final boolean displayWithChatOpen;
            private final String fixBiomeNamesComment = "Fixes biome names by adding missing spaces. Ex: ForestHills becomes Forest Hills";
            private final boolean fixBiomeNames;
            private final String overlayLineOffsetComment = "The line offset for information rendered on the HUD.";
            private final int overlayLineOffset;
            private final String overlaySideComment = "The side for information rendered on the HUD. Ex: LEFT, RIGHT";
            private final OverlaySide overlaySide;

            private Client() {
                this.displayWithChatOpen = true;
                this.fixBiomeNames = true;
                this.overlayLineOffset = 1;
                this.overlaySide = OverlaySide.LEFT;
            }

            private Client(boolean displayWithChatOpen, boolean fixBiomeNames, int overlayLineOffset, OverlaySide overlaySide) {
                this.displayWithChatOpen = displayWithChatOpen;
                this.fixBiomeNames = fixBiomeNames;
                this.overlayLineOffset = overlayLineOffset;
                this.overlaySide = overlaySide;
            }
        }

        private static class Common {
            private final String allowTeleportComment = "Allows a player to teleport to a located biome when in creative mode, opped, or in cheat mode.";
            private final boolean allowTeleport;
            private final String displayCoordinatesComment = "Allows players to view the precise coordinates and distance of a located structure on the HUD, rather than relying on the direction the compass is pointing.";
            private final boolean displayCoordinates;
            private final String maxSamplesComment = "The maximum number of samples to be taken when searching for a biome.";
            private final int maxSamples;
            private final String radiusModifierComment = "biomeSize * radiusModifier = maxSearchRadius. Raising this value will increase search accuracy but will potentially make the process more resource .";
            private final int radiusModifier;
            private final String sampleSpaceModifierComment = "biomeSize * sampleSpaceModifier = sampleSpace. Lowering this value will increase search accuracy but will make the process more resource intensive.";
            private final int sampleSpaceModifier;
            private final String biomeBlacklistComment = "A list of biomes that the compass will not be able to search for, specified by resource location. The wildcard character * can be used to match any number of characters, and ? can be used to match one character. Ex (ignore backslashes): [\"minecraft:savanna\", \"minecraft:desert\", \"minecraft:*ocean*\"]";
            private final List<String> biomeBlacklist;

            private Common() {
                this.allowTeleport = true;
                this.displayCoordinates = true;
                this.maxSamples = 50000;
                this.radiusModifier = 2500;
                this.sampleSpaceModifier = 16;
                this.biomeBlacklist = new ArrayList<String>();
            }

            private Common(boolean allowTeleport, boolean displayCoordinates, int maxSamples, int radiusModifier, int sampleSpaceModifier, List<String> biomeBlacklist) {
                this.allowTeleport = allowTeleport;
                this.displayCoordinates = displayCoordinates;
                this.maxSamples = maxSamples;
                this.radiusModifier = radiusModifier;
                this.sampleSpaceModifier = sampleSpaceModifier;
                this.biomeBlacklist = biomeBlacklist;
            }
        }
    }
}

