/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.network;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.config.NaturesCompassConfig;
import com.chaosthedude.naturescompass.items.NaturesCompassItem;
import com.chaosthedude.naturescompass.utils.CompassState;
import com.chaosthedude.naturescompass.utils.ItemUtils;
import com.chaosthedude.naturescompass.utils.PlayerUtils;
import io.netty.buffer.Unpooled;
import java.util.EnumSet;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2708;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class TeleportPacket
extends class_2540 {
    public static final class_2960 ID = new class_2960("naturescompass", "teleport");

    public TeleportPacket() {
        super(Unpooled.buffer());
    }

    public static void apply(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        server.execute(() -> {
            class_1799 stack = ItemUtils.getHeldNatureCompass((class_1657)player);
            if (!stack.method_7960()) {
                NaturesCompassItem natureCompass = (NaturesCompassItem)stack.method_7909();
                if (NaturesCompassConfig.allowTeleport && PlayerUtils.canTeleport((class_1657)player)) {
                    if (natureCompass.getState(stack) == CompassState.FOUND) {
                        int x = natureCompass.getFoundBiomeX(stack);
                        int z = natureCompass.getFoundBiomeZ(stack);
                        int y = TeleportPacket.findValidTeleportHeight(player.method_5770(), x, z, (class_1657)player);
                        player.method_5848();
                        player.field_13987.method_14360((double)x, (double)y, (double)z, player.field_6031, player.field_5965, EnumSet.noneOf(class_2708.class_2709.class));
                        if (!player.method_6128()) {
                            player.method_18800(player.method_18798().method_10216(), 0.0, player.method_18798().method_10215());
                            player.method_24830(true);
                        }
                    }
                } else {
                    NaturesCompass.LOGGER.warn("Player " + player.method_5476().getString() + " tried to teleport but does not have permission.");
                }
            }
        });
    }

    private static int findValidTeleportHeight(class_1937 world, int x, int z, class_1657 player) {
        int downY;
        int startY;
        int upY = startY = world.method_8615();
        for (downY = startY; !(TeleportPacket.isValidTeleportPosition(world, new class_2338(x, upY, z), player) || TeleportPacket.isValidTeleportPosition(world, new class_2338(x, downY, z), player) || upY >= 255 && downY <= 1); ++upY, --downY) {
        }
        class_2338 upPos = new class_2338(x, upY, z);
        class_2338 downPos = new class_2338(x, downY, z);
        if (upY < 255 && TeleportPacket.isValidTeleportPosition(world, upPos, player)) {
            return upY;
        }
        if (downY > 1 && TeleportPacket.isValidTeleportPosition(world, downPos, player)) {
            return downY;
        }
        return 256;
    }

    private static boolean isValidTeleportPosition(class_1937 world, class_2338 pos, class_1657 player) {
        return !world.method_8320(pos).method_26212((class_1922)world, pos) && world.method_8320(pos).method_26168((class_1922)world, pos.method_10074(), (class_1297)player);
    }
}

