/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.workers;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.config.NaturesCompassConfig;
import com.chaosthedude.naturescompass.items.NaturesCompassItem;
import com.chaosthedude.naturescompass.utils.BiomeUtils;
import com.chaosthedude.naturescompass.workers.WorldWorkerManager;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2960;

public class BiomeSearchWorker
implements WorldWorkerManager.IWorker {
    public final int sampleSpace;
    public final int maxSamples;
    public final int maxRadius;
    public class_1937 world;
    public class_1959 biome;
    public class_2960 biomeKey;
    public class_2338 startPos;
    public int samples;
    public int nextLength;
    public class_2350 direction;
    public class_1799 stack;
    public class_1657 player;
    public int x;
    public int z;
    public int length;
    public boolean finished;
    public int lastRadiusThreshold;

    public BiomeSearchWorker(class_1937 world, class_1657 player, class_1799 stack, class_1959 biome, class_2338 startPos) {
        this.world = world;
        this.player = player;
        this.stack = stack;
        this.biome = biome;
        this.startPos = startPos;
        this.x = startPos.method_10263();
        this.z = startPos.method_10260();
        this.sampleSpace = NaturesCompassConfig.sampleSpaceModifier * BiomeUtils.getBiomeSize(world);
        this.maxSamples = NaturesCompassConfig.maxSamples;
        this.maxRadius = NaturesCompassConfig.radiusModifier * BiomeUtils.getBiomeSize(world);
        this.nextLength = this.sampleSpace;
        this.length = 0;
        this.samples = 0;
        this.direction = class_2350.field_11036;
        this.finished = false;
        this.biomeKey = BiomeUtils.getIdentifierForBiome(world, biome);
        this.lastRadiusThreshold = 0;
    }

    public void start() {
        if (!this.stack.method_7960() && this.stack.method_7909() == NaturesCompass.NATURES_COMPASS_ITEM) {
            if (this.maxRadius > 0 && this.sampleSpace > 0) {
                NaturesCompass.LOGGER.info("Starting search: " + this.sampleSpace + " sample space, " + this.maxSamples + " max samples, " + this.maxRadius + " max radius");
                WorldWorkerManager.addWorker(this);
            } else {
                this.finish(false);
            }
        }
    }

    @Override
    public boolean hasWork() {
        return !this.finished && this.getRadius() <= this.maxRadius && this.samples <= this.maxSamples;
    }

    @Override
    public boolean doWork() {
        if (this.hasWork()) {
            int radius;
            if (this.direction == class_2350.field_11043) {
                this.z -= this.sampleSpace;
            } else if (this.direction == class_2350.field_11034) {
                this.x += this.sampleSpace;
            } else if (this.direction == class_2350.field_11035) {
                this.z += this.sampleSpace;
            } else if (this.direction == class_2350.field_11039) {
                this.x -= this.sampleSpace;
            }
            class_2338 pos = new class_2338(this.x, this.world.method_8322(), this.z);
            class_1959 biomeAtPos = this.world.method_22385().method_22393(pos);
            class_2960 biomeAtPosID = BiomeUtils.getIdentifierForBiome(this.world, biomeAtPos);
            if (biomeAtPosID != null && biomeAtPosID.equals((Object)this.biomeKey)) {
                this.finish(true);
                return false;
            }
            ++this.samples;
            this.length += this.sampleSpace;
            if (this.length >= this.nextLength) {
                if (this.direction != class_2350.field_11036) {
                    this.nextLength += this.sampleSpace;
                    this.direction = this.direction.method_10170();
                } else {
                    this.direction = class_2350.field_11043;
                }
                this.length = 0;
            }
            if ((radius = this.getRadius()) > 500 && radius / 500 > this.lastRadiusThreshold) {
                if (!this.stack.method_7960() && this.stack.method_7909() == NaturesCompass.NATURES_COMPASS_ITEM) {
                    ((NaturesCompassItem)this.stack.method_7909()).setSearchRadius(this.stack, this.roundRadius(radius, 500), this.player);
                }
                this.lastRadiusThreshold = radius / 500;
            }
        }
        if (this.hasWork()) {
            return true;
        }
        this.finish(false);
        return false;
    }

    private void finish(boolean found) {
        if (!this.stack.method_7960() && this.stack.method_7909() == NaturesCompass.NATURES_COMPASS_ITEM) {
            if (found) {
                NaturesCompass.LOGGER.info("Search succeeded: " + this.getRadius() + " radius, " + this.samples + " samples");
                ((NaturesCompassItem)this.stack.method_7909()).setFound(this.stack, this.x, this.z, this.samples, this.player);
                ((NaturesCompassItem)this.stack.method_7909()).setDisplayCoordinates(this.stack, NaturesCompassConfig.displayCoordinates);
            } else {
                NaturesCompass.LOGGER.info("Search failed: " + this.getRadius() + " radius, " + this.samples + " samples");
                ((NaturesCompassItem)this.stack.method_7909()).setNotFound(this.stack, this.player, this.roundRadius(this.getRadius(), 500), this.samples);
            }
        } else {
            NaturesCompass.LOGGER.error("Invalid compass after search");
        }
        this.finished = true;
    }

    private int getRadius() {
        return BiomeUtils.getDistanceToBiome(this.startPos, this.x, this.z);
    }

    private int roundRadius(int radius, int roundTo) {
        return radius / roundTo * roundTo;
    }
}

