/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass;

import com.chaosthedude.naturescompass.client.ClientEventHandler;
import com.chaosthedude.naturescompass.config.ConfigHandler;
import com.chaosthedude.naturescompass.items.NaturesCompassItem;
import com.chaosthedude.naturescompass.network.CompassSearchPacket;
import com.chaosthedude.naturescompass.network.SyncPacket;
import com.chaosthedude.naturescompass.network.TeleportPacket;
import com.chaosthedude.naturescompass.util.CompassState;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmllegacy.network.NetworkRegistry;
import net.minecraftforge.fmllegacy.network.simple.SimpleChannel;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="naturescompass")
public class NaturesCompass {
    public static final String MODID = "naturescompass";
    public static final String NAME = "Nature's Compass";
    public static final String VERSION = "1.9.2";
    public static final String TELEPORT_PERMISSION = "naturescompass.teleport";
    public static final Logger LOGGER = LogManager.getLogger((String)"naturescompass");
    public static SimpleChannel network;
    public static NaturesCompassItem naturesCompass;
    public static boolean canTeleport;
    public static List<ResourceLocation> allowedBiomes;
    public static NaturesCompass instance;

    public NaturesCompass() {
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::preInit);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientInit));
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigHandler.GENERAL_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigHandler.CLIENT_SPEC);
    }

    private void preInit(FMLCommonSetupEvent event) {
        network = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, MODID), () -> "1.0", s -> true, s -> true);
        network.registerMessage(0, CompassSearchPacket.class, CompassSearchPacket::toBytes, CompassSearchPacket::new, CompassSearchPacket::handle);
        network.registerMessage(1, TeleportPacket.class, TeleportPacket::toBytes, TeleportPacket::new, TeleportPacket::handle);
        network.registerMessage(2, SyncPacket.class, SyncPacket::toBytes, SyncPacket::new, SyncPacket::handle);
        allowedBiomes = new ArrayList<ResourceLocation>();
        PermissionAPI.registerNode((String)TELEPORT_PERMISSION, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Teleport permission of Nature's Compass");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientInit(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        ItemProperties.register((Item)naturesCompass, (ResourceLocation)new ResourceLocation("angle"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){
            @OnlyIn(value=Dist.CLIENT)
            private double rotation;
            @OnlyIn(value=Dist.CLIENT)
            private double rota;
            @OnlyIn(value=Dist.CLIENT)
            private long lastUpdateTick;

            @OnlyIn(value=Dist.CLIENT)
            public float m_142187_(ItemStack stack, ClientLevel world, LivingEntity entityLiving, int seed) {
                LivingEntity entity;
                if (entityLiving == null && !stack.m_41794_()) {
                    return 0.0f;
                }
                boolean entityExists = entityLiving != null;
                Object object = entity = entityExists ? entityLiving : stack.m_41795_();
                if (world == null && entity.f_19853_ instanceof ClientLevel) {
                    world = (ClientLevel)entity.f_19853_;
                }
                double rotation = entityExists ? (double)entity.m_146908_() : this.getFrameRotation((ItemFrame)entity);
                double adjusted = Math.PI - (((rotation %= 360.0) - 90.0) * 0.01745329238474369 - this.getAngle(world, (Entity)entity, stack));
                if (entityExists) {
                    adjusted = this.wobble(world, adjusted);
                }
                float f = (float)(adjusted / (Math.PI * 2));
                return Mth.m_14091_((float)f, (float)1.0f);
            }

            @OnlyIn(value=Dist.CLIENT)
            private double wobble(ClientLevel world, double amount) {
                if (world.m_46467_() != this.lastUpdateTick) {
                    this.lastUpdateTick = world.m_46467_();
                    double d0 = amount - this.rotation;
                    d0 %= Math.PI * 2;
                    d0 = Mth.m_14008_((double)d0, (double)-1.0, (double)1.0);
                    this.rota += d0 * 0.1;
                    this.rota *= 0.8;
                    this.rotation += this.rota;
                }
                return this.rotation;
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getFrameRotation(ItemFrame itemFrame) {
                Direction direction = itemFrame.m_6350_();
                int i = direction.m_122434_().m_122478_() ? 90 * direction.m_122421_().m_122540_() : 0;
                return Mth.m_14098_((int)(180 + direction.m_122416_() * 90 + itemFrame.m_31823_() * 45 + i));
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getAngle(ClientLevel world, Entity entity, ItemStack stack) {
                if (stack.m_41720_() == naturesCompass) {
                    NaturesCompassItem compassItem = (NaturesCompassItem)stack.m_41720_();
                    BlockPos pos = compassItem.getState(stack) == CompassState.FOUND ? new BlockPos(compassItem.getFoundBiomeX(stack), 0, compassItem.getFoundBiomeZ(stack)) : world.m_104822_();
                    return Math.atan2((double)pos.m_123343_() - entity.m_20182_().m_7094_(), (double)pos.m_123341_() - entity.m_20182_().m_7096_());
                }
                return 0.0;
            }
        });
    }
}

