/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.network;

import com.chaosthedude.naturescompass.NaturesCompass;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class SyncPacket {
    private boolean canTeleport;
    private List<ResourceLocation> allowedBiomes;

    public SyncPacket() {
    }

    public SyncPacket(boolean canTeleport, List<ResourceLocation> allowedBiomes) {
        this.canTeleport = canTeleport;
        this.allowedBiomes = allowedBiomes;
    }

    public SyncPacket(FriendlyByteBuf buf) {
        this.canTeleport = buf.readBoolean();
        this.allowedBiomes = new ArrayList<ResourceLocation>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.allowedBiomes.add(new ResourceLocation(buf.m_130277_()));
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.canTeleport);
        buf.writeInt(this.allowedBiomes.size());
        for (ResourceLocation biome : this.allowedBiomes) {
            buf.m_130085_(biome);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            NaturesCompass.canTeleport = this.canTeleport;
            NaturesCompass.allowedBiomes = this.allowedBiomes;
        });
        ctx.get().setPacketHandled(true);
    }
}

