/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.gui.BiomeInfoScreen;
import com.chaosthedude.naturescompass.gui.BiomeSearchList;
import com.chaosthedude.naturescompass.gui.NaturesCompassScreen;
import com.chaosthedude.naturescompass.utils.BiomeUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_350;
import net.minecraft.class_437;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public class BiomeSearchEntry
extends class_350.class_351<BiomeSearchEntry> {
    private final class_310 mc;
    private final NaturesCompassScreen parentScreen;
    private final class_1959 biome;
    private final BiomeSearchList biomesList;
    private long lastClickTime;

    public BiomeSearchEntry(BiomeSearchList biomesList, class_1959 biome) {
        this.biomesList = biomesList;
        this.biome = biome;
        this.parentScreen = biomesList.getGuiNaturesCompass();
        this.mc = class_310.method_1551();
    }

    public void method_25343(class_4587 matrixStack, int par1, int par2, int par3, int par4, int par5, int par6, int par7, boolean par8, float par9) {
        String precipitationState = class_1074.method_4662((String)"string.naturescompass.none", (Object[])new Object[0]);
        if (this.biome.method_8694() == class_1959.class_1963.field_9383) {
            precipitationState = class_1074.method_4662((String)"string.naturescompass.snow", (Object[])new Object[0]);
        } else if (this.biome.method_8694() == class_1959.class_1963.field_9382) {
            precipitationState = class_1074.method_4662((String)"string.naturescompass.rain", (Object[])new Object[0]);
        }
        String title = this.parentScreen.getSortingCategory().getLocalizedName();
        Object value = this.parentScreen.getSortingCategory().getValue(this.biome);
        if (value == null) {
            title = class_1074.method_4662((String)"string.naturescompass.topBlock", (Object[])new Object[0]);
            value = class_1074.method_4662((String)this.biome.method_30970().method_30985().method_15337().method_26204().method_9539(), (Object[])new Object[0]);
        }
        this.mc.field_1772.method_1729(matrixStack, BiomeUtils.getBiomeNameForDisplay(this.parentScreen.world, this.biome), (float)(par3 + 1), (float)(par2 + 1), 0xFFFFFF);
        class_327 class_3272 = this.mc.field_1772;
        String string = title + ": " + value;
        float f = par3 + 1;
        Objects.requireNonNull(this.mc.field_1772);
        class_3272.method_1729(matrixStack, string, f, (float)(par2 + 9 + 3), 0x808080);
        class_327 class_3273 = this.mc.field_1772;
        String string2 = class_1074.method_4662((String)"string.naturescompass.precipitation", (Object[])new Object[0]) + ": " + precipitationState;
        float f2 = par3 + 1;
        Objects.requireNonNull(this.mc.field_1772);
        class_3273.method_1729(matrixStack, string2, f2, (float)(par2 + 9 + 14), 0x808080);
        class_327 class_3274 = this.mc.field_1772;
        String string3 = class_1074.method_4662((String)"string.naturescompass.source", (Object[])new Object[0]) + ": " + BiomeUtils.getBiomeSource(this.parentScreen.world, this.biome);
        float f3 = par3 + 1;
        Objects.requireNonNull(this.mc.field_1772);
        class_3274.method_1729(matrixStack, string3, f3, (float)(par2 + 9 + 25), 0x808080);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.biomesList.selectBiome(this);
            if (class_156.method_658() - this.lastClickTime < 250L) {
                this.searchForBiome();
                return true;
            }
            this.lastClickTime = class_156.method_658();
            return false;
        }
        return false;
    }

    public void searchForBiome() {
        this.mc.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
        this.parentScreen.searchForBiome(this.biome);
    }

    public void viewInfo() {
        this.mc.method_1507((class_437)new BiomeInfoScreen(this.parentScreen, this.biome));
    }
}

