/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.common.block;

import com.minecraftabnormals.neapolitan.core.registry.NeapolitanBlocks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;

public class BananaFrondBlock
extends BushBlock
implements IGrowable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;

    public BananaFrondBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.UP));
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        BlockState blockState = worldIn.func_180495_p(blockpos);
        return BananaFrondBlock.func_220055_a((IWorldReader)worldIn, (BlockPos)blockpos, (Direction)facing) || this.func_200014_a_(blockState, (IBlockReader)worldIn, blockpos);
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_235714_a_((ITag)BlockTags.field_206952_E);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196000_l());
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return state.func_177229_b((Property)FACING) == Direction.UP && BananaFrondBlock.canGrowOn(worldIn.func_180495_p(pos.func_177977_b())) && worldIn instanceof World && ((World)worldIn).func_175727_C(pos);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        if (rand.nextInt(4) == 0) {
            BananaFrondBlock.attemptGrowBanana(BananaFrondBlock.getSizeForFrond(rand, (Block)this), (World)world, rand, pos);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (this.func_176473_a((IBlockReader)worldIn, pos, state, worldIn.func_201670_d()) && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (rand.nextInt(2) == 0 ? 1 : 0) != 0)) {
            BananaFrondBlock.attemptGrowBanana(BananaFrondBlock.getSizeForFrond(rand, (Block)this), (World)worldIn, rand, pos);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public static boolean attemptGrowBanana(int size, World world, Random rand, BlockPos pos) {
        int i;
        BlockPos blockPos = pos;
        ArrayList<BlockPos> stalks = new ArrayList<BlockPos>();
        BlockPos upFrond = null;
        BlockPos bundle = null;
        HashMap<BlockPos, Direction> smallFronds = new HashMap<BlockPos, Direction>();
        HashMap<BlockPos, Direction> fronds = new HashMap<BlockPos, Direction>();
        HashMap<BlockPos, Direction> largeFronds = new HashMap<BlockPos, Direction>();
        for (i = 0; i < size; ++i) {
            stalks.add(blockPos);
            blockPos = blockPos.func_177984_a();
        }
        upFrond = blockPos;
        i = 0;
        for (BlockPos stalk : stalks) {
            if (i >= size - 3) {
                for (Direction direction : Direction.values()) {
                    if (!direction.func_176740_k().func_176722_c()) continue;
                    if (i == size - 1) {
                        if (rand.nextInt(4) != 0) {
                            largeFronds.put(stalk.func_177972_a(direction), direction);
                            continue;
                        }
                        fronds.put(stalk.func_177972_a(direction), direction);
                        continue;
                    }
                    if (i == size - 2) {
                        if (rand.nextBoolean()) {
                            fronds.put(stalk.func_177972_a(direction), direction);
                            continue;
                        }
                        if (rand.nextBoolean() && bundle == null) {
                            bundle = stalk.func_177972_a(direction);
                            continue;
                        }
                        smallFronds.put(stalk.func_177972_a(direction), direction);
                        continue;
                    }
                    if (i != size - 3 || rand.nextInt(3) == 0) continue;
                    smallFronds.put(stalk.func_177972_a(direction), direction);
                }
            }
            ++i;
        }
        if (BananaFrondBlock.isAirAt(world, pos, size) && pos.func_177956_o() < world.func_217301_I() - size) {
            for (BlockPos blockPos2 : stalks) {
                world.func_180501_a(blockPos2, ((Block)NeapolitanBlocks.BANANA_STALK.get()).func_176223_P(), 2);
            }
            world.func_180501_a(upFrond, ((Block)NeapolitanBlocks.LARGE_BANANA_FROND.get()).func_176223_P(), 2);
            if (bundle != null) {
                world.func_180501_a(bundle, ((Block)NeapolitanBlocks.BANANA_BUNDLE.get()).func_176223_P(), 2);
            }
            for (BlockPos blockPos2 : smallFronds.keySet()) {
                world.func_180501_a(blockPos2, (BlockState)((Block)NeapolitanBlocks.SMALL_BANANA_FROND.get()).func_176223_P().func_206870_a((Property)FACING, (Comparable)smallFronds.get(blockPos2)), 2);
            }
            for (BlockPos blockPos2 : fronds.keySet()) {
                world.func_180501_a(blockPos2, (BlockState)((Block)NeapolitanBlocks.BANANA_FROND.get()).func_176223_P().func_206870_a((Property)FACING, (Comparable)fronds.get(blockPos2)), 2);
            }
            for (BlockPos blockPos2 : largeFronds.keySet()) {
                world.func_180501_a(blockPos2, (BlockState)((Block)NeapolitanBlocks.LARGE_BANANA_FROND.get()).func_176223_P().func_206870_a((Property)FACING, (Comparable)largeFronds.get(blockPos2)), 2);
            }
            return true;
        }
        return false;
    }

    public static boolean canGrowOn(BlockState state) {
        return state.func_235714_a_((ITag)Tags.Blocks.GRAVEL) || state.func_235714_a_((ITag)Tags.Blocks.SAND);
    }

    private static boolean isAirAt(World world, BlockPos pos, int size) {
        BlockPos position = pos.func_177984_a();
        for (int i = 0; i < size + 1; ++i) {
            if (!world.func_175623_d(position)) {
                return false;
            }
            for (Direction direction : Direction.values()) {
                if (!direction.func_176740_k().func_176722_c() || world.func_175623_d(position.func_177972_a(direction))) continue;
                return false;
            }
            position = position.func_177984_a();
        }
        return true;
    }

    private static int getSizeForFrond(Random rand, Block frond) {
        int extra = 0;
        if (frond == NeapolitanBlocks.SMALL_BANANA_FROND.get()) {
            extra = rand.nextInt(2);
        }
        if (frond == NeapolitanBlocks.BANANA_FROND.get()) {
            extra = 1 + rand.nextInt(2);
        }
        if (frond == NeapolitanBlocks.LARGE_BANANA_FROND.get()) {
            extra = 1 + rand.nextInt(3);
        }
        return 3 + extra;
    }
}

