/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.common.block;

import com.google.common.collect.ImmutableList;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanBlocks;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.CakeBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class FlavoredCakeBlock
extends CakeBlock {
    private EffectType effectType;
    private Food food;

    public FlavoredCakeBlock(Food food, EffectType effectType, AbstractBlock.Properties properties) {
        super(properties);
        this.effectType = effectType;
        this.food = food;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            ItemStack itemstack = player.func_184586_b(handIn);
            if (this.eatSlice((IWorld)worldIn, pos, state, player).func_226246_a_()) {
                return ActionResultType.SUCCESS;
            }
            if (itemstack.func_190926_b()) {
                return ActionResultType.CONSUME;
            }
        }
        return this.eatSlice((IWorld)worldIn, pos, state, player);
    }

    private ActionResultType eatSlice(IWorld world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!player.func_71043_e(false)) {
            return ActionResultType.PASS;
        }
        player.func_195066_a(Stats.field_188076_J);
        player.func_71024_bL().func_75122_a(this.food.func_221466_a(), this.food.func_221469_b());
        int i = (Integer)state.func_177229_b((Property)field_176589_a);
        if (this == NeapolitanBlocks.STRAWBERRY_CAKE.get()) {
            player.func_70691_i(1.0f);
        }
        ImmutableList effects = ImmutableList.copyOf((Collection)player.func_70651_bq());
        if (this.getEffectType() != null) {
            for (int j = 0; j < effects.size(); ++j) {
                Effect effect = ((EffectInstance)effects.get(j)).func_188419_a();
                if (effect.func_220303_e() != this.getEffectType() && (this.getEffectType() != EffectType.HARMFUL || effect != Effects.field_220309_E) && this.getEffectType() != EffectType.NEUTRAL) continue;
                player.func_195063_d(effect);
            }
        } else if (effects.size() > 0) {
            Random rand = new Random();
            EffectInstance effectToRemove = (EffectInstance)effects.get(rand.nextInt(effects.size()));
            player.func_195063_d(effectToRemove.func_188419_a());
        }
        for (Pair pair : this.food.func_221464_f()) {
            if (world.func_201670_d() || pair.getFirst() == null || !(world.func_201674_k().nextFloat() < ((Float)pair.getSecond()).floatValue())) continue;
            player.func_195064_c(new EffectInstance((EffectInstance)pair.getFirst()));
        }
        if (i < 6) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)field_176589_a, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            world.func_217377_a(pos, false);
        }
        return ActionResultType.SUCCESS;
    }

    public EffectType getEffectType() {
        return this.effectType;
    }
}

