/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.common.block;

import com.minecraftabnormals.neapolitan.core.other.NeapolitanCriteriaTriggers;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanItems;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;

public class StrawberryBushBlock
extends BushBlock
implements IPlantable,
IGrowable {
    public static final IntegerProperty AGE = IntegerProperty.func_177719_a((String)"age", (int)0, (int)6);
    public static final EnumProperty<StrawberryType> TYPE = EnumProperty.func_177709_a((String)"type", StrawberryType.class);
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0)};

    public StrawberryBushBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0))).func_206870_a(TYPE, (Comparable)((Object)StrawberryType.NONE)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        boolean fullyGrown;
        int age = (Integer)state.func_177229_b((Property)AGE);
        boolean bl = fullyGrown = age == this.getMaxAge();
        if (!fullyGrown && player.func_184586_b(handIn).func_77973_b() == Items.field_196106_bc) {
            return ActionResultType.PASS;
        }
        if (fullyGrown) {
            int strawberryCount = 1 + worldIn.field_73012_v.nextInt(3);
            Item strawberry = state.func_177229_b(TYPE) == StrawberryType.WHITE ? (Item)NeapolitanItems.WHITE_STRAWBERRIES.get() : (Item)NeapolitanItems.STRAWBERRIES.get();
            StrawberryBushBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)strawberry, strawberryCount));
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_219693_lB, SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
            worldIn.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(1))).func_206870_a(TYPE, (Comparable)((Object)StrawberryType.NONE)), 2);
            if (player instanceof ServerPlayerEntity) {
                NeapolitanCriteriaTriggers.HARVEST_STRAWBERRIES.trigger((ServerPlayerEntity)player, state);
            }
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    protected int getBonemealAgeIncrease(World worldIn) {
        return MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)2, (int)5);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        super.func_225534_a_(state, worldIn, pos, rand);
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (worldIn.func_226659_b_(pos, 0) >= 13) {
            int growthChance;
            int age = this.getAge(state);
            int maxAgeForPos = worldIn.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_196660_k) ? 2 : this.getMaxAge();
            int n = growthChance = !worldIn.func_72896_J() ? 7 : 5;
            if (age < maxAgeForPos && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (rand.nextInt(growthChance) == 0 ? 1 : 0) != 0)) {
                if (age != 5) {
                    worldIn.func_180501_a(pos, this.withAge(age + 1), 2);
                } else {
                    worldIn.func_180501_a(pos, (BlockState)this.withAge(age + 1).func_206870_a(TYPE, (Comparable)((Object)(this.isWhite(worldIn, pos) ? StrawberryType.WHITE : StrawberryType.RED))), 2);
                }
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        LivingEntity entity;
        if (worldIn.field_73012_v.nextInt(15) == 0 && (entityIn.field_70142_S != entityIn.func_226277_ct_() || entityIn.field_70136_U != entityIn.func_226281_cx_())) {
            double d0 = Math.abs(entityIn.func_226277_ct_() - entityIn.field_70142_S);
            double d1 = Math.abs(entityIn.func_226281_cx_() - entityIn.field_70136_U);
            if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187579_bV, SoundCategory.BLOCKS, 1.5f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
            }
        }
        if (entityIn instanceof RavagerEntity && ForgeEventFactory.getMobGriefingEvent((World)worldIn, (Entity)entityIn)) {
            worldIn.func_225521_a_(pos, true, entityIn);
        }
        if (entityIn instanceof LivingEntity && (entity = (LivingEntity)entityIn).func_70668_bt() == CreatureAttribute.field_223224_c_ && (Integer)state.func_177229_b((Property)AGE) > 0) {
            entity.func_195064_c(new EffectInstance(Effects.field_76441_p, 3, 0, false, false, false));
        }
        super.func_196262_a(state, worldIn, pos, entityIn);
    }

    @Nullable
    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        if (entity instanceof CreeperEntity) {
            return PathNodeType.DANGER_OTHER;
        }
        return super.getAiPathNodeType(state, world, pos, entity);
    }

    protected IItemProvider getSeedsItem() {
        return (IItemProvider)NeapolitanItems.STRAWBERRY_PIPS.get();
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack(this.getSeedsItem());
    }

    protected int getAge(BlockState state) {
        return (Integer)state.func_177229_b((Property)this.getAgeProperty());
    }

    public BlockState withAge(int age) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.func_177229_b((Property)this.getAgeProperty()) >= this.getMaxAge();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE, TYPE});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE_BY_AGE[(Integer)state.func_177229_b((Property)this.getAgeProperty())];
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 6;
    }

    private boolean isWhite(ServerWorld worldIn, BlockPos pos) {
        return pos.func_177956_o() >= 200 && worldIn.func_234922_V_() == DimensionType.field_235999_c_ || worldIn.func_234922_V_() == DimensionType.field_236001_e_;
    }

    public boolean func_176473_a(IBlockReader block, BlockPos pos, BlockState state, boolean isClient) {
        return !this.isMaxAge(state);
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        int age = Math.min(this.getAge(state) + this.getBonemealAgeIncrease((World)worldIn), this.getMaxAge());
        if (age != 6) {
            worldIn.func_180501_a(pos, this.withAge(age), 2);
        } else {
            worldIn.func_180501_a(pos, (BlockState)this.withAge(age).func_206870_a(TYPE, (Comparable)((Object)(this.isWhite(worldIn, pos) ? StrawberryType.WHITE : StrawberryType.RED))), 2);
        }
    }

    public static enum StrawberryType implements IStringSerializable
    {
        NONE("none"),
        RED("red"),
        WHITE("white");

        private final String name;

        private StrawberryType(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

