/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.common.world.gen;

import com.minecraftabnormals.neapolitan.common.block.StrawberryBushBlock;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanBlocks;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanFeatures;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.registries.ForgeRegistries;

public class NeapolitanBiomeFeatures {
    public static final BlockClusterFeatureConfig STRAWBERRY_PATCH_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider((BlockState)((Block)NeapolitanBlocks.STRAWBERRY_BUSH.get()).func_176223_P().func_206870_a(StrawberryBushBlock.TYPE, (Comparable)((Object)StrawberryBushBlock.StrawberryType.RED))), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(512).func_227322_d_();
    public static final BlockClusterFeatureConfig VANILLA_VINE_PATCH_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)NeapolitanBlocks.VANILLA_VINE.get()).func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(64).func_227322_d_();

    public static void generateFeatures() {
        ForgeRegistries.BIOMES.getValues().forEach(NeapolitanBiomeFeatures::generate);
    }

    public static void generate(Biome biome) {
        if (biome.func_201856_r() == Biome.Category.PLAINS) {
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)NeapolitanFeatures.STRAWBERRY_PATCH.get()).func_225566_b_((IFeatureConfig)STRAWBERRY_PATCH_CONFIG).func_227228_a_(Placement.field_215024_j.func_227446_a_((IPlacementConfig)new ChanceConfig(34))));
        }
        if (biome.func_201856_r() == Biome.Category.SAVANNA) {
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)NeapolitanFeatures.VANILLA_PATCH.get()).func_225566_b_((IFeatureConfig)VANILLA_VINE_PATCH_CONFIG).func_227228_a_(Placement.field_215024_j.func_227446_a_((IPlacementConfig)new ChanceConfig(28))));
        }
        if (biome.func_201856_r() == Biome.Category.BEACH && biome.func_201851_b() == Biome.RainType.RAIN) {
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)NeapolitanFeatures.BANANA_PLANT.get()).func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.15f, 1))));
        }
        if (biome.func_201856_r() == Biome.Category.JUNGLE && biome.func_201851_b() == Biome.RainType.RAIN) {
            if (biome != Biomes.field_150574_L && biome != Biomes.field_185447_Y) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)NeapolitanFeatures.BANANA_PLANT.get()).func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(1, 0.3f, 3))));
            } else if (biome != Biomes.field_222370_aw && biome != Biomes.field_222371_ax) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)NeapolitanFeatures.BANANA_PLANT.get()).func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(1, 0.15f, 2))));
            }
        }
        if (biome.getRegistryName().func_110623_a().contains("rainforest")) {
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)NeapolitanFeatures.BANANA_PLANT.get()).func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(1, 0.1f, 2))));
        }
    }
}

