/*
 * Decompiled with CFR 0.152.
 */
package com.github.wimpingego.nnow.util.loot;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="nnow", bus=Mod.EventBusSubscriber.Bus.MOD)
public class LootDropMods {
    public static final boolean ENABLE = true;

    @SubscribeEvent
    public static void registerModifierSerializers(@Nonnull RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)new DropsConverterModifier.Serializer().setRegistryName(new ResourceLocation("nnow", "hammer_gravel_dust_from_cobblestone")));
        event.getRegistry().register((IForgeRegistryEntry)new DropsConverterModifier.Serializer().setRegistryName(new ResourceLocation("nnow", "hammer_sand_dust_from_gravel")));
        event.getRegistry().register((IForgeRegistryEntry)new DropsConverterModifier.Serializer().setRegistryName(new ResourceLocation("nnow", "hammer_dirt_dust_from_sand")));
        event.getRegistry().register((IForgeRegistryEntry)new DropsConverterModifier.Serializer().setRegistryName(new ResourceLocation("nnow", "hammer_dirt_dust_from_red_sand")));
        event.getRegistry().register((IForgeRegistryEntry)new DropsConverterModifier.Serializer().setRegistryName(new ResourceLocation("nnow", "hammer_clay_ball_from_dirt")));
        event.getRegistry().register((IForgeRegistryEntry)new DropsConverterModifier.Serializer().setRegistryName(new ResourceLocation("nnow", "spade_sand_dust_from_gravel")));
        event.getRegistry().register((IForgeRegistryEntry)new DropsConverterModifier.Serializer().setRegistryName(new ResourceLocation("nnow", "spade_dirt_dust_from_sand")));
        event.getRegistry().register((IForgeRegistryEntry)new DropsConverterModifier.Serializer().setRegistryName(new ResourceLocation("nnow", "spade_dirt_dust_from_red_sand")));
        event.getRegistry().register((IForgeRegistryEntry)new DropsConverterModifier.Serializer().setRegistryName(new ResourceLocation("nnow", "spade_clay_ball_from_dirt")));
        event.getRegistry().register((IForgeRegistryEntry)new SugarCaneDropsSerializer().setRegistryName("nnow", "sugar_cane_drops"));
    }

    private static class SugarCaneDropsSerializer
    extends GlobalLootModifierSerializer<SugarCaneDropsModifier> {
        private SugarCaneDropsSerializer() {
        }

        public SugarCaneDropsModifier read(ResourceLocation location, JsonObject object, ILootCondition[] ailootcondition) {
            return new SugarCaneDropsModifier(ailootcondition);
        }

        public JsonObject write(SugarCaneDropsModifier instance) {
            return null;
        }
    }

    private static class SugarCaneDropsModifier
    extends LootModifier {
        protected SugarCaneDropsModifier(ILootCondition[] conditionsIn) {
            super(conditionsIn);
        }

        protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            generatedLoot.add(new ItemStack((IItemProvider)Items.field_222065_kN));
            return generatedLoot;
        }
    }

    private static class DropsConverterModifier
    extends LootModifier {
        private final int numSeedsToConvert;
        private final Item itemToCheck;
        private final Item itemReward;

        public DropsConverterModifier(ILootCondition[] conditionsIn, int numSeeds, Item itemCheck, Item reward) {
            super(conditionsIn);
            this.numSeedsToConvert = numSeeds;
            this.itemToCheck = itemCheck;
            this.itemReward = reward;
        }

        @Nonnull
        public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            int numSeeds = 0;
            for (ItemStack stack : generatedLoot) {
                if (stack.func_77973_b() != this.itemToCheck) continue;
                numSeeds += stack.func_190916_E();
            }
            if (numSeeds >= this.numSeedsToConvert) {
                generatedLoot.removeIf(x -> x.func_77973_b() == this.itemToCheck);
                generatedLoot.add(new ItemStack((IItemProvider)this.itemReward, numSeeds / this.numSeedsToConvert));
                if ((numSeeds %= this.numSeedsToConvert) > 0) {
                    generatedLoot.add(new ItemStack((IItemProvider)this.itemToCheck, numSeeds));
                }
            }
            return generatedLoot;
        }

        private static class Serializer
        extends GlobalLootModifierSerializer<DropsConverterModifier> {
            private Serializer() {
            }

            public DropsConverterModifier read(ResourceLocation name, JsonObject object, ILootCondition[] conditionsIn) {
                int numSeeds = JSONUtils.func_151203_m((JsonObject)object, (String)"numSeeds");
                Item olddrop = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"seedItem")));
                Item newdrop = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"replacement")));
                return new DropsConverterModifier(conditionsIn, numSeeds, olddrop, newdrop);
            }

            public JsonObject write(DropsConverterModifier instance) {
                JsonObject json = this.makeConditions(instance.conditions);
                json.addProperty("numSeeds", (Number)instance.numSeedsToConvert);
                json.addProperty("seedItem", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)instance.itemToCheck).toString());
                json.addProperty("replacement", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)instance.itemReward).toString());
                return json;
            }
        }
    }
}

