/*
 * Decompiled with CFR 0.152.
 */
package com.vandendaelen.nicephore.client;

import com.vandendaelen.nicephore.client.DeleteConfirmScreen;
import com.vandendaelen.nicephore.helper.PlayerHelper;
import com.vandendaelen.nicephore.util.CopyImageToClipBoard;
import com.vandendaelen.nicephore.util.Util;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.minecraft.class_1060;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.apache.commons.io.FileUtils;

public class ScreenshotScreen
extends class_437 {
    private static final class_2588 TITLE = new class_2588("nicephore.gui.screenshots");
    private static final File SCREENSHOTS_DIR = new File(class_310.method_1551().field_1697, "screenshots");
    private static final class_1060 textureManager = class_310.method_1551().method_1531();
    private static class_2960 SCREENSHOT_TEXTURE;
    private final ArrayList<File> screenshots;
    private static int index;
    private float aspectRatio;

    public ScreenshotScreen() {
        super((class_2561)TITLE);
        FilenameFilter filter = (dir, name) -> name.endsWith(".jpg") || name.endsWith(".png");
        this.screenshots = (ArrayList)Arrays.stream(SCREENSHOTS_DIR.listFiles(filter)).sorted(Comparator.comparingLong(File::lastModified).reversed()).collect(Collectors.toList());
        index = this.getIndex();
        this.aspectRatio = 1.7777f;
    }

    protected void method_25426() {
        super.method_25426();
        if (this.screenshots.isEmpty()) {
            this.closeScreen("nicephore.screenshots.empty");
            return;
        }
        BufferedImage bimg = null;
        try {
            bimg = ImageIO.read(this.screenshots.get(index));
            int width = bimg.getWidth();
            int height = bimg.getHeight();
            bimg.getGraphics().dispose();
            this.aspectRatio = (float)((double)width / (double)height);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        textureManager.method_4615(SCREENSHOT_TEXTURE);
        File fileToLoad = this.screenshots.get(index);
        if (!fileToLoad.exists()) {
            this.closeScreen("nicephore.screenshots.loading.error");
            return;
        }
        SCREENSHOT_TEXTURE = Util.fileToTexture(fileToLoad);
        this.field_22791.clear();
        this.method_25411((class_339)new class_4185(this.field_22789 / 2 + 50, this.field_22790 / 2 + 75, 20, 20, (class_2561)new class_2585(">"), button -> this.modIndex(1)));
        this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 80, this.field_22790 / 2 + 75, 20, 20, (class_2561)new class_2585("<"), button -> this.modIndex(-1)));
        this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 55, this.field_22790 / 2 + 75, 50, 20, (class_2561)new class_2588("nicephore.gui.screenshots.copy"), button -> {
            CopyImageToClipBoard imageToClipBoard = new CopyImageToClipBoard();
            try {
                imageToClipBoard.copyImage(ImageIO.read(this.screenshots.get(index)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }));
        this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 5, this.field_22790 / 2 + 75, 50, 20, (class_2561)new class_2588("nicephore.gui.screenshots.delete"), button -> this.deleteScreenshot(this.screenshots.get(index))));
    }

    private void closeScreen(String textComponentId) {
        this.method_25419();
        PlayerHelper.sendHotbarMessage(new class_2588(textComponentId));
    }

    private void deleteScreenshot(File file) {
        class_310.method_1551().method_1507((class_437)new DeleteConfirmScreen(file));
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(matrixStack);
        super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        textureManager.method_22813(SCREENSHOT_TEXTURE);
        int centerX = this.field_22789 / 2;
        int width = (int)((double)this.field_22789 * 0.5);
        int height = (int)((float)width / this.aspectRatio);
        ScreenshotScreen.method_25290((class_4587)matrixStack, (int)(centerX - width / 2), (int)50, (float)0.0f, (float)0.0f, (int)width, (int)height, (int)width, (int)height);
        ScreenshotScreen.method_27534((class_4587)matrixStack, (class_327)class_310.method_1551().field_1772, (class_2561)new class_2588("nicephore.gui.screenshots.pages", new Object[]{index + 1, this.screenshots.size()}), (int)centerX, (int)20, (int)Color.WHITE.getRGB());
        ScreenshotScreen.method_27534((class_4587)matrixStack, (class_327)class_310.method_1551().field_1772, (class_2561)new class_2585(MessageFormat.format("{0} ({1})", this.screenshots.get(index).getName(), ScreenshotScreen.getFileSizeMegaBytes(this.screenshots.get(index)))), (int)centerX, (int)35, (int)Color.WHITE.getRGB());
    }

    private void modIndex(int value) {
        int max = this.screenshots.size();
        index = index + value >= 0 && index + value < max ? (index += value) : (index + value < 0 ? max - 1 : 0);
        this.method_25426();
    }

    private int getIndex() {
        if (index >= this.screenshots.size() || index < 0) {
            index = this.screenshots.size() - 1;
        }
        return index;
    }

    public static boolean canBeShow() {
        return SCREENSHOTS_DIR.exists() && SCREENSHOTS_DIR.list().length > 0;
    }

    private static String getFileSizeMegaBytes(File file) {
        double size = FileUtils.sizeOf((File)file);
        DecimalFormat formatter = new DecimalFormat("#0.00");
        int MB_SIZE = 0x100000;
        int KB_SIZE = 1024;
        if (size > 1048576.0) {
            return MessageFormat.format("{0} MB", formatter.format((double)FileUtils.sizeOf((File)file) / 1048576.0));
        }
        return MessageFormat.format("{0} KB", formatter.format((double)FileUtils.sizeOf((File)file) / 1024.0));
    }
}

