/*
 * Decompiled with CFR 0.152.
 */
package com.vandendaelen.nicephore.config;

import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@Config(name="nicephore")
public class NicephoreConfig
implements ConfigData {
    @Comment(value="Enable to allow Nicephore to make lossy JPEGs of your screenshots for easier online sharing. Disable to only allow PNGs.\r\nNote that PNGs will still be made regardless of this option.")
    boolean makeJPEGs = true;
    @Comment(value="JPEG compression level, the higher the number, the better the quality.\r\nNote that 1.0 is *not* lossless as JPEG is a lossy-only format, use the PNG files instead if you want lossless.")
    float jpegCompression = 0.9f;
    @Comment(value="Enable to allow Nicephore to losslessly optimise the PNG and JPEG screenshots for smaller sized progressive files that are of identical quality to the files before optimisation.\r\nNote: Enabling this will cause screenshots to take slightly longer to save as an optimisation step will have to be run first.\r\nTip: In the rare case that a screenshot PNG is corrupted, run \"oxipng --fix (filename).png\" to attempt to fix it.")
    boolean optimisedOutput = true;
    @Comment(value="If enabled, a message will appear above your hotbar telling you that has optimisation started and another when finished. Useful for very slow computers.")
    boolean showOptimisationStatus = true;
    @Comment(value="If optimiseScreenshots is enabled, use the following oxipng optimisation level, with higher numbers taking longer to process but give lower file sizes.\r\nTip: I would avoid anything above 3 unless you have a lot of CPU cores and threads (e.g. 16c/32t+) as it starts taking significantly longer to process for vastly diminishing returns.")
    @ConfigEntry.BoundedDiscrete(min=0L, max=5L)
    int pngOptimisationLevel = 3;

    public boolean makeJPEGs() {
        return this.makeJPEGs;
    }

    public float getJpegCompression() {
        return this.jpegCompression;
    }

    public boolean isOptimisedOutput() {
        return this.optimisedOutput;
    }

    public boolean isShowOptimisationStatus() {
        return this.showOptimisationStatus;
    }

    public int getPngOptimisationLevel() {
        return this.pngOptimisationLevel;
    }
}

