/*
 * Decompiled with CFR 0.152.
 */
package com.vandendaelen.nicephore.thread;

import com.vandendaelen.nicephore.config.NicephoreConfig;
import com.vandendaelen.nicephore.helper.PlayerHelper;
import com.vandendaelen.nicephore.util.CopyImageToClipBoard;
import com.vandendaelen.nicephore.util.Reference;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.class_1011;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2588;
import net.minecraft.class_5250;

public final class JPEGThread
extends Thread {
    private final class_1011 image;
    private final File screenshot;

    public JPEGThread(class_1011 image, File screenshot) {
        this.image = image;
        this.screenshot = screenshot;
    }

    @Override
    public void run() {
        NicephoreConfig config = (NicephoreConfig)AutoConfig.getConfigHolder(NicephoreConfig.class).getConfig();
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.image.method_24036());
            BufferedImage png = ImageIO.read(bais);
            File jpegFile = new File(this.screenshot.getParentFile(), this.screenshot.getName().replace("png", "jpg"));
            BufferedImage result = new BufferedImage(png.getWidth(), png.getHeight(), 1);
            result.createGraphics().drawImage(png, 0, 0, Color.WHITE, null);
            if (config.makeJPEGs()) {
                ImageWriter writer = ImageIO.getImageWritersByFormatName("jpg").next();
                ImageWriteParam params = writer.getDefaultWriteParam();
                params.setCompressionMode(2);
                params.setProgressiveMode(1);
                params.setCompressionQuality(config.getJpegCompression());
                writer.setOutput(new FileImageOutputStream(jpegFile));
                writer.write(null, new IIOImage(result, null, null), params);
            }
            if (config.isOptimisedOutput()) {
                if (config.isShowOptimisationStatus()) {
                    PlayerHelper.sendHotbarMessage(new class_2588("nicephore.screenshot.optimize"));
                }
                if (config.makeJPEGs()) {
                    try {
                        File ect = new File(String.format("mods%snicephore%s", File.separator, File.separator) + Reference.File.ECT);
                        Process p = Runtime.getRuntime().exec(MessageFormat.format(Reference.Command.ECT, ect, jpegFile));
                        p.waitFor();
                    }
                    catch (IOException | InterruptedException ect) {
                        // empty catch block
                    }
                }
                try {
                    File oxipng = new File(String.format("mods%snicephore%s", File.separator, File.separator) + Reference.File.OXIPNG);
                    File pngFile = new File(this.screenshot.getParentFile(), this.screenshot.getName());
                    Process p = Runtime.getRuntime().exec(MessageFormat.format(Reference.Command.OXIPNG, oxipng, config.getPngOptimisationLevel(), pngFile));
                    p.waitFor();
                }
                catch (IOException | InterruptedException oxipng) {
                    // empty catch block
                }
                if (config.isShowOptimisationStatus()) {
                    PlayerHelper.sendHotbarMessage(new class_2588("nicephore.screenshot.optimizeFinished"));
                }
            }
            CopyImageToClipBoard.setLastScreenshot(this.screenshot);
            class_5250 pngComponent = new class_2588("nicephore.screenshot.png").method_27692(class_124.field_1073).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11746, this.screenshot.getAbsolutePath())));
            class_5250 jpgComponent = new class_2588("nicephore.screenshot.jpg").method_27692(class_124.field_1073).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11746, jpegFile.getAbsolutePath())));
            class_5250 folderComponent = new class_2588("nicephore.screenshot.folder").method_27692(class_124.field_1073).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11746, this.screenshot.getParent())));
            if (config.makeJPEGs()) {
                PlayerHelper.sendMessage(new class_2588("nicephore.screenshot.options", new Object[]{pngComponent, jpgComponent, folderComponent}));
            } else {
                PlayerHelper.sendMessage(new class_2588("nicephore.screenshot.reducedOptions", new Object[]{pngComponent, folderComponent}));
            }
        }
        catch (IOException e) {
            PlayerHelper.sendMessage(new class_2588("nicephore.screenshot.error"));
        }
    }
}

