/*
 * Decompiled with CFR 0.152.
 */
package com.vandendaelen.nicephore.util;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class CopyImageToClipBoard
implements ClipboardOwner {
    private static File lastScreenshot = null;

    public static void setLastScreenshot(File screenshot) {
        lastScreenshot = screenshot;
    }

    public void copyImage(BufferedImage bi) {
        TransferableImage trans = new TransferableImage(bi);
        Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
        c.setContents(trans, this);
    }

    public void copyLastScreenshot() throws IOException {
        if (lastScreenshot == null) {
            throw new IOException("No screenshot taken");
        }
        this.copyImage(ImageIO.read(lastScreenshot));
    }

    @Override
    public void lostOwnership(Clipboard clip, Transferable trans) {
        System.out.println("Lost Clipboard Ownership");
    }

    private static class TransferableImage
    implements Transferable {
        final Image i;

        public TransferableImage(Image i) {
            this.i = i;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(DataFlavor.imageFlavor) && this.i != null) {
                return this.i;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor};
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            DataFlavor[] flavors;
            for (DataFlavor dataFlavor : flavors = this.getTransferDataFlavors()) {
                if (!flavor.equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }
    }
}

