/*
 * Decompiled with CFR 0.152.
 */
package com.hugman.dawn.api.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.hugman.dawn.Dawn;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import net.minecraft.class_2960;

public class DataSerialization {
    public static final Gson RAW_GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).excludeFieldsWithoutExposeAnnotation().create();
    public static final Gson PRETTY_GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().create();

    public static <T> T loadFromFile(File f, Class<? extends T> clazz, Supplier<T> baseCase) {
        return DataSerialization.loadFromFile(PRETTY_GSON, f, clazz, baseCase);
    }

    public static <T> T loadFromFile(Gson gson, File f, Class<? extends T> clazz, Supplier<T> baseCase) {
        try {
            if (!f.exists()) {
                T t = baseCase.get();
                DataSerialization.saveToFile(gson, f, clazz, t);
                return t;
            }
            FileInputStream in = new FileInputStream(f);
            return (T)gson.fromJson((Reader)new InputStreamReader((InputStream)in, StandardCharsets.UTF_8), clazz);
        }
        catch (IOException e) {
            Dawn.LOGGER.error("Failed to load file", (Throwable)e);
            return null;
        }
    }

    public static <T> void saveToFile(File f, Class<? extends T> clazz, T obj) {
        DataSerialization.saveToFile(PRETTY_GSON, f, clazz, obj);
    }

    public static <T> void saveToFile(Gson gson, File f, Class<? extends T> clazz, T obj) {
        String json = gson.toJson(obj, clazz);
        try {
            f.createNewFile();
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(f));){
                writer.write(json);
            }
        }
        catch (IOException e) {
            Dawn.LOGGER.error("Failed to save file", (Throwable)e);
        }
    }
}

