/*
 * Decompiled with CFR 0.152.
 */
package com.hugman.dawn.api.util.debug;

import com.google.gson.annotations.Expose;
import com.hugman.dawn.Dawn;
import com.hugman.dawn.api.util.DataSerialization;
import com.hugman.dawn.api.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class EntryDebugWriter {
    protected Map<class_2960, EntryData> map = new HashMap<class_2960, EntryData>();
    protected final File entriesPath = new File("debug/entries");

    public final void load() {
        for (class_2378 registry : class_2378.field_11144) {
            for (class_2960 entryID : registry.method_10235()) {
                EntryData data;
                class_2960 registryID = new class_2960(entryID.method_12836(), registry.method_30517().method_29177().method_12832());
                if (this.map.containsKey(registryID)) {
                    data = this.map.get(registryID);
                } else {
                    data = new EntryData(registryID);
                    this.map.put(registryID, data);
                }
                data.add(entryID);
            }
        }
        Dawn.LOGGER.info("Created debug entry files");
    }

    private static final File getFile(String filePath) {
        FileUtil.createDirectories(FileUtil.getParentPath(filePath));
        return new File(filePath);
    }

    public final class EntryData {
        private final File file;
        @Expose
        protected int count;
        @Expose
        protected List<String> values = new ArrayList<String>();

        protected EntryData(class_2960 registryID) {
            String path = EntryDebugWriter.this.entriesPath.getPath() + "/" + registryID.method_12836() + "/" + registryID.method_12832() + ".json";
            this.file = EntryDebugWriter.getFile(path);
        }

        public void add(class_2960 identifier) {
            this.values.add(identifier.toString());
            ++this.count;
            this.save();
        }

        public void save() {
            DataSerialization.saveToFile(this.file, EntryData.class, this);
        }

        public void delete() {
            this.file.delete();
        }
    }
}

