/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft;

import com.song.nuclear_craft.blocks.BlockList;
import com.song.nuclear_craft.blocks.container.ContainerTypeList;
import com.song.nuclear_craft.blocks.tileentity.TileEntityList;
import com.song.nuclear_craft.entities.EntityList;
import com.song.nuclear_craft.entities.renderers.AtomicBombRenderer;
import com.song.nuclear_craft.items.ItemList;
import com.song.nuclear_craft.misc.Config;
import com.song.nuclear_craft.network.NuclearCraftPacketHandler;
import com.song.nuclear_craft.particles.NukeParticle;
import com.song.nuclear_craft.particles.ParticleList;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.ParticleType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="nuclear_craft")
public class NuclearCraft {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "nuclear_craft";
    public static final ItemGroup ITEM_GROUP = new ItemGroup(ItemGroup.field_78032_a.length, "nuclear_craft"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)Items.field_221649_bM);
        }
    };
    public static KeyBinding keyBinding;

    public NuclearCraft() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        NuclearCraftPacketHandler.register();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.CONFIG);
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM PREINIT");
        LOGGER.info("DIRT BLOCK >> {}", (Object)Blocks.field_150346_d.getRegistryName());
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        LOGGER.info("Got game settings {}", (Object)((Minecraft)event.getMinecraftSupplier().get()).field_71474_y);
        keyBinding = new KeyBinding("key.load_ammo", 82, "key.categories.weapons");
        ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"examplemod", (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
            LOGGER.info("HELLO from Register Block");
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{BlockList.C4_ATOMIC_BOMB, BlockList.C4_HIGH_EXPLOSIVE, BlockList.C4_INCENDIARY, BlockList.C4_SMOKE});
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
            LOGGER.info("HELLO from Register Item");
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{ItemList.ATOMIC_BOMB_ROCKET, ItemList.ROCKET_LAUNCHER, ItemList.ROCKET_LAUNCHER_ATOMIC_BOMB, ItemList.ROCKET_CONTROL_UNIT, ItemList.URANIUM_235, ItemList.URANIUM_238, ItemList.INCENDIARY_ROCKET, ItemList.SMOKE_ROCKET, ItemList.ROCKET_LAUNCHER_INCENDIARY, ItemList.ROCKET_LAUNCHER_SMOKE, ItemList.HIGH_EXPLOSIVE_ROCKET, ItemList.ROCKET_LAUNCHER_HIGH_EXPLOSIVE, ItemList.C4_ATOMIC_BOMB, ItemList.C4_HIGH_EXPLOSIVE, ItemList.C4_INCENDIARY, ItemList.C4_SMOKE});
        }

        @SubscribeEvent
        public static void onEntityRegistry(RegistryEvent.Register<EntityType<?>> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{EntityList.ATOMIC_BOMB_ENTITY});
            RenderingRegistry.registerEntityRenderingHandler(EntityList.ATOMIC_BOMB_ENTITY, AtomicBombRenderer::new);
        }

        @SubscribeEvent
        public static void onTileEntityRegistry(RegistryEvent.Register<TileEntityType<?>> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new TileEntityType[]{TileEntityList.C4_ATOMIC_BOMB_TE_TYPE, TileEntityList.C4_HIGH_EXPLOSIVE_TE_TYPE, TileEntityList.C4_INCENDIARY_TE_TYPE, TileEntityList.C4_SMOKE_TE_TYPE});
        }

        @SubscribeEvent
        public static void onParticleRegistry(RegistryEvent.Register<ParticleType<?>> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new ParticleType[]{ParticleList.NUKE_PARTICLE_SMOKE, ParticleList.NUKE_PARTICLE_FIRE, ParticleList.BIG_SMOKE});
        }

        @SubscribeEvent
        public static void onParticleFactoryRegistry(ParticleFactoryRegisterEvent event) {
            Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleList.NUKE_PARTICLE_SMOKE, NukeParticle.NukeParticleFactory::new);
            Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleList.NUKE_PARTICLE_FIRE, NukeParticle.NukeParticleFactory::new);
            Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleList.BIG_SMOKE, NukeParticle.BigSmokeFactory::new);
        }

        @SubscribeEvent
        public static void onContainerTypeRegistry(RegistryEvent.Register<ContainerType<?>> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new ContainerType[]{ContainerTypeList.C4_BOMB_CONTAINER_TYPE});
        }
    }
}

