/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.items;

import com.song.nuclear_craft.NuclearCraft;
import com.song.nuclear_craft.items.ItemList;
import com.song.nuclear_craft.misc.SoundEventList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public abstract class RocketLauncherWithAmmo
extends Item {
    protected int MAX_AMMO = 10;
    protected Item BONDED_AMMO = null;

    public RocketLauncherWithAmmo(Item.Properties properties) {
        super(properties);
    }

    protected int getAmmoCount(ItemStack itemStack) {
        CompoundNBT compoundnbt = itemStack.func_196082_o();
        if (!compoundnbt.func_74764_b("ammo")) {
            compoundnbt.func_74768_a("ammo", this.MAX_AMMO);
        }
        return compoundnbt.func_74762_e("ammo");
    }

    protected void addAmmoCount(ItemStack itemStack, int n) {
        CompoundNBT compoundnbt = itemStack.func_196082_o();
        assert (compoundnbt.func_74764_b("ammo"));
        compoundnbt.func_74768_a("ammo", n + compoundnbt.func_74762_e("ammo"));
    }

    public void clearAmmo(ItemStack itemStack) {
        this.addAmmoCount(itemStack, -this.getAmmoCount(itemStack));
    }

    protected ActionResult<ItemStack> afterFire(World worldIn, ItemStack thisItemStack) {
        CompoundNBT compoundnbt = thisItemStack.func_196082_o();
        if (!compoundnbt.func_74764_b("ammo")) {
            compoundnbt.func_74768_a("ammo", this.MAX_AMMO);
        }
        if (!worldIn.field_72995_K) {
            int n_ammo = compoundnbt.func_74762_e("ammo");
            compoundnbt.func_74768_a("ammo", --n_ammo);
        }
        if (compoundnbt.func_74762_e("ammo") <= 0) {
            return ActionResult.func_233538_a_((Object)new ItemStack((IItemProvider)ItemList.ROCKET_LAUNCHER), (boolean)worldIn.func_201670_d());
        }
        return ActionResult.func_233538_a_((Object)thisItemStack, (boolean)worldIn.func_201670_d());
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        int n_ammo = this.getAmmoCount(stack);
        tooltip.add((ITextComponent)new TranslationTextComponent(String.format("item.%s.rocket_launcher.ammo_left", "nuclear_craft")).func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new StringTextComponent("" + n_ammo).func_240699_a_(TextFormatting.GOLD));
    }

    protected void addAmmo(ItemStack ammo, ItemStack rocket, int itemSlot, Entity entityIn) {
        int n_ammo;
        if (this.BONDED_AMMO != null && ammo.func_77973_b().getRegistryName().equals((Object)this.BONDED_AMMO.getRegistryName()) && (n_ammo = this.getAmmoCount(rocket)) < this.MAX_AMMO) {
            int n_loaded = Math.min(this.MAX_AMMO - n_ammo, ammo.func_190916_E());
            ammo.func_190918_g(n_loaded);
            this.addAmmoCount(rocket, n_loaded);
            entityIn.field_70170_p.func_184148_a(null, entityIn.func_226277_ct_(), entityIn.func_226278_cu_(), entityIn.func_226281_cx_(), SoundEventList.LOADING, SoundCategory.PLAYERS, 0.3f, 1.0f);
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        ItemStack itemStackMain;
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (isSelected && !worldIn.field_72995_K && NuclearCraft.keyBinding.func_151468_f() && entityIn instanceof PlayerEntity && (itemStackMain = ((PlayerEntity)entityIn).func_184614_ca()).func_77973_b() instanceof RocketLauncherWithAmmo) {
            ItemStack itemStackOff = ((PlayerEntity)entityIn).func_184592_cb();
            this.addAmmo(itemStackOff, itemStackMain, itemSlot, entityIn);
        }
    }
}

